/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.mongodb.query.parsing;

import com.mongodb.DBObject;
import java.util.List;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.ConjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.DisjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.InPredicate;
import org.hibernate.hql.ast.spi.predicate.IsNullPredicate;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegationPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.hql.ast.spi.predicate.RangePredicate;
import org.hibernate.hql.ast.spi.predicate.RootPredicate;
import org.hibernate.ogm.dialect.mongodb.query.parsing.MongoDBPropertyHelper;
import org.hibernate.ogm.dialect.mongodb.query.parsing.predicate.MongoDBComparisonPredicate;
import org.hibernate.ogm.dialect.mongodb.query.parsing.predicate.MongoDBConjunctionPredicate;
import org.hibernate.ogm.dialect.mongodb.query.parsing.predicate.MongoDBDisjunctionPredicate;
import org.hibernate.ogm.dialect.mongodb.query.parsing.predicate.MongoDBInPredicate;
import org.hibernate.ogm.dialect.mongodb.query.parsing.predicate.MongoDBIsNullPredicate;
import org.hibernate.ogm.dialect.mongodb.query.parsing.predicate.MongoDBLikePredicate;
import org.hibernate.ogm.dialect.mongodb.query.parsing.predicate.MongoDBNegationPredicate;
import org.hibernate.ogm.dialect.mongodb.query.parsing.predicate.MongoDBRangePredicate;
import org.hibernate.ogm.dialect.mongodb.query.parsing.predicate.MongoDBRootPredicate;

public class MongoDBPredicateFactory
implements PredicateFactory<DBObject> {
    private final MongoDBPropertyHelper propertyHelper;

    public MongoDBPredicateFactory(MongoDBPropertyHelper propertyHelper) {
        this.propertyHelper = propertyHelper;
    }

    public RootPredicate<DBObject> getRootPredicate(Class<?> entityType) {
        return new MongoDBRootPredicate();
    }

    public ComparisonPredicate<DBObject> getComparisonPredicate(Class<?> entityType, ComparisonPredicate.Type comparisonType, List<String> propertyPath, Object value) {
        String columnName = this.propertyHelper.getColumnName(entityType, propertyPath.get(propertyPath.size() - 1));
        return new MongoDBComparisonPredicate(columnName, comparisonType, value);
    }

    public RangePredicate<DBObject> getRangePredicate(Class<?> entityType, List<String> propertyPath, Object lowerValue, Object upperValue) {
        String columnName = this.propertyHelper.getColumnName(entityType, propertyPath.get(propertyPath.size() - 1));
        return new MongoDBRangePredicate(columnName, lowerValue, upperValue);
    }

    public NegationPredicate<DBObject> getNegationPredicate() {
        return new MongoDBNegationPredicate();
    }

    public DisjunctionPredicate<DBObject> getDisjunctionPredicate() {
        return new MongoDBDisjunctionPredicate();
    }

    public ConjunctionPredicate<DBObject> getConjunctionPredicate() {
        return new MongoDBConjunctionPredicate();
    }

    public InPredicate<DBObject> getInPredicate(Class<?> entityType, List<String> propertyPath, List<Object> typedElements) {
        String columnName = this.propertyHelper.getColumnName(entityType, propertyPath.get(propertyPath.size() - 1));
        return new MongoDBInPredicate(columnName, typedElements);
    }

    public IsNullPredicate<DBObject> getIsNullPredicate(Class<?> entityType, List<String> propertyPath) {
        String columnName = this.propertyHelper.getColumnName(entityType, propertyPath.get(propertyPath.size() - 1));
        return new MongoDBIsNullPredicate(columnName);
    }

    public LikePredicate<DBObject> getLikePredicate(Class<?> entityType, List<String> propertyPath, String patternValue, Character escapeCharacter) {
        String columnName = this.propertyHelper.getColumnName(entityType, propertyPath.get(propertyPath.size() - 1));
        return new MongoDBLikePredicate(columnName, patternValue, escapeCharacter);
    }
}

