/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.mongodb.query.parsing;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.Type;

public class MongoDBPropertyHelper
implements PropertyHelper {
    private final SessionFactoryImplementor sessionFactory;

    public MongoDBPropertyHelper(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Object convertToPropertyType(Class<?> entityType, List<String> propertyPath, String value) {
        if (propertyPath.size() > 1) {
            throw new UnsupportedOperationException("Queries on embedded/associated entities are not supported yet.");
        }
        OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(entityType.getName());
        Type propertyType = persister.getPropertyType(propertyPath.get(propertyPath.size() - 1));
        if (propertyType instanceof AbstractStandardBasicType) {
            return ((AbstractStandardBasicType)propertyType).fromString(value);
        }
        return value;
    }

    public String getColumnName(Class<?> entityType, String propertyName) {
        String columnName = propertyName;
        OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(entityType.getName());
        if (columnName.equals(persister.getIdentifierPropertyName())) {
            columnName = "_id";
        } else {
            String[] columnNames = persister.getPropertyColumnNames(columnName);
            columnName = columnNames[0];
        }
        return columnName;
    }
}

