/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.mongodb.query;

import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.AbstractQueryImpl;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBResultTupleIterable;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.hibernatecore.impl.OgmSession;
import org.hibernate.ogm.loader.OgmLoader;
import org.hibernate.ogm.loader.OgmLoadingContext;
import org.hibernate.ogm.persister.OgmEntityPersister;

public class MongoDBQueryImpl
extends AbstractQueryImpl {
    private final DBObject query;
    private final MongoDBDatastoreProvider provider;
    private final Class<?> entityType;
    private final DBObject projections;

    public MongoDBQueryImpl(Class<?> entityType, DBObject query, DBObject projections, OgmSession session) {
        super(query.toString(), null, (SessionImplementor)session, new ParameterMetadata(null, null));
        this.query = query;
        this.entityType = entityType;
        this.projections = projections;
        this.provider = (MongoDBDatastoreProvider)session.getSessionFactory().getServiceRegistry().getService(DatastoreProvider.class);
    }

    public Iterator<?> iterate() throws HibernateException {
        MongoDBResultTupleIterable resultsCursor = this.getResultsCursor();
        return new ObjectLoadingIterator(resultsCursor);
    }

    public ScrollableResults scroll() throws HibernateException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public List<?> list() throws HibernateException {
        Iterator<?> results = this.iterate();
        ArrayList result = new ArrayList();
        while (results.hasNext()) {
            result.add(results.next());
        }
        return result;
    }

    private boolean isProjection() {
        return !this.projections.keySet().isEmpty();
    }

    public int executeUpdate() throws HibernateException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Query setLockOptions(LockOptions lockOptions) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public LockOptions getLockOptions() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private MongoDBResultTupleIterable getResultsCursor() {
        EntityKeyMetadata keyMetaData = this.getKeyMetaData(this.entityType);
        DBCollection collection = this.provider.getDatabase().getCollection(keyMetaData.getTable());
        DBCursor cursor = this.isProjection() ? collection.find(this.query, this.projections) : collection.find(this.query);
        return new MongoDBResultTupleIterable(cursor, keyMetaData);
    }

    private EntityKeyMetadata getKeyMetaData(Class<?> entityType) {
        OgmEntityPersister persister = (OgmEntityPersister)this.session.getFactory().getEntityPersister(entityType.getName());
        return new EntityKeyMetadata(persister.getTableName(), persister.getRootTableIdentifierColumnNames());
    }

    private class ObjectLoadingIterator
    implements Iterator<Object> {
        private final Iterator<Tuple> resultIterator;

        private ObjectLoadingIterator(MongoDBResultTupleIterable resultsCursor) {
            this.resultIterator = resultsCursor.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.resultIterator.hasNext();
        }

        @Override
        public Object next() {
            Tuple next = this.resultIterator.next();
            if (MongoDBQueryImpl.this.isProjection()) {
                return this.getAsProjection(next);
            }
            return this.getAsManagedEntity(next);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        private Object getAsManagedEntity(Tuple tuple) {
            OgmEntityPersister persister = (OgmEntityPersister)MongoDBQueryImpl.this.session.getFactory().getEntityPersister(MongoDBQueryImpl.this.entityType.getName());
            OgmLoader loader = new OgmLoader(new OgmEntityPersister[]{persister});
            OgmLoadingContext ogmLoadingContext = new OgmLoadingContext();
            ogmLoadingContext.setTuples(Arrays.asList(tuple));
            return loader.loadEntities(MongoDBQueryImpl.this.session, LockOptions.NONE, ogmLoadingContext).iterator().next();
        }

        private Object[] getAsProjection(Tuple tuple) {
            Object[] projectionResult = new Object[MongoDBQueryImpl.this.projections.keySet().size()];
            int i = 0;
            for (String column : MongoDBQueryImpl.this.projections.keySet()) {
                projectionResult[i] = tuple.get(column);
                ++i;
            }
            return projectionResult;
        }
    }
}

