/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.impl.AssociationStorageOption;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MassIndexingMongoDBTupleSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoDBAssociationSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoDBTupleSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoHelpers;
import org.hibernate.ogm.datastore.mongodb.impl.AssociationStorageStrategy;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.options.AssociationDocumentType;
import org.hibernate.ogm.datastore.mongodb.options.impl.AssociationDocumentStorageOption;
import org.hibernate.ogm.datastore.mongodb.type.impl.ByteStringType;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.AssociationOperation;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.datastore.spi.TupleOperation;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.dialect.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.Operation;
import org.hibernate.ogm.dialect.batch.OperationsQueue;
import org.hibernate.ogm.dialect.batch.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.batch.RemoveTupleOperation;
import org.hibernate.ogm.dialect.batch.UpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.UpdateTupleOperation;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.massindex.batchindexing.Consumer;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.type.StringCalendarDateType;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class MongoDBDialect
implements BatchableGridDialect {
    public static final String ID_FIELDNAME = "_id";
    public static final String PROPERTY_SEPARATOR = ".";
    public static final String SEQUENCE_VALUE = "sequence_value";
    public static final String ROWS_FIELDNAME = "rows";
    public static final String TABLE_FIELDNAME = "table";
    public static final String ASSOCIATIONS_COLLECTION_PREFIX = "associations_";
    private static final Log log = LoggerFactory.getLogger();
    private static final Integer ONE = 1;
    private static final Pattern DOT_SEPARATOR_PATTERN = Pattern.compile("\\.");
    private static final List<String> ROWS_FIELDNAME_LIST = Collections.singletonList("rows");
    private final MongoDBDatastoreProvider provider;
    private final DB currentDB;

    public MongoDBDialect(MongoDBDatastoreProvider provider) {
        this.provider = provider;
        this.currentDB = this.provider.getDatabase();
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        throw new UnsupportedOperationException("The MongoDB GridDialect does not support locking");
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        DBObject found = this.getObject(key, tupleContext);
        if (found != null) {
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(found, key, MongoDBTupleSnapshot.SnapshotType.UPDATE));
        }
        if (this.isInTheQueue(key, tupleContext)) {
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot((DBObject)this.prepareIdObject(key), key, MongoDBTupleSnapshot.SnapshotType.INSERT));
        }
        return null;
    }

    private boolean isInTheQueue(EntityKey key, TupleContext tupleContext) {
        OperationsQueue queue = tupleContext.getOperationsQueue();
        return queue != null && queue.contains(key);
    }

    public Tuple createTuple(EntityKey key) {
        BasicDBObject toSave = this.prepareIdObject(key);
        return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot((DBObject)toSave, key, MongoDBTupleSnapshot.SnapshotType.INSERT));
    }

    private DBObject getObjectAsEmbeddedAssociation(AssociationKey key) {
        DBCollection collection = this.getCollection(key.getEntityKey());
        BasicDBObject searchObject = this.prepareIdObject(key.getEntityKey());
        DBObject restrictionObject = this.getSearchObject(key, true);
        return collection.findOne((DBObject)searchObject, restrictionObject);
    }

    private DBObject getObject(EntityKey key, TupleContext tupleContext) {
        DBCollection collection = this.getCollection(key);
        BasicDBObject searchObject = this.prepareIdObject(key);
        BasicDBObject restrictionObject = this.getSearchObject(tupleContext);
        return collection.findOne((DBObject)searchObject, (DBObject)restrictionObject);
    }

    private BasicDBObject getSearchObject(TupleContext tupleContext) {
        return this.getSearchObject(tupleContext.getSelectableColumns());
    }

    private BasicDBObject getSearchObject(List<String> selectedColumns) {
        BasicDBObject searchObject = new BasicDBObject();
        for (String column : selectedColumns) {
            searchObject.append(column, (Object)1);
        }
        return searchObject;
    }

    private BasicDBObject prepareIdObject(EntityKey key) {
        return this.prepareIdObject(key.getColumnNames(), key.getColumnValues());
    }

    private BasicDBObject prepareIdObject(RowKey key) {
        return this.prepareIdObject(key.getColumnNames(), key.getColumnValues());
    }

    private BasicDBObject prepareIdObject(String[] columnNames, Object[] columnValues) {
        BasicDBObject object;
        if (columnNames.length == 1) {
            object = new BasicDBObject(ID_FIELDNAME, columnValues[0]);
        } else {
            object = new BasicDBObject();
            BasicDBObject idObject = new BasicDBObject();
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                Object columnValue = columnValues[i];
                if (columnName.contains(PROPERTY_SEPARATOR)) {
                    int dotIndex = columnName.indexOf(PROPERTY_SEPARATOR);
                    String shortColumnName = columnName.substring(dotIndex + 1);
                    idObject.put(shortColumnName, columnValue);
                    continue;
                }
                idObject.put(columnNames[i], columnValue);
            }
            object.put(ID_FIELDNAME, (Object)idObject);
        }
        return object;
    }

    private DBCollection getCollection(String table) {
        return this.currentDB.getCollection(table);
    }

    private DBCollection getCollection(EntityKey key) {
        return this.getCollection(key.getTable());
    }

    private DBCollection getAssociationCollection(AssociationKey key, AssociationStorageStrategy storageStrategy) {
        if (storageStrategy.isGlobalCollection()) {
            return this.getCollection("Associations");
        }
        return this.getCollection(ASSOCIATIONS_COLLECTION_PREFIX + key.getTable());
    }

    private BasicDBObject getSubQuery(String operator, BasicDBObject query) {
        return query.get(operator) != null ? (BasicDBObject)query.get(operator) : new BasicDBObject();
    }

    private void addSubQuery(String operator, BasicDBObject query, String column, Object value) {
        BasicDBObject subQuery = this.getSubQuery(operator, query);
        query.append(operator, (Object)subQuery.append(column, value));
    }

    public void updateTuple(Tuple tuple, EntityKey key) {
        BasicDBObject idObject = this.prepareIdObject(key);
        DBObject updater = this.objectForUpdate(tuple, key, (DBObject)idObject);
        this.getCollection(key).update((DBObject)idObject, updater, true, false);
    }

    private DBObject objectForInsert(Tuple tuple, EntityKey key, BasicDBObject dbObject) {
        MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tuple.getSnapshot();
        for (TupleOperation operation : tuple.getOperations()) {
            String column = operation.getColumn();
            if (!this.notInIdField(snapshot, column)) continue;
            switch (operation.getType()) {
                case PUT_NULL: 
                case PUT: {
                    dbObject.append(column, operation.getValue());
                    break;
                }
                case REMOVE: {
                    dbObject.remove((Object)column);
                }
            }
        }
        return dbObject;
    }

    private DBObject objectForUpdate(Tuple tuple, EntityKey key, DBObject idObject) {
        MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tuple.getSnapshot();
        BasicDBObject updater = new BasicDBObject();
        for (TupleOperation operation : tuple.getOperations()) {
            String column = operation.getColumn();
            if (!this.notInIdField(snapshot, column)) continue;
            switch (operation.getType()) {
                case PUT_NULL: 
                case PUT: {
                    this.addSubQuery("$set", updater, column, operation.getValue());
                    break;
                }
                case REMOVE: {
                    this.addSubQuery("$unset", updater, column, ONE);
                }
            }
        }
        if (updater.size() == 0) {
            return idObject;
        }
        return updater;
    }

    private boolean notInIdField(MongoDBTupleSnapshot snapshot, String column) {
        return !column.equals(ID_FIELDNAME) && !column.endsWith("._id") && !snapshot.columnInIdField(column);
    }

    public void removeTuple(EntityKey key) {
        DBCollection collection = this.getCollection(key);
        BasicDBObject toDelete = this.prepareIdObject(key);
        collection.remove((DBObject)toDelete);
    }

    private DBObject findAssociation(AssociationKey key, AssociationStorageStrategy storageStrategy) {
        DBObject associationKeyObject = this.associationKeyToObject(key, storageStrategy);
        return this.getAssociationCollection(key, storageStrategy).findOne(associationKeyObject, this.getSearchObject(key, false));
    }

    private DBObject getSearchObject(AssociationKey key, boolean embedded) {
        if (embedded) {
            return this.getSearchObject(Collections.singletonList(key.getCollectionRole()));
        }
        return this.getSearchObject(ROWS_FIELDNAME_LIST);
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(key, associationContext);
        this.executeBatch(associationContext.getOperationsQueue());
        if (storageStrategy.isEmbeddedInEntity()) {
            DBObject entity = this.getObjectAsEmbeddedAssociation(key);
            if (this.getAssociationFieldOrNull(key, entity) != null) {
                return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(entity, key, storageStrategy));
            }
            return null;
        }
        DBObject result = this.findAssociation(key, storageStrategy);
        if (result == null) {
            return null;
        }
        return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(result, key, storageStrategy));
    }

    private DBObject getAssociationFieldOrNull(AssociationKey key, DBObject entity) {
        String[] path = DOT_SEPARATOR_PATTERN.split(key.getCollectionRole());
        DBObject field = entity;
        for (String node : path) {
            field = field != null ? (DBObject)field.get(node) : null;
        }
        return field;
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(key, associationContext);
        if (storageStrategy.isEmbeddedInEntity()) {
            DBObject entity = this.getObjectAsEmbeddedAssociation(key);
            boolean insert = false;
            if (entity == null) {
                insert = true;
                entity = this.prepareIdObject(key.getEntityKey());
            }
            if (this.getAssociationFieldOrNull(key, entity) == null) {
                if (insert) {
                    MongoHelpers.addEmptyAssociationField(key, entity);
                    this.getCollection(key.getEntityKey()).insert(new DBObject[]{entity});
                } else {
                    BasicDBObject updater = new BasicDBObject();
                    this.addSubQuery("$set", updater, key.getCollectionRole(), Collections.EMPTY_LIST);
                    this.getCollection(key.getEntityKey()).update(entity, (DBObject)updater, true, false);
                    MongoHelpers.addEmptyAssociationField(key, entity);
                }
            }
            return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(entity, key, storageStrategy));
        }
        DBCollection associations = this.getAssociationCollection(key, storageStrategy);
        DBObject assoc = this.associationKeyToObject(key, storageStrategy);
        assoc.put(ROWS_FIELDNAME, (Object)Collections.EMPTY_LIST);
        associations.insert(new DBObject[]{assoc});
        return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(assoc, key, storageStrategy));
    }

    private DBObject removeAssociationRowKey(MongoDBAssociationSnapshot snapshot, RowKey rowKey, String associationField) {
        BasicDBObject pull = new BasicDBObject(associationField, (Object)snapshot.getRowKeyDBObject(rowKey));
        return new BasicDBObject("$pull", (Object)pull);
    }

    private DBObject putAssociationRowKey(Tuple value, String associationField, AssociationKey associationKey) {
        BasicDBObject rowTupleMap = new BasicDBObject();
        for (String valueKeyName : value.getColumnNames()) {
            boolean add = true;
            for (String assocColumn : associationKey.getColumnNames()) {
                if (!valueKeyName.equals(assocColumn)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            rowTupleMap.put(valueKeyName, value.get(valueKeyName));
        }
        BasicDBObject row = rowTupleMap;
        return new BasicDBObject("$push", (Object)new BasicDBObject(associationField, (Object)row));
    }

    public void updateAssociation(Association association, AssociationKey key, AssociationContext associationContext) {
        String associationField;
        DBObject query;
        DBCollection collection;
        MongoDBAssociationSnapshot assocSnapshot = (MongoDBAssociationSnapshot)association.getSnapshot();
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(key, associationContext);
        this.executeBatch(associationContext.getOperationsQueue());
        if (storageStrategy.isEmbeddedInEntity()) {
            collection = this.getCollection(key.getEntityKey());
            query = this.prepareIdObject(key.getEntityKey());
            associationField = key.getCollectionRole();
        } else {
            collection = this.getAssociationCollection(key, storageStrategy);
            query = assocSnapshot.getQueryObject();
            associationField = ROWS_FIELDNAME;
        }
        for (AssociationOperation action : association.getOperations()) {
            RowKey rowKey = action.getKey();
            Tuple rowValue = action.getValue();
            DBObject update = null;
            switch (action.getType()) {
                case CLEAR: {
                    update = new BasicDBObject("$set", (Object)new BasicDBObject(associationField, (Object)Collections.EMPTY_LIST));
                    break;
                }
                case PUT_NULL: 
                case PUT: {
                    update = this.putAssociationRowKey(rowValue, associationField, key);
                    break;
                }
                case REMOVE: {
                    update = this.removeAssociationRowKey(assocSnapshot, rowKey, associationField);
                }
            }
            if (update == null) continue;
            collection.update(query, update, true, false);
        }
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(key, associationContext);
        if (storageStrategy.isEmbeddedInEntity()) {
            BasicDBObject entity = this.prepareIdObject(key.getEntityKey());
            if (entity != null) {
                BasicDBObject updater = new BasicDBObject();
                this.addSubQuery("$unset", updater, key.getCollectionRole(), ONE);
                this.getCollection(key.getEntityKey()).update((DBObject)entity, (DBObject)updater, true, false);
            }
        } else {
            DBCollection collection = this.getAssociationCollection(key, storageStrategy);
            DBObject query = this.associationKeyToObject(key, storageStrategy);
            int nAffected = collection.remove(query).getN();
            log.removedAssociation(nAffected);
        }
    }

    public Tuple createTupleAssociation(AssociationKey associationKey, RowKey rowKey) {
        return new Tuple();
    }

    public void nextValue(RowKey key, IntegralDataTypeHolder value, int increment, int initialValue) {
        Object idFromDB;
        DBCollection currentCollection = this.currentDB.getCollection(key.getTable());
        BasicDBObject query = this.prepareIdObject(key);
        BasicDBObject update = new BasicDBObject();
        Integer incrementObject = increment == 1 ? ONE : Integer.valueOf(increment);
        this.addSubQuery("$inc", update, SEQUENCE_VALUE, incrementObject);
        DBObject result = currentCollection.findAndModify((DBObject)query, null, null, false, (DBObject)update, false, true);
        Object object = idFromDB = result == null ? null : result.get(SEQUENCE_VALUE);
        if (idFromDB == null) {
            BasicDBObject updateForInitial = new BasicDBObject();
            this.addSubQuery("$inc", updateForInitial, SEQUENCE_VALUE, initialValue);
            currentCollection.findAndModify((DBObject)query, null, null, false, (DBObject)updateForInitial, false, true);
            idFromDB = initialValue;
        } else {
            idFromDB = result.get(SEQUENCE_VALUE);
        }
        if (!idFromDB.getClass().equals(Integer.class) && !idFromDB.getClass().equals(Long.class)) {
            throw new HibernateException("Cannot increment a non numeric field");
        }
        Number id = (Number)idFromDB;
        value.initialize(id.longValue());
    }

    public boolean isStoredInEntityStructure(AssociationKey associationKey, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(associationKey, associationContext);
        return storageStrategy.isEmbeddedInEntity();
    }

    public GridType overrideType(Type type) {
        if (type == StandardBasicTypes.CALENDAR || type == StandardBasicTypes.CALENDAR_DATE) {
            return StringCalendarDateType.INSTANCE;
        }
        if (type == StandardBasicTypes.BYTE) {
            return ByteStringType.INSTANCE;
        }
        return null;
    }

    public void forEachTuple(Consumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        DB db = this.provider.getDatabase();
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            DBCollection collection = db.getCollection(entityKeyMetadata.getTable());
            for (DBObject dbObject : collection.find()) {
                consumer.consume(new Tuple((TupleSnapshot)new MassIndexingMongoDBTupleSnapshot(dbObject, entityKeyMetadata)));
            }
        }
    }

    public Iterator<Tuple> executeBackendQuery(CustomQuery customQuery, EntityKeyMetadata[] metadatas) {
        BasicDBObject mongodbQuery = (BasicDBObject)JSON.parse((String)customQuery.getSQL());
        this.validate(metadatas);
        DBCollection collection = this.provider.getDatabase().getCollection(metadatas[0].getTable());
        DBCursor cursor = collection.find((DBObject)mongodbQuery);
        return new MongoDBResultsCursor(cursor, metadatas[0]);
    }

    private void validate(EntityKeyMetadata[] metadatas) {
        if (metadatas.length != 1) {
            throw log.requireMetadatas();
        }
    }

    private DBObject associationKeyToObject(AssociationKey key, AssociationStorageStrategy storageStrategy) {
        if (storageStrategy.isEmbeddedInEntity()) {
            throw new AssertionFailure(MongoHelpers.class.getName() + ".associationKeyToObject should not be called for associations embedded in entity documents");
        }
        Object[] columnValues = key.getColumnValues();
        BasicDBObject columns = new BasicDBObject(columnValues.length);
        int i = 0;
        for (String name : key.getColumnNames()) {
            columns.put(name, columnValues[i++]);
        }
        BasicDBObject idObject = new BasicDBObject(1);
        if (storageStrategy.isGlobalCollection()) {
            columns.put(TABLE_FIELDNAME, (Object)key.getTable());
        }
        idObject.put(ID_FIELDNAME, (Object)columns);
        return idObject;
    }

    private AssociationStorageStrategy getAssociationStorageStrategy(AssociationKey key, AssociationContext associationContext) {
        AssociationDocumentType associationDocumentType;
        AssociationStorageType associationStorage = (AssociationStorageType)associationContext.getOptionsContext().getUnique(AssociationStorageOption.class);
        if (associationStorage == null) {
            associationStorage = this.provider.getAssociationStorage();
        }
        if ((associationDocumentType = (AssociationDocumentType)((Object)associationContext.getOptionsContext().getUnique(AssociationDocumentStorageOption.class))) == null) {
            associationDocumentType = this.provider.getAssociationDocumentStorage();
        }
        return AssociationStorageStrategy.getInstance(key.getAssociationKind(), associationStorage, associationDocumentType);
    }

    private boolean columnNamesAllowBatchInsert(UpdateTupleOperation tupleOperation) {
        Set columnNames = tupleOperation.getTuple().getColumnNames();
        for (String column : columnNames) {
            if (!column.contains(PROPERTY_SEPARATOR) && !column.contains("$")) continue;
            return false;
        }
        return true;
    }

    public void executeBatch(OperationsQueue queue) {
        if (!queue.isClosed()) {
            Operation operation = queue.poll();
            HashMap<DBCollection, Map<DBObject, DBObject>> inserts = new HashMap<DBCollection, Map<DBObject, DBObject>>();
            while (operation != null) {
                UpdateTupleOperation update;
                if (operation instanceof UpdateTupleOperation) {
                    update = (UpdateTupleOperation)operation;
                    this.executeBatchUpdate(inserts, update);
                } else if (operation instanceof RemoveTupleOperation) {
                    RemoveTupleOperation tupleOp = (RemoveTupleOperation)operation;
                    this.executeBatchRemove(inserts, tupleOp);
                } else if (operation instanceof UpdateAssociationOperation) {
                    update = (UpdateAssociationOperation)operation;
                    this.updateAssociation(update.getAssociation(), update.getAssociationKey(), update.getContext());
                } else if (operation instanceof RemoveAssociationOperation) {
                    RemoveAssociationOperation remove = (RemoveAssociationOperation)operation;
                    this.removeAssociation(remove.getAssociationKey(), remove.getContext());
                } else {
                    throw new UnsupportedOperationException("Operation not supported on MongoDB: " + operation.getClass().getName());
                }
                operation = queue.poll();
            }
            this.flushInserts(inserts);
            queue.close();
        }
    }

    private void executeBatchRemove(Map<DBCollection, Map<DBObject, DBObject>> inserts, RemoveTupleOperation tupleOperation) {
        EntityKey entityKey = tupleOperation.getEntityKey();
        DBCollection collection = this.getCollection(entityKey);
        BasicDBObject idObject = this.prepareIdObject(entityKey);
        Map<DBObject, DBObject> documents = inserts.get(collection);
        if (documents != null && documents.containsKey(idObject)) {
            documents.remove(entityKey);
        } else {
            this.removeTuple(entityKey);
        }
    }

    private void executeBatchUpdate(Map<DBCollection, Map<DBObject, DBObject>> inserts, UpdateTupleOperation tupleOperation) {
        EntityKey entityKey = tupleOperation.getEntityKey();
        Tuple tuple = tupleOperation.getTuple();
        MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tupleOperation.getTuple().getSnapshot();
        if (MongoDBTupleSnapshot.SnapshotType.INSERT == snapshot.getOperationType() && this.columnNamesAllowBatchInsert(tupleOperation)) {
            this.prepareForInsert(inserts, snapshot, entityKey, tuple);
        } else {
            this.updateTuple(tuple, entityKey);
        }
    }

    private void prepareForInsert(Map<DBCollection, Map<DBObject, DBObject>> inserts, MongoDBTupleSnapshot snapshot, EntityKey entityKey, Tuple tuple) {
        DBCollection collection = this.getCollection(entityKey);
        Map<DBObject, DBObject> documents = this.getOrCreateDocuments(inserts, collection);
        BasicDBObject idObject = this.prepareIdObject(entityKey);
        DBObject document = this.getCurrentDocument(snapshot, (DBObject)idObject, documents);
        DBObject newDocument = this.objectForInsert(tuple, entityKey, (BasicDBObject)document);
        inserts.get(collection).put((DBObject)idObject, newDocument);
    }

    private DBObject getCurrentDocument(MongoDBTupleSnapshot snapshot, DBObject idObject, Map<DBObject, DBObject> documents) {
        if (documents.containsKey(idObject)) {
            return documents.get(idObject);
        }
        return snapshot.getDbObject();
    }

    private Map<DBObject, DBObject> getOrCreateDocuments(Map<DBCollection, Map<DBObject, DBObject>> inserts, DBCollection collection) {
        if (!inserts.containsKey(collection)) {
            HashMap map = new HashMap();
            inserts.put(collection, map);
        }
        Map<DBObject, DBObject> documents = inserts.get(collection);
        return documents;
    }

    private void flushInserts(Map<DBCollection, Map<DBObject, DBObject>> inserts) {
        for (Map.Entry<DBCollection, Map<DBObject, DBObject>> entry : inserts.entrySet()) {
            DBCollection collection = entry.getKey();
            Collection<DBObject> documents = entry.getValue().values();
            collection.insert(new ArrayList<DBObject>(documents));
        }
        inserts.clear();
    }

    private static class MongoDBResultsCursor
    implements Iterator<Tuple>,
    Closeable {
        private final DBCursor cursor;
        private final EntityKeyMetadata metadata;

        public MongoDBResultsCursor(DBCursor cursor, EntityKeyMetadata metadata) {
            this.cursor = cursor;
            this.metadata = metadata;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        @Override
        public Tuple next() {
            DBObject dbObject = this.cursor.next();
            return new Tuple((TupleSnapshot)new MassIndexingMongoDBTupleSnapshot(dbObject, this.metadata));
        }

        @Override
        public void remove() {
            this.cursor.remove();
        }

        @Override
        public void close() throws IOException {
            this.cursor.close();
        }
    }
}

