/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.impl;

import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.mongodb.options.AssociationDocumentType;
import org.hibernate.ogm.grid.AssociationKind;

public class AssociationStorageStrategy {
    private final boolean isEmbeddedInEntity;
    private final boolean isGlobalCollection;

    private AssociationStorageStrategy(boolean isEmbeddedInEntity, boolean isGlobalCollection) {
        this.isEmbeddedInEntity = isEmbeddedInEntity;
        this.isGlobalCollection = isGlobalCollection;
    }

    public static AssociationStorageStrategy getInstance(AssociationKind associationKind, AssociationStorageType associationStorage, AssociationDocumentType associationDocumentStorage) {
        if (associationKind == AssociationKind.EMBEDDED_COLLECTION || associationStorage == AssociationStorageType.IN_ENTITY) {
            return new AssociationStorageStrategy(true, false);
        }
        if (associationDocumentStorage == AssociationDocumentType.COLLECTION_PER_ASSOCIATION) {
            return new AssociationStorageStrategy(false, false);
        }
        return new AssociationStorageStrategy(false, true);
    }

    public boolean isEmbeddedInEntity() {
        return this.isEmbeddedInEntity;
    }

    public boolean isGlobalCollection() {
        return this.isGlobalCollection;
    }

    public boolean isCollectionPerAssociation() {
        return !this.isEmbeddedInEntity && !this.isGlobalCollection;
    }
}

