/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.dialect.impl;

import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.grid.EntityKey;

public class MongoDBTupleSnapshot
implements TupleSnapshot {
    public static final Pattern EMBEDDED_FIELDNAME_SEPARATOR = Pattern.compile("\\.");
    private final DBObject dbObject;
    private final List<String> columnNames;
    private final SnapshotType operationType;

    public MongoDBTupleSnapshot(DBObject dbObject, EntityKey entityKey, SnapshotType operationType) {
        this.dbObject = dbObject;
        this.operationType = operationType;
        this.columnNames = Arrays.asList(entityKey.getColumnNames());
    }

    public Object get(String column) {
        if (column.contains(".")) {
            String[] fields = EMBEDDED_FIELDNAME_SEPARATOR.split(column, 0);
            return this.getObject(this.dbObject.toMap(), fields, 0);
        }
        return this.dbObject.get(column);
    }

    public Set<String> getColumnNames() {
        return this.dbObject.keySet();
    }

    public DBObject getDbObject() {
        return this.dbObject;
    }

    private Object getObject(Map<?, ?> fields, String[] remainingFields, int startIndex) {
        if (startIndex == remainingFields.length - 1) {
            return fields.get(remainingFields[startIndex]);
        }
        Map subMap = (Map)fields.get(remainingFields[startIndex]);
        if (subMap != null) {
            return this.getObject(subMap, remainingFields, ++startIndex);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.dbObject.keySet().isEmpty();
    }

    public boolean columnInIdField(String column) {
        return this.columnNames == null ? false : this.columnNames.contains(column);
    }

    public SnapshotType getOperationType() {
        return this.operationType;
    }

    public static enum SnapshotType {
        INSERT,
        UPDATE;

    }
}

