/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.impl;

import com.mongodb.DBObject;

public class MongoDBQueryDescriptor {
    private final String collectionName;
    private final Operation operation;
    private final DBObject criteria;
    private final DBObject projection;
    private final DBObject orderBy;

    public MongoDBQueryDescriptor(String collectionName, DBObject criteria) {
        this(collectionName, Operation.FIND, criteria, null, null);
    }

    public MongoDBQueryDescriptor(String collectionName, Operation operation, DBObject criteria, DBObject projection, DBObject orderBy) {
        this.collectionName = collectionName;
        this.operation = operation;
        this.criteria = criteria;
        this.projection = projection;
        this.orderBy = orderBy;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public DBObject getCriteria() {
        return this.criteria;
    }

    public DBObject getProjection() {
        return this.projection;
    }

    public DBObject getOrderBy() {
        return this.orderBy;
    }

    public String toString() {
        return "MongoDBQueryDescriptor [collectionName=" + this.collectionName + ", where=" + this.criteria + ", projection=" + this.projection + ", orderBy=" + this.orderBy + "]";
    }

    public static enum Operation {
        FIND,
        COUNT;

    }
}

