/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.impl.AssociationStorageOption;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.AssociationStorageStrategy;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.BatchableMongoDBTupleSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoDBAssociationSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoDBTupleSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoHelpers;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.options.AssociationDocumentType;
import org.hibernate.ogm.datastore.mongodb.options.impl.AssociationDocumentStorageOption;
import org.hibernate.ogm.datastore.mongodb.options.impl.ReadPreferenceOption;
import org.hibernate.ogm.datastore.mongodb.options.impl.WriteConcernOption;
import org.hibernate.ogm.datastore.mongodb.query.impl.MongoDBQueryDescriptor;
import org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl.MongoDBQueryDescriptorBuilder;
import org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl.NativeQueryParser;
import org.hibernate.ogm.datastore.mongodb.type.impl.ByteStringType;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.GridDialectOperationContext;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.datastore.spi.TupleOperation;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.dialect.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.Operation;
import org.hibernate.ogm.dialect.batch.OperationsQueue;
import org.hibernate.ogm.dialect.batch.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.batch.RemoveTupleOperation;
import org.hibernate.ogm.dialect.batch.UpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.UpdateTupleOperation;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.QueryableGridDialect;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.grid.Key;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.id.spi.NextValueRequest;
import org.hibernate.ogm.massindex.batchindexing.Consumer;
import org.hibernate.ogm.query.NoOpParameterMetadataBuilder;
import org.hibernate.ogm.query.spi.BackendQuery;
import org.hibernate.ogm.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.type.StringCalendarDateType;
import org.hibernate.ogm.util.ClosableIterator;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.parboiled.Parboiled;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.RecoveringParseRunner;
import org.parboiled.support.ParsingResult;

public class MongoDBDialect
extends BaseGridDialect
implements QueryableGridDialect<MongoDBQueryDescriptor>,
BatchableGridDialect {
    public static final String ID_FIELDNAME = "_id";
    public static final String PROPERTY_SEPARATOR = ".";
    public static final String ROWS_FIELDNAME = "rows";
    public static final String TABLE_FIELDNAME = "table";
    public static final String ASSOCIATIONS_COLLECTION_PREFIX = "associations_";
    private static final Log log = LoggerFactory.getLogger();
    private static final Pattern DOT_SEPARATOR_PATTERN = Pattern.compile("\\.");
    private static final List<String> ROWS_FIELDNAME_LIST = Collections.singletonList("rows");
    private final MongoDBDatastoreProvider provider;
    private final DB currentDB;

    public MongoDBDialect(MongoDBDatastoreProvider provider) {
        this.provider = provider;
        this.currentDB = this.provider.getDatabase();
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        throw new UnsupportedOperationException("The MongoDB GridDialect does not support locking");
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        DBObject found = this.getObject(key, tupleContext);
        if (found != null) {
            return new Tuple((TupleSnapshot)new BatchableMongoDBTupleSnapshot(found, key, BatchableMongoDBTupleSnapshot.SnapshotType.UPDATE));
        }
        if (this.isInTheQueue(key, tupleContext)) {
            return new Tuple((TupleSnapshot)new BatchableMongoDBTupleSnapshot((DBObject)this.prepareIdObject((Key)key), key, BatchableMongoDBTupleSnapshot.SnapshotType.INSERT));
        }
        return null;
    }

    private boolean isInTheQueue(EntityKey key, TupleContext tupleContext) {
        OperationsQueue queue = tupleContext.getOperationsQueue();
        return queue != null && queue.contains(key);
    }

    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        BasicDBObject toSave = this.prepareIdObject((Key)key);
        return new Tuple((TupleSnapshot)new BatchableMongoDBTupleSnapshot((DBObject)toSave, key, BatchableMongoDBTupleSnapshot.SnapshotType.INSERT));
    }

    private DBObject getEmbeddingEntity(AssociationKey key, AssociationContext associationContext) {
        ReadPreference readPreference = this.getReadPreference((GridDialectOperationContext)associationContext);
        DBCollection collection = this.getCollection(key.getEntityKey());
        BasicDBObject searchObject = this.prepareIdObject((Key)key.getEntityKey());
        DBObject projection = this.getProjection(key, true);
        return collection.findOne((DBObject)searchObject, projection, readPreference);
    }

    private DBObject getObject(EntityKey key, TupleContext tupleContext) {
        ReadPreference readPreference = this.getReadPreference((GridDialectOperationContext)tupleContext);
        DBCollection collection = this.getCollection(key);
        BasicDBObject searchObject = this.prepareIdObject((Key)key);
        BasicDBObject projection = this.getProjection(tupleContext);
        return collection.findOne((DBObject)searchObject, (DBObject)projection, readPreference);
    }

    private BasicDBObject getProjection(TupleContext tupleContext) {
        return this.getProjection(tupleContext.getSelectableColumns());
    }

    private BasicDBObject getProjection(List<String> fieldNames) {
        BasicDBObject projection = new BasicDBObject(fieldNames.size());
        for (String column : fieldNames) {
            projection.put(column, (Object)1);
        }
        return projection;
    }

    private BasicDBObject prepareIdObject(Key key) {
        return this.prepareIdObject(key.getColumnNames(), key.getColumnValues());
    }

    private BasicDBObject prepareIdObject(String[] columnNames, Object[] columnValues) {
        BasicDBObject object;
        if (columnNames.length == 1) {
            object = new BasicDBObject(ID_FIELDNAME, columnValues[0]);
        } else {
            object = new BasicDBObject();
            BasicDBObject idObject = new BasicDBObject();
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                Object columnValue = columnValues[i];
                if (columnName.contains(PROPERTY_SEPARATOR)) {
                    int dotIndex = columnName.indexOf(PROPERTY_SEPARATOR);
                    String shortColumnName = columnName.substring(dotIndex + 1);
                    idObject.put(shortColumnName, columnValue);
                    continue;
                }
                idObject.put(columnNames[i], columnValue);
            }
            object.put(ID_FIELDNAME, (Object)idObject);
        }
        return object;
    }

    private DBCollection getCollection(String table) {
        return this.currentDB.getCollection(table);
    }

    private DBCollection getCollection(EntityKey key) {
        return this.getCollection(key.getTable());
    }

    private DBCollection getAssociationCollection(AssociationKey key, AssociationStorageStrategy storageStrategy) {
        if (storageStrategy == AssociationStorageStrategy.GLOBAL_COLLECTION) {
            return this.getCollection("Associations");
        }
        return this.getCollection(ASSOCIATIONS_COLLECTION_PREFIX + key.getTable());
    }

    private BasicDBObject getSubQuery(String operator, BasicDBObject query) {
        return query.get(operator) != null ? (BasicDBObject)query.get(operator) : new BasicDBObject();
    }

    private void addSubQuery(String operator, BasicDBObject query, String column, Object value) {
        BasicDBObject subQuery = this.getSubQuery(operator, query);
        query.append(operator, (Object)subQuery.append(column, value));
    }

    public void updateTuple(Tuple tuple, EntityKey key, TupleContext tupleContext) {
        BasicDBObject idObject = this.prepareIdObject((Key)key);
        DBObject updater = this.objectForUpdate(tuple, key, (DBObject)idObject);
        WriteConcern writeConcern = this.getWriteConcern((GridDialectOperationContext)tupleContext);
        this.getCollection(key).update((DBObject)idObject, updater, true, false, writeConcern);
    }

    private DBObject objectForInsert(Tuple tuple, DBObject dbObject) {
        BatchableMongoDBTupleSnapshot snapshot = (BatchableMongoDBTupleSnapshot)tuple.getSnapshot();
        for (TupleOperation operation : tuple.getOperations()) {
            String column = operation.getColumn();
            if (!this.notInIdField(snapshot, column)) continue;
            switch (operation.getType()) {
                case PUT_NULL: 
                case PUT: {
                    dbObject.put(column, operation.getValue());
                    break;
                }
                case REMOVE: {
                    dbObject.removeField(column);
                }
            }
        }
        return dbObject;
    }

    private DBObject objectForUpdate(Tuple tuple, EntityKey key, DBObject idObject) {
        BatchableMongoDBTupleSnapshot snapshot = (BatchableMongoDBTupleSnapshot)tuple.getSnapshot();
        BasicDBObject updater = new BasicDBObject();
        for (TupleOperation operation : tuple.getOperations()) {
            String column = operation.getColumn();
            if (!this.notInIdField(snapshot, column)) continue;
            switch (operation.getType()) {
                case PUT_NULL: 
                case PUT: {
                    this.addSubQuery("$set", updater, column, operation.getValue());
                    break;
                }
                case REMOVE: {
                    this.addSubQuery("$unset", updater, column, 1);
                }
            }
        }
        if (updater.size() == 0) {
            return idObject;
        }
        return updater;
    }

    private boolean notInIdField(BatchableMongoDBTupleSnapshot snapshot, String column) {
        return !column.equals(ID_FIELDNAME) && !column.endsWith("._id") && !snapshot.isKeyColumn(column);
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        DBCollection collection = this.getCollection(key);
        BasicDBObject toDelete = this.prepareIdObject((Key)key);
        WriteConcern writeConcern = this.getWriteConcern((GridDialectOperationContext)tupleContext);
        collection.remove((DBObject)toDelete, writeConcern);
    }

    private DBObject findAssociation(AssociationKey key, AssociationContext associationContext, AssociationStorageStrategy storageStrategy) {
        ReadPreference readPreference = this.getReadPreference((GridDialectOperationContext)associationContext);
        DBObject associationKeyObject = this.associationKeyToObject(key, storageStrategy);
        return this.getAssociationCollection(key, storageStrategy).findOne(associationKeyObject, this.getProjection(key, false), readPreference);
    }

    private DBObject getProjection(AssociationKey key, boolean embedded) {
        if (embedded) {
            return this.getProjection(Collections.singletonList(key.getCollectionRole()));
        }
        return this.getProjection(ROWS_FIELDNAME_LIST);
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(key, associationContext);
        this.executeBatch(associationContext.getOperationsQueue());
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            DBObject entity = this.getEmbeddingEntity(key, associationContext);
            if (this.getAssociationFieldOrNull(key, entity) != null) {
                return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(entity, key, storageStrategy));
            }
            return null;
        }
        DBObject result = this.findAssociation(key, associationContext, storageStrategy);
        if (result == null) {
            return null;
        }
        return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(result, key, storageStrategy));
    }

    private DBObject getAssociationFieldOrNull(AssociationKey key, DBObject entity) {
        String[] path = DOT_SEPARATOR_PATTERN.split(key.getCollectionRole());
        DBObject field = entity;
        for (String node : path) {
            field = field != null ? (DBObject)field.get(node) : null;
        }
        return field;
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(key, associationContext);
        WriteConcern writeConcern = this.getWriteConcern((GridDialectOperationContext)associationContext);
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            DBObject entity = this.getEmbeddingEntity(key, associationContext);
            boolean insert = false;
            if (entity == null) {
                insert = true;
                entity = this.prepareIdObject((Key)key.getEntityKey());
            }
            if (this.getAssociationFieldOrNull(key, entity) == null) {
                if (insert) {
                    MongoHelpers.addEmptyAssociationField(key, entity);
                    this.getCollection(key.getEntityKey()).insert(entity, writeConcern);
                } else {
                    BasicDBObject updater = new BasicDBObject();
                    this.addSubQuery("$set", updater, key.getCollectionRole(), Collections.EMPTY_LIST);
                    this.getCollection(key.getEntityKey()).update(entity, (DBObject)updater, true, false, writeConcern);
                    MongoHelpers.addEmptyAssociationField(key, entity);
                }
            }
            return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(entity, key, storageStrategy));
        }
        DBCollection associations = this.getAssociationCollection(key, storageStrategy);
        DBObject assoc = this.associationKeyToObject(key, storageStrategy);
        assoc.put(ROWS_FIELDNAME, (Object)Collections.EMPTY_LIST);
        associations.insert(assoc, writeConcern);
        return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(assoc, key, storageStrategy));
    }

    private List<?> getAssociationRows(Association association, AssociationKey key) {
        ArrayList<Object> rows = new ArrayList<Object>(association.getKeys().size());
        for (RowKey rowKey : association.getKeys()) {
            rows.add(this.getAssociationRow(association.get(rowKey), key));
        }
        return rows;
    }

    private Object getAssociationRow(Tuple row, AssociationKey associationKey) {
        String[] rowKeyColumnsToPersist = associationKey.getMetadata().getColumnsWithoutKeyColumns((Iterable)row.getColumnNames());
        if (rowKeyColumnsToPersist.length == 1) {
            return row.get(rowKeyColumnsToPersist[0]);
        }
        BasicDBObject rowObject = new BasicDBObject(rowKeyColumnsToPersist.length);
        for (String column : rowKeyColumnsToPersist) {
            rowObject.put(column, row.get(column));
        }
        return rowObject;
    }

    public void updateAssociation(Association association, AssociationKey key, AssociationContext associationContext) {
        String associationField;
        DBObject query;
        DBCollection collection;
        MongoDBAssociationSnapshot assocSnapshot = (MongoDBAssociationSnapshot)association.getSnapshot();
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(key, associationContext);
        WriteConcern writeConcern = this.getWriteConcern((GridDialectOperationContext)associationContext);
        this.executeBatch(associationContext.getOperationsQueue());
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            collection = this.getCollection(key.getEntityKey());
            query = this.prepareIdObject((Key)key.getEntityKey());
            associationField = key.getCollectionRole();
        } else {
            collection = this.getAssociationCollection(key, storageStrategy);
            query = assocSnapshot.getQueryObject();
            associationField = ROWS_FIELDNAME;
        }
        List<?> rows = this.getAssociationRows(association, key);
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject(associationField, rows));
        collection.update(query, (DBObject)update, true, false, writeConcern);
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = this.getAssociationStorageStrategy(key, associationContext);
        WriteConcern writeConcern = this.getWriteConcern((GridDialectOperationContext)associationContext);
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            BasicDBObject entity = this.prepareIdObject((Key)key.getEntityKey());
            if (entity != null) {
                BasicDBObject updater = new BasicDBObject();
                this.addSubQuery("$unset", updater, key.getCollectionRole(), 1);
                this.getCollection(key.getEntityKey()).update((DBObject)entity, (DBObject)updater, true, false, writeConcern);
            }
        } else {
            DBCollection collection = this.getAssociationCollection(key, storageStrategy);
            DBObject query = this.associationKeyToObject(key, storageStrategy);
            int nAffected = collection.remove(query, writeConcern).getN();
            log.removedAssociation(nAffected);
        }
    }

    public Tuple createTupleAssociation(AssociationKey associationKey, RowKey rowKey) {
        return new Tuple();
    }

    public Number nextValue(NextValueRequest request) {
        Object idFromDB;
        DBCollection currentCollection = this.getCollection(request.getKey().getTable());
        BasicDBObject query = this.prepareIdObject((Key)request.getKey());
        String valueColumnName = request.getKey().getMetadata().getValueColumnName();
        BasicDBObject update = new BasicDBObject();
        Integer incrementObject = request.getIncrement();
        this.addSubQuery("$inc", update, valueColumnName, incrementObject);
        DBObject result = currentCollection.findAndModify((DBObject)query, null, null, false, (DBObject)update, false, true);
        Object object = idFromDB = result == null ? null : result.get(valueColumnName);
        if (idFromDB == null) {
            BasicDBObject updateForInitial = new BasicDBObject();
            this.addSubQuery("$inc", updateForInitial, valueColumnName, request.getInitialValue());
            currentCollection.findAndModify((DBObject)query, null, null, false, (DBObject)updateForInitial, false, true);
            idFromDB = request.getInitialValue();
        } else {
            idFromDB = result.get(valueColumnName);
        }
        if (idFromDB.getClass().equals(Integer.class) || idFromDB.getClass().equals(Long.class)) {
            Number id = (Number)idFromDB;
            return id;
        }
        throw new HibernateException("Cannot increment a non numeric field");
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean isStoredInEntityStructure(AssociationKey associationKey, AssociationContext associationContext) {
        return this.getAssociationStorageStrategy(associationKey, associationContext) == AssociationStorageStrategy.IN_ENTITY;
    }

    public GridType overrideType(Type type) {
        if (type == StandardBasicTypes.CALENDAR || type == StandardBasicTypes.CALENDAR_DATE) {
            return StringCalendarDateType.INSTANCE;
        }
        if (type == StandardBasicTypes.BYTE) {
            return ByteStringType.INSTANCE;
        }
        return null;
    }

    public void forEachTuple(Consumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        DB db = this.provider.getDatabase();
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            DBCollection collection = db.getCollection(entityKeyMetadata.getTable());
            for (DBObject dbObject : collection.find()) {
                consumer.consume(new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(dbObject, entityKeyMetadata)));
            }
        }
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<MongoDBQueryDescriptor> backendQuery, QueryParameters queryParameters) {
        MongoDBQueryDescriptor queryDescriptor = (MongoDBQueryDescriptor)backendQuery.getQuery();
        EntityKeyMetadata entityKeyMetadata = backendQuery.getSingleEntityKeyMetadataOrNull();
        String collectionName = this.getCollectionName(backendQuery, queryDescriptor, entityKeyMetadata);
        DBCollection collection = this.provider.getDatabase().getCollection(collectionName);
        switch (queryDescriptor.getOperation()) {
            case FIND: {
                return this.doFind(queryDescriptor, queryParameters, collection, entityKeyMetadata);
            }
            case COUNT: {
                return this.doCount(queryDescriptor, collection);
            }
        }
        throw new IllegalArgumentException("Unexpected query operation: " + queryDescriptor);
    }

    public MongoDBQueryDescriptor parseNativeQuery(String nativeQuery) {
        NativeQueryParser parser = (NativeQueryParser)Parboiled.createParser(NativeQueryParser.class, (Object[])new Object[0]);
        ParsingResult parseResult = new RecoveringParseRunner(parser.Query()).run(nativeQuery);
        if (parseResult.hasErrors()) {
            throw new IllegalArgumentException("Unsupported native query: " + ErrorUtils.printParseErrors((List)parseResult.parseErrors));
        }
        return ((MongoDBQueryDescriptorBuilder)parseResult.resultValue).build();
    }

    private ClosableIterator<Tuple> doFind(MongoDBQueryDescriptor query, QueryParameters queryParameters, DBCollection collection, EntityKeyMetadata entityKeyMetadata) {
        DBCursor cursor = collection.find(query.getCriteria(), query.getProjection());
        if (query.getOrderBy() != null) {
            cursor.sort(query.getOrderBy());
        }
        if (queryParameters.getRowSelection().getFirstRow() != null) {
            cursor.skip(queryParameters.getRowSelection().getFirstRow().intValue());
        }
        if (queryParameters.getRowSelection().getMaxRows() != null) {
            cursor.limit(queryParameters.getRowSelection().getMaxRows().intValue());
        }
        return new MongoDBResultsCursor(cursor, entityKeyMetadata);
    }

    private ClosableIterator<Tuple> doCount(MongoDBQueryDescriptor query, DBCollection collection) {
        long count = collection.count(query.getCriteria());
        MapTupleSnapshot snapshot = new MapTupleSnapshot(Collections.singletonMap("n", count));
        return CollectionHelper.newClosableIterator(Collections.singletonList(new Tuple((TupleSnapshot)snapshot)));
    }

    private String getCollectionName(BackendQuery<?> customQuery, MongoDBQueryDescriptor queryDescriptor, EntityKeyMetadata entityKeyMetadata) {
        if (queryDescriptor.getCollectionName() != null) {
            return queryDescriptor.getCollectionName();
        }
        if (entityKeyMetadata != null) {
            return entityKeyMetadata.getTable();
        }
        throw log.unableToDetermineCollectionName(customQuery.getQuery().toString());
    }

    private DBObject associationKeyToObject(AssociationKey key, AssociationStorageStrategy storageStrategy) {
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            throw new AssertionFailure(MongoHelpers.class.getName() + ".associationKeyToObject should not be called for associations embedded in entity documents");
        }
        Object[] columnValues = key.getColumnValues();
        BasicDBObject columns = new BasicDBObject(columnValues.length);
        int i = 0;
        for (String name : key.getColumnNames()) {
            columns.put(name, columnValues[i++]);
        }
        BasicDBObject idObject = new BasicDBObject(1);
        if (storageStrategy == AssociationStorageStrategy.GLOBAL_COLLECTION) {
            columns.put(TABLE_FIELDNAME, (Object)key.getTable());
        }
        idObject.put(ID_FIELDNAME, (Object)columns);
        return idObject;
    }

    private AssociationStorageStrategy getAssociationStorageStrategy(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageType associationStorage = (AssociationStorageType)associationContext.getOptionsContext().getUnique(AssociationStorageOption.class);
        AssociationDocumentType associationDocumentType = (AssociationDocumentType)((Object)associationContext.getOptionsContext().getUnique(AssociationDocumentStorageOption.class));
        return AssociationStorageStrategy.getInstance(key.getAssociationKind(), associationStorage, associationDocumentType);
    }

    private boolean columnNamesAllowBatchInsert(UpdateTupleOperation tupleOperation) {
        Set columnNames = tupleOperation.getTuple().getColumnNames();
        for (String column : columnNames) {
            if (!column.contains(PROPERTY_SEPARATOR) && !column.contains("$")) continue;
            return false;
        }
        return true;
    }

    public void executeBatch(OperationsQueue queue) {
        if (!queue.isClosed()) {
            Operation operation = queue.poll();
            HashMap<DBCollection, BatchInsertionTask> inserts = new HashMap<DBCollection, BatchInsertionTask>();
            while (operation != null) {
                UpdateTupleOperation update;
                if (operation instanceof UpdateTupleOperation) {
                    update = (UpdateTupleOperation)operation;
                    this.executeBatchUpdate(inserts, update);
                } else if (operation instanceof RemoveTupleOperation) {
                    RemoveTupleOperation tupleOp = (RemoveTupleOperation)operation;
                    this.executeBatchRemove(inserts, tupleOp);
                } else if (operation instanceof UpdateAssociationOperation) {
                    update = (UpdateAssociationOperation)operation;
                    this.updateAssociation(update.getAssociation(), update.getAssociationKey(), update.getContext());
                } else if (operation instanceof RemoveAssociationOperation) {
                    RemoveAssociationOperation remove = (RemoveAssociationOperation)operation;
                    this.removeAssociation(remove.getAssociationKey(), remove.getContext());
                } else {
                    throw new UnsupportedOperationException("Operation not supported on MongoDB: " + operation.getClass().getName());
                }
                operation = queue.poll();
            }
            this.flushInserts(inserts);
            queue.close();
        }
    }

    private void executeBatchRemove(Map<DBCollection, BatchInsertionTask> inserts, RemoveTupleOperation tupleOperation) {
        EntityKey entityKey = tupleOperation.getEntityKey();
        DBCollection collection = this.getCollection(entityKey);
        BatchInsertionTask batchedInserts = inserts.get(collection);
        if (batchedInserts != null && batchedInserts.containsKey(entityKey)) {
            batchedInserts.remove(entityKey);
        } else {
            this.removeTuple(entityKey, tupleOperation.getTupleContext());
        }
    }

    private void executeBatchUpdate(Map<DBCollection, BatchInsertionTask> inserts, UpdateTupleOperation tupleOperation) {
        EntityKey entityKey = tupleOperation.getEntityKey();
        Tuple tuple = tupleOperation.getTuple();
        BatchableMongoDBTupleSnapshot snapshot = (BatchableMongoDBTupleSnapshot)tupleOperation.getTuple().getSnapshot();
        WriteConcern writeConcern = this.getWriteConcern((GridDialectOperationContext)tupleOperation.getTupleContext());
        if (BatchableMongoDBTupleSnapshot.SnapshotType.INSERT == snapshot.getOperationType() && this.columnNamesAllowBatchInsert(tupleOperation)) {
            this.prepareForInsert(inserts, snapshot, entityKey, tuple, writeConcern);
        } else {
            this.updateTuple(tuple, entityKey, tupleOperation.getTupleContext());
        }
    }

    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return NoOpParameterMetadataBuilder.INSTANCE;
    }

    private void prepareForInsert(Map<DBCollection, BatchInsertionTask> inserts, BatchableMongoDBTupleSnapshot snapshot, EntityKey entityKey, Tuple tuple, WriteConcern writeConcern) {
        DBCollection collection = this.getCollection(entityKey);
        BatchInsertionTask batchInsertion = this.getOrCreateBatchInsertionTask(inserts, collection, writeConcern);
        DBObject document = this.getCurrentDocument(snapshot, batchInsertion, entityKey);
        DBObject newDocument = this.objectForInsert(tuple, document);
        inserts.get(collection).put(entityKey, newDocument);
    }

    private DBObject getCurrentDocument(BatchableMongoDBTupleSnapshot snapshot, BatchInsertionTask batchInsert, EntityKey entityKey) {
        DBObject fromBatchInsertion = batchInsert.get(entityKey);
        return fromBatchInsertion != null ? fromBatchInsertion : snapshot.getDbObject();
    }

    private BatchInsertionTask getOrCreateBatchInsertionTask(Map<DBCollection, BatchInsertionTask> inserts, DBCollection collection, WriteConcern writeConcern) {
        BatchInsertionTask insertsForCollection = inserts.get(collection);
        if (insertsForCollection == null) {
            insertsForCollection = new BatchInsertionTask(writeConcern);
            inserts.put(collection, insertsForCollection);
        }
        return insertsForCollection;
    }

    private void flushInserts(Map<DBCollection, BatchInsertionTask> inserts) {
        for (Map.Entry<DBCollection, BatchInsertionTask> entry : inserts.entrySet()) {
            DBCollection collection = entry.getKey();
            collection.insert(entry.getValue().getAll(), entry.getValue().getWriteConcern());
        }
        inserts.clear();
    }

    private WriteConcern getWriteConcern(GridDialectOperationContext operationContext) {
        return (WriteConcern)operationContext.getOptionsContext().getUnique(WriteConcernOption.class);
    }

    private ReadPreference getReadPreference(GridDialectOperationContext operationContext) {
        return (ReadPreference)operationContext.getOptionsContext().getUnique(ReadPreferenceOption.class);
    }

    private static class BatchInsertionTask {
        private final Map<EntityKey, DBObject> inserts = new HashMap<EntityKey, DBObject>();
        private final WriteConcern writeConcern;

        public BatchInsertionTask(WriteConcern writeConcern) {
            this.writeConcern = writeConcern;
        }

        public List<DBObject> getAll() {
            return new ArrayList<DBObject>(this.inserts.values());
        }

        public DBObject get(EntityKey entityKey) {
            return this.inserts.get(entityKey);
        }

        public boolean containsKey(EntityKey entityKey) {
            return this.inserts.containsKey(entityKey);
        }

        public DBObject remove(EntityKey entityKey) {
            return this.inserts.remove(entityKey);
        }

        public void put(EntityKey entityKey, DBObject object) {
            this.inserts.put(entityKey, object);
        }

        public WriteConcern getWriteConcern() {
            return this.writeConcern;
        }
    }

    private static class MongoDBResultsCursor
    implements ClosableIterator<Tuple> {
        private final DBCursor cursor;
        private final EntityKeyMetadata metadata;

        public MongoDBResultsCursor(DBCursor cursor, EntityKeyMetadata metadata) {
            this.cursor = cursor;
            this.metadata = metadata;
        }

        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        public Tuple next() {
            DBObject dbObject = this.cursor.next();
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(dbObject, this.metadata));
        }

        public void remove() {
            this.cursor.remove();
        }

        public void close() {
            this.cursor.close();
        }
    }
}

