/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.dialect.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Collections;
import org.hibernate.ogm.model.key.spi.AssociationKey;

public class MongoHelpers {
    public static Collection<DBObject> getAssociationFieldOrNull(AssociationKey key, DBObject entity) {
        String[] path = key.getMetadata().getCollectionRole().split("\\.");
        DBObject field = entity;
        for (String node : path) {
            field = field != null ? field.get(node) : null;
        }
        return (Collection)field;
    }

    public static void addEmptyAssociationField(AssociationKey key, DBObject entity) {
        String[] path = key.getMetadata().getCollectionRole().split("\\.");
        Object field = entity;
        int size = path.length;
        for (int index = 0; index < size; ++index) {
            DBObject parent = field;
            String node = path[index];
            if ((field = parent.get(node)) != null) continue;
            field = index == size - 1 ? Collections.EMPTY_LIST : new BasicDBObject();
            parent.put(node, field);
        }
    }

    public static Object getValueFromColumns(String column, String[] columns, Object[] values) {
        for (int index = 0; index < columns.length; ++index) {
            if (!columns[index].equals(column)) continue;
            return values[index];
        }
        return null;
    }
}

