/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.dialect.impl;

import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.mongodb.options.AssociationDocumentType;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.spi.AssociationKind;

public enum AssociationStorageStrategy {
    IN_ENTITY,
    GLOBAL_COLLECTION,
    COLLECTION_PER_ASSOCIATION;


    public static AssociationStorageStrategy getInstance(AssociationKeyMetadata keyMetadata, AssociationStorageType associationStorage, AssociationDocumentType associationDocumentStorage) {
        if (keyMetadata.isOneToOne() || keyMetadata.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION || associationStorage == AssociationStorageType.IN_ENTITY) {
            return IN_ENTITY;
        }
        if (associationDocumentStorage == AssociationDocumentType.COLLECTION_PER_ASSOCIATION) {
            return COLLECTION_PER_ASSOCIATION;
        }
        return GLOBAL_COLLECTION;
    }
}

