/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.options.impl;

import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.options.WriteConcern;
import org.hibernate.ogm.datastore.mongodb.options.WriteConcernType;
import org.hibernate.ogm.datastore.mongodb.options.impl.WriteConcernOption;
import org.hibernate.ogm.options.spi.AnnotationConverter;
import org.hibernate.ogm.options.spi.Option;
import org.hibernate.ogm.options.spi.OptionValuePair;

public class WriteConcernConverter
implements AnnotationConverter<WriteConcern> {
    private static final Log log = LoggerFactory.getLogger();

    public OptionValuePair<?> convert(WriteConcern annotation) {
        com.mongodb.WriteConcern writeConcern = null;
        if (annotation.value() == WriteConcernType.CUSTOM) {
            try {
                writeConcern = annotation.type().newInstance();
            }
            catch (Exception e) {
                throw log.unableToInstantiateType(annotation.type().getName(), e);
            }
        } else {
            writeConcern = annotation.value().getWriteConcern();
        }
        return OptionValuePair.getInstance((Option)new WriteConcernOption(), (Object)writeConcern);
    }
}

