/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.configuration.impl;

import com.mongodb.MongoClientOptions;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import org.hibernate.HibernateException;
import org.hibernate.ogm.cfg.spi.DocumentStoreConfiguration;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.options.impl.ReadPreferenceOption;
import org.hibernate.ogm.datastore.mongodb.options.impl.WriteConcernOption;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.ogm.util.configurationreader.spi.PropertyValidator;

public class MongoDBConfiguration
extends DocumentStoreConfiguration {
    public static final String DEFAULT_ASSOCIATION_STORE = "Associations";
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int DEFAULT_PORT = 27017;
    private static final Log log = LoggerFactory.getLogger();
    private static final TimeoutValidator TIMEOUT_VALIDATOR = new TimeoutValidator();
    private final int timeout;
    private final WriteConcern writeConcern;
    private final ReadPreference readPreference;

    public MongoDBConfiguration(ConfigurationPropertyReader propertyReader, OptionsContext globalOptions) {
        super(propertyReader, 27017);
        this.timeout = (Integer)propertyReader.property("hibernate.ogm.mongodb.connection_timeout", Integer.TYPE).withDefault((Object)5000).withValidator((PropertyValidator)TIMEOUT_VALIDATOR).getValue();
        this.writeConcern = (WriteConcern)globalOptions.getUnique(WriteConcernOption.class);
        this.readPreference = (ReadPreference)globalOptions.getUnique(ReadPreferenceOption.class);
    }

    public MongoClientOptions buildOptions() {
        MongoClientOptions.Builder optionsBuilder = new MongoClientOptions.Builder();
        optionsBuilder.connectTimeout(this.timeout);
        optionsBuilder.writeConcern(this.writeConcern);
        optionsBuilder.readPreference(this.readPreference);
        return optionsBuilder.build();
    }

    private static class TimeoutValidator
    implements PropertyValidator<Integer> {
        private TimeoutValidator() {
        }

        public void validate(Integer value) throws HibernateException {
            if (value < 0) {
                throw log.mongoDBTimeOutIllegalValue(value);
            }
        }
    }
}

