/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReference;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;

public class MongoDBQueryResolverDelegate
implements QueryResolverDelegate {
    private static final Log log = LoggerFactory.getLogger();
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    private final Map<String, PropertyPath> aliasToPropertyPath = new HashMap<String, PropertyPath>();
    private String alias;

    public void registerPersisterSpace(Tree entityName, Tree alias) {
        String put = this.aliasToEntityType.put(alias.getText(), entityName.getText());
        if (put != null && !put.equalsIgnoreCase(entityName.getText())) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias.getText() + " already assigned to type " + put);
        }
    }

    public void registerJoinAlias(Tree alias, PropertyPath path) {
        PropertyPath put = this.aliasToPropertyPath.put(alias.getText(), path);
        if (put != null && !put.equals(path)) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias + " already assigned to type " + put);
        }
    }

    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree property) {
        return new PathedPropertyReference(property.getText(), null, this.isAlias(property));
    }

    public boolean isPersisterReferenceAlias() {
        return this.isEntityAlias(this.alias);
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree root) {
        return new PathedPropertyReference(root.getText(), null, this.isAlias(root));
    }

    private boolean isAlias(Tree root) {
        return this.aliasToEntityType.containsKey(root.getText()) || this.aliasToPropertyPath.containsKey(root.getText());
    }

    private boolean isEntityAlias(String alias) {
        return this.aliasToEntityType.containsKey(alias);
    }

    public PathedPropertyReferenceSource normalizeQualifiedRoot(Tree root) {
        String entityNameForAlias = this.aliasToEntityType.get(root.getText());
        if (entityNameForAlias == null) {
            throw log.getUnknownAliasException(root.getText());
        }
        return new PathedPropertyReference(root.getText(), null, true);
    }

    public PathedPropertyReferenceSource normalizePropertyPathIntermediary(PropertyPath path, Tree propertyName) {
        return new PathedPropertyReference(propertyName.getText(), null, false);
    }

    public PathedPropertyReferenceSource normalizeIntermediateIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        return propertyReferenceSource;
    }

    public void normalizeTerminalIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
        return null;
    }

    public PathedPropertyReferenceSource normalizePropertyPathTerminus(PropertyPath path, Tree propertyNameNode) {
        return new PathedPropertyReference(propertyNameNode.getText(), null, false);
    }

    public void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        this.alias = alias.getText();
    }

    public void pushSelectStrategy() {
    }

    public void popStrategy() {
    }

    public void propertyPathCompleted(PropertyPath path) {
    }
}

