/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.impl;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.ogm.cfg.spi.Hosts;
import org.hibernate.ogm.datastore.mongodb.MongoDBDialect;
import org.hibernate.ogm.datastore.mongodb.configuration.impl.MongoDBConfiguration;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBEntityMappingValidator;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBBasedQueryParserService;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.query.spi.QueryParserService;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class MongoDBDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
Configurable,
ServiceRegistryAwareService {
    private static final Log log = LoggerFactory.getLogger();
    private ServiceRegistryImplementor serviceRegistry;
    private MongoClient mongo;
    private DB mongoDb;
    private MongoDBConfiguration config;

    public MongoDBDatastoreProvider() {
    }

    public MongoDBDatastoreProvider(MongoClient mongoClient) {
        this.mongo = mongoClient;
    }

    public void configure(Map configurationValues) {
        OptionsService optionsService = (OptionsService)this.serviceRegistry.getService(OptionsService.class);
        ClassLoaderService classLoaderService = (ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class);
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues, classLoaderService);
        try {
            this.config = new MongoDBConfiguration(propertyReader, optionsService.context().getGlobalOptions());
        }
        catch (Exception e) {
            throw log.unableToConfigureDatastoreProvider(e);
        }
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return MongoDBDialect.class;
    }

    public Class<? extends QueryParserService> getDefaultQueryParserServiceType() {
        return MongoDBBasedQueryParserService.class;
    }

    public Class<? extends SchemaDefiner> getSchemaDefinerType() {
        return MongoDBEntityMappingValidator.class;
    }

    public boolean allowsTransactionEmulation() {
        return true;
    }

    public void start() {
        try {
            if (this.mongo == null) {
                this.mongo = this.createMongoClient(this.config);
            }
            this.mongoDb = this.extractDatabase(this.mongo, this.config);
        }
        catch (Exception e) {
            throw log.unableToStartDatastoreProvider(e);
        }
    }

    protected MongoClient createMongoClient(MongoDBConfiguration config) {
        MongoClientOptions clientOptions = config.buildOptions();
        List<MongoCredential> credentials = config.buildCredentials();
        log.connectingToMongo(config.getHosts().toString(), clientOptions.getConnectTimeout());
        try {
            ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>(config.getHosts().size());
            for (Hosts.HostAndPort hostAndPort : config.getHosts()) {
                serverAddresses.add(new ServerAddress(hostAndPort.getHost(), hostAndPort.getPort().intValue()));
            }
            return credentials == null ? new MongoClient(serverAddresses, clientOptions) : new MongoClient(serverAddresses, credentials, clientOptions);
        }
        catch (RuntimeException e) {
            throw log.unableToInitializeMongoDB(e);
        }
    }

    public void stop() {
        log.disconnectingFromMongo();
        this.mongo.close();
    }

    public DB getDatabase() {
        return this.mongoDb;
    }

    private DB extractDatabase(MongoClient mongo, MongoDBConfiguration config) {
        try {
            Boolean containsDatabase;
            String databaseName = config.getDatabaseName();
            log.connectingToMongoDatabase(databaseName);
            try {
                containsDatabase = mongo.getDatabaseNames().contains(databaseName);
            }
            catch (MongoException me) {
                containsDatabase = null;
            }
            if (containsDatabase != null && containsDatabase == Boolean.FALSE) {
                if (config.isCreateDatabase()) {
                    log.creatingDatabase(databaseName);
                } else {
                    throw log.databaseDoesNotExistException(config.getDatabaseName());
                }
            }
            DB db = mongo.getDB(databaseName);
            if (containsDatabase == null) {
                db.collectionExists("WeDoNotCareWhatItIsWeNeedToConnect");
            }
            return mongo.getDB(databaseName);
        }
        catch (MongoException me) {
            throw log.unableToConnectToDatastore(me.getMessage(), (Exception)((Object)me));
        }
    }
}

