/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.dialect.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRowFactory;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRows;
import org.hibernate.ogm.datastore.document.association.spi.impl.DocumentHelpers;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.AssociationStorageStrategy;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoDBAssociationRowFactory;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoHelpers;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationType;

public class MongoDBAssociationSnapshot
extends AssociationRows {
    private static final String EMBEDDABLE_COLUMN_PREFIX = ".value.";
    private final DBObject dbObject;

    public MongoDBAssociationSnapshot(DBObject document, AssociationKey associationKey, AssociationStorageStrategy storageStrategy) {
        super(associationKey, MongoDBAssociationSnapshot.getRows(document, associationKey, storageStrategy), (AssociationRowFactory)MongoDBAssociationRowFactory.INSTANCE);
        this.dbObject = document;
    }

    public DBObject getQueryObject() {
        BasicDBObject query = new BasicDBObject();
        query.put("_id", this.dbObject.get("_id"));
        return query;
    }

    private static Collection<?> getRows(DBObject document, AssociationKey associationKey, AssociationStorageStrategy storageStrategy) {
        Collection<Object> rows = null;
        if (associationKey.getMetadata().getAssociationType() == AssociationType.ONE_TO_ONE) {
            Object oneToOneValue = MongoHelpers.getValueOrNull(document, associationKey.getMetadata().getCollectionRole(), Object.class);
            if (oneToOneValue != null) {
                rows = Collections.singletonList(oneToOneValue);
            }
        } else {
            Object toManyValue = storageStrategy == AssociationStorageStrategy.IN_ENTITY ? MongoHelpers.getValueOrNull(document, associationKey.getMetadata().getCollectionRole()) : document.get("rows");
            if (toManyValue instanceof Collection) {
                rows = (Collection)toManyValue;
            } else if (toManyValue instanceof DBObject) {
                rows = MongoDBAssociationSnapshot.getRowsFromMapAssociation(associationKey, (DBObject)toManyValue);
            }
        }
        return rows != null ? rows : Collections.emptyList();
    }

    private static Collection<?> getRowsFromMapAssociation(AssociationKey associationKey, DBObject value) {
        String rowKeyIndexColumn = associationKey.getMetadata().getRowKeyIndexColumnNames()[0];
        ArrayList<BasicDBObject> rows = new ArrayList<BasicDBObject>();
        String[] associationKeyColumns = associationKey.getMetadata().getAssociatedEntityKeyMetadata().getAssociationKeyColumns();
        String prefix = DocumentHelpers.getColumnSharedPrefix((String[])associationKeyColumns);
        prefix = prefix == null ? "" : prefix + ".";
        String embeddedValueColumnPrefix = associationKey.getMetadata().getCollectionRole() + EMBEDDABLE_COLUMN_PREFIX;
        for (String rowKey : value.keySet()) {
            Object mapRow = value.get(rowKey);
            BasicDBObject row = new BasicDBObject();
            row.put(rowKeyIndexColumn, (Object)rowKey);
            if (mapRow instanceof DBObject) {
                for (String column : associationKey.getMetadata().getAssociatedEntityKeyMetadata().getAssociationKeyColumns()) {
                    if (column.startsWith(embeddedValueColumnPrefix)) {
                        MongoHelpers.setValue((DBObject)row, column.substring(associationKey.getMetadata().getCollectionRole().length() + 1), ((DBObject)mapRow).get(column.substring(embeddedValueColumnPrefix.length())));
                        continue;
                    }
                    row.put(column.substring(prefix.length()), ((DBObject)mapRow).get(column.substring(prefix.length())));
                }
            } else {
                row.put(associationKey.getMetadata().getAssociatedEntityKeyMetadata().getAssociationKeyColumns()[0], mapRow);
            }
            rows.add(row);
        }
        return rows;
    }

    public DBObject getDBObject() {
        return this.dbObject;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MongoDBAssociationSnapshot(");
        sb.append(this.size());
        sb.append(") RowKey entries).");
        return sb.toString();
    }
}

