/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.BulkWriteOperation;
import com.mongodb.BulkWriteResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.document.association.impl.DocumentHelpers;
import org.hibernate.ogm.datastore.document.impl.DotPatternMapHelpers;
import org.hibernate.ogm.datastore.document.impl.EmbeddableStateFinder;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.spi.AssociationStorageOption;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.AssociationStorageStrategy;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoDBAssociationSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoDBTupleSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoHelpers;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.options.AssociationDocumentStorageType;
import org.hibernate.ogm.datastore.mongodb.options.impl.AssociationDocumentStorageOption;
import org.hibernate.ogm.datastore.mongodb.options.impl.ReadPreferenceOption;
import org.hibernate.ogm.datastore.mongodb.options.impl.WriteConcernOption;
import org.hibernate.ogm.datastore.mongodb.query.impl.MongoDBQueryDescriptor;
import org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl.MongoDBQueryDescriptorBuilder;
import org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl.NativeQueryParser;
import org.hibernate.ogm.datastore.mongodb.type.impl.ObjectIdGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.StringAsObjectIdGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.StringAsObjectIdType;
import org.hibernate.ogm.dialect.batch.spi.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.spi.GroupedChangesToEntityOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.Operation;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.batch.spi.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.RemoveTupleOperation;
import org.hibernate.ogm.dialect.identity.spi.IdentityColumnAwareGridDialect;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.optimisticlock.spi.OptimisticLockingAwareGridDialect;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.NoOpParameterMetadataBuilder;
import org.hibernate.ogm.dialect.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.dialect.query.spi.QueryParameters;
import org.hibernate.ogm.dialect.query.spi.QueryableGridDialect;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.key.spi.AssociationType;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.type.impl.ByteStringType;
import org.hibernate.ogm.type.impl.CharacterStringType;
import org.hibernate.ogm.type.impl.StringCalendarDateType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.parboiled.Parboiled;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.RecoveringParseRunner;
import org.parboiled.support.ParsingResult;

public class MongoDBDialect
extends BaseGridDialect
implements QueryableGridDialect<MongoDBQueryDescriptor>,
BatchableGridDialect,
IdentityColumnAwareGridDialect,
MultigetGridDialect,
OptimisticLockingAwareGridDialect {
    public static final String ID_FIELDNAME = "_id";
    public static final String PROPERTY_SEPARATOR = ".";
    public static final String ROWS_FIELDNAME = "rows";
    public static final String TABLE_FIELDNAME = "table";
    public static final String ASSOCIATIONS_COLLECTION_PREFIX = "associations_";
    private static final Log log = LoggerFactory.getLogger();
    private static final List<String> ROWS_FIELDNAME_LIST = Collections.singletonList("rows");
    private static final Pattern PRIMARY_KEY_CONSTRAINT_VIOLATION_MESSAGE = Pattern.compile(".*[. ]\\$?_id_? .*");
    private final MongoDBDatastoreProvider provider;
    private final DB currentDB;

    public MongoDBDialect(MongoDBDatastoreProvider provider) {
        this.provider = provider;
        this.currentDB = this.provider.getDatabase();
    }

    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        DBObject found = this.getObject(key, operationContext);
        return MongoDBDialect.createTuple(key, operationContext, found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        Object[] searchObjects = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            searchObjects[i] = MongoDBDialect.prepareIdObjectValue(keys[i].getColumnNames(), keys[i].getColumnValues());
        }
        try (DBCursor cursor = this.getObjects(keys[0].getMetadata(), searchObjects, tupleContext);){
            List<Tuple> list = MongoDBDialect.tuplesResult(keys, searchObjects, tupleContext, cursor);
            return list;
        }
    }

    private static List<Tuple> tuplesResult(EntityKey[] keys, Object[] searchObjects, TupleContext tupleContext, DBCursor cursor) {
        Tuple[] tuples = new Tuple[searchObjects.length];
        block0: for (DBObject dbObject : cursor) {
            for (int i = 0; i < searchObjects.length; ++i) {
                if (!dbObject.get(ID_FIELDNAME).equals(searchObjects[i])) continue;
                tuples[i] = MongoDBDialect.createTuple(keys[i], (OperationContext)tupleContext, dbObject);
                continue block0;
            }
        }
        return Arrays.asList(tuples);
    }

    private static Tuple createTuple(EntityKey key, OperationContext operationContext, DBObject found) {
        if (found != null) {
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(found, key.getMetadata()), Tuple.SnapshotType.UPDATE);
        }
        if (MongoDBDialect.isInTheInsertionQueue((EntityKey)key, (OperationContext)operationContext)) {
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot((DBObject)MongoDBDialect.prepareIdObject(key), key.getMetadata()), Tuple.SnapshotType.INSERT);
        }
        return null;
    }

    public Tuple createTuple(EntityKeyMetadata entityKeyMetadata, OperationContext operationContext) {
        return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot((DBObject)new BasicDBObject(), entityKeyMetadata), Tuple.SnapshotType.INSERT);
    }

    public Tuple createTuple(EntityKey key, OperationContext OperationContext2) {
        BasicDBObject toSave = MongoDBDialect.prepareIdObject(key);
        return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot((DBObject)toSave, key.getMetadata()), Tuple.SnapshotType.INSERT);
    }

    private DBObject getEmbeddingEntity(AssociationKey key, AssociationContext associationContext) {
        DBObject embeddingEntityDocument;
        DBObject dBObject = embeddingEntityDocument = associationContext.getEntityTuplePointer().getTuple() != null ? ((MongoDBTupleSnapshot)associationContext.getEntityTuplePointer().getTuple().getSnapshot()).getDbObject() : null;
        if (embeddingEntityDocument != null) {
            return embeddingEntityDocument;
        }
        ReadPreference readPreference = MongoDBDialect.getReadPreference(associationContext);
        DBCollection collection = this.getCollection(key.getEntityKey());
        BasicDBObject searchObject = MongoDBDialect.prepareIdObject(key.getEntityKey());
        DBObject projection = MongoDBDialect.getProjection(key, true);
        return collection.findOne((DBObject)searchObject, projection, readPreference);
    }

    private DBObject getObject(EntityKey key, OperationContext operationContext) {
        ReadPreference readPreference = MongoDBDialect.getReadPreference(operationContext);
        DBCollection collection = this.getCollection(key);
        BasicDBObject searchObject = MongoDBDialect.prepareIdObject(key);
        BasicDBObject projection = MongoDBDialect.getProjection(operationContext);
        return collection.findOne((DBObject)searchObject, (DBObject)projection, readPreference);
    }

    private DBCursor getObjects(EntityKeyMetadata entityKeyMetadata, Object[] searchObjects, TupleContext tupleContext) {
        ReadPreference readPreference = MongoDBDialect.getReadPreference((OperationContext)tupleContext);
        DBCollection collection = this.getCollection(entityKeyMetadata);
        collection.setReadPreference(readPreference);
        BasicDBObject projection = MongoDBDialect.getProjection((OperationContext)tupleContext);
        BasicDBObject query = new BasicDBObject();
        query.put(ID_FIELDNAME, (Object)new BasicDBObject("$in", (Object)searchObjects));
        return collection.find((DBObject)query, (DBObject)projection);
    }

    private static BasicDBObject getProjection(OperationContext operationContext) {
        return MongoDBDialect.getProjection(operationContext.getTupleTypeContext().getSelectableColumns());
    }

    private static BasicDBObject getProjection(List<String> fieldNames) {
        BasicDBObject projection = new BasicDBObject(fieldNames.size());
        for (String column : fieldNames) {
            projection.put((Object)column, (Object)1);
        }
        return projection;
    }

    private static BasicDBObject prepareIdObject(EntityKey key) {
        return MongoDBDialect.prepareIdObject(key.getColumnNames(), key.getColumnValues());
    }

    private static BasicDBObject prepareIdObject(IdSourceKey key) {
        return MongoDBDialect.prepareIdObject(key.getColumnName(), key.getColumnValue());
    }

    private static BasicDBObject prepareIdObject(String columnName, String columnValue) {
        return new BasicDBObject(ID_FIELDNAME, MongoDBDialect.prepareIdObjectValue(columnName, columnValue));
    }

    private static BasicDBObject prepareIdObject(String[] columnNames, Object[] columnValues) {
        return new BasicDBObject(ID_FIELDNAME, MongoDBDialect.prepareIdObjectValue(columnNames, columnValues));
    }

    private static Object prepareIdObjectValue(String columnName, String columnValue) {
        return columnValue;
    }

    private static Object prepareIdObjectValue(String[] columnNames, Object[] columnValues) {
        if (columnNames.length == 1) {
            return columnValues[0];
        }
        BasicDBObject idObject = new BasicDBObject();
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            Object columnValue = columnValues[i];
            if (columnName.contains(PROPERTY_SEPARATOR)) {
                int dotIndex = columnName.indexOf(PROPERTY_SEPARATOR);
                String shortColumnName = columnName.substring(dotIndex + 1);
                idObject.put(shortColumnName, columnValue);
                continue;
            }
            idObject.put(columnNames[i], columnValue);
        }
        return idObject;
    }

    private DBCollection getCollection(String table) {
        return this.currentDB.getCollection(table);
    }

    private DBCollection getCollection(EntityKey key) {
        return this.getCollection(key.getTable());
    }

    private DBCollection getCollection(EntityKeyMetadata entityKeyMetadata) {
        return this.getCollection(entityKeyMetadata.getTable());
    }

    private DBCollection getAssociationCollection(AssociationKey key, AssociationStorageStrategy storageStrategy) {
        if (storageStrategy == AssociationStorageStrategy.GLOBAL_COLLECTION) {
            return this.getCollection("Associations");
        }
        return this.getCollection(ASSOCIATIONS_COLLECTION_PREFIX + key.getTable());
    }

    private static BasicDBObject getSubQuery(String operator, BasicDBObject query) {
        return query.get(operator) != null ? (BasicDBObject)query.get(operator) : new BasicDBObject();
    }

    private static void addSubQuery(String operator, BasicDBObject query, String column, Object value) {
        BasicDBObject subQuery = MongoDBDialect.getSubQuery(operator, query);
        query.append(operator, (Object)subQuery.append(column, value));
    }

    private static void addSetToQuery(BasicDBObject query, String column, Object value) {
        MongoDBDialect.removeSubQuery("$unset", query, column);
        MongoDBDialect.addSubQuery("$set", query, column, value);
    }

    private static void addUnsetToQuery(BasicDBObject query, String column) {
        MongoDBDialect.removeSubQuery("$set", query, column);
        MongoDBDialect.addSubQuery("$unset", query, column, 1);
    }

    private static void removeSubQuery(String operator, BasicDBObject query, String column) {
        BasicDBObject subQuery = MongoDBDialect.getSubQuery(operator, query);
        subQuery.removeField(column);
        if (subQuery.isEmpty()) {
            query.removeField(operator);
        }
    }

    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) {
        throw new UnsupportedOperationException("Method not supported in GridDialect anymore");
    }

    public boolean updateTupleWithOptimisticLock(EntityKey entityKey, Tuple oldLockState, Tuple tuple, TupleContext tupleContext) {
        BasicDBObject idObject = MongoDBDialect.prepareIdObject(entityKey);
        for (String versionColumn : oldLockState.getColumnNames()) {
            idObject.put((Object)versionColumn, oldLockState.get(versionColumn));
        }
        BasicDBObject updater = MongoDBDialect.objectForUpdate(tuple, tupleContext);
        if (updater.isEmpty()) {
            return false;
        }
        DBObject doc = this.getCollection(entityKey).findAndModify((DBObject)idObject, (DBObject)updater);
        return doc != null;
    }

    public void insertTuple(EntityKeyMetadata entityKeyMetadata, Tuple tuple, TupleContext tupleContext) {
        WriteConcern writeConcern = MongoDBDialect.getWriteConcern(tupleContext);
        DBObject objectWithId = this.insertDBObject(entityKeyMetadata, tuple, writeConcern);
        String idColumnName = entityKeyMetadata.getColumnNames()[0];
        tuple.put(idColumnName, objectWithId.get(ID_FIELDNAME));
    }

    private DBObject insertDBObject(EntityKeyMetadata entityKeyMetadata, Tuple tuple, WriteConcern writeConcern) {
        DBObject dbObject = MongoDBDialect.objectForInsert(tuple, ((MongoDBTupleSnapshot)tuple.getSnapshot()).getDbObject());
        this.getCollection(entityKeyMetadata).insert(dbObject, writeConcern);
        return dbObject;
    }

    private static DBObject objectForInsert(Tuple tuple, DBObject dbObject) {
        MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tuple.getSnapshot();
        for (TupleOperation operation : tuple.getOperations()) {
            String column = operation.getColumn();
            if (!MongoDBDialect.notInIdField(snapshot, column)) continue;
            switch (operation.getType()) {
                case PUT: {
                    MongoHelpers.setValue(dbObject, column, operation.getValue());
                    break;
                }
                case PUT_NULL: 
                case REMOVE: {
                    MongoHelpers.resetValue(dbObject, column);
                }
            }
        }
        return dbObject;
    }

    private static BasicDBObject objectForUpdate(Tuple tuple, TupleContext tupleContext) {
        return MongoDBDialect.objectForUpdate(tuple, tupleContext, new BasicDBObject());
    }

    private static BasicDBObject objectForUpdate(Tuple tuple, TupleContext tupleContext, BasicDBObject updateStatement) {
        MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tuple.getSnapshot();
        EmbeddableStateFinder embeddableStateFinder = new EmbeddableStateFinder(tuple, tupleContext);
        HashSet<String> nullEmbeddables = new HashSet<String>();
        for (TupleOperation operation : tuple.getOperations()) {
            String column = operation.getColumn();
            if (!MongoDBDialect.notInIdField(snapshot, column)) continue;
            switch (operation.getType()) {
                case PUT: {
                    MongoDBDialect.addSetToQuery(updateStatement, column, operation.getValue());
                    break;
                }
                case PUT_NULL: 
                case REMOVE: {
                    String nullEmbeddable = embeddableStateFinder.getOuterMostNullEmbeddableIfAny(column);
                    if (nullEmbeddable != null) {
                        if (nullEmbeddables.contains(nullEmbeddable)) break;
                        MongoDBDialect.addUnsetToQuery(updateStatement, nullEmbeddable);
                        nullEmbeddables.add(nullEmbeddable);
                        break;
                    }
                    MongoDBDialect.addUnsetToQuery(updateStatement, column);
                }
            }
        }
        return updateStatement;
    }

    private static boolean notInIdField(MongoDBTupleSnapshot snapshot, String column) {
        return !column.equals(ID_FIELDNAME) && !column.endsWith("._id") && !snapshot.isKeyColumn(column);
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        DBCollection collection = this.getCollection(key);
        BasicDBObject toDelete = MongoDBDialect.prepareIdObject(key);
        WriteConcern writeConcern = MongoDBDialect.getWriteConcern(tupleContext);
        collection.remove((DBObject)toDelete, writeConcern);
    }

    public boolean removeTupleWithOptimisticLock(EntityKey entityKey, Tuple oldLockState, TupleContext tupleContext) {
        BasicDBObject toDelete = MongoDBDialect.prepareIdObject(entityKey);
        for (String versionColumn : oldLockState.getColumnNames()) {
            toDelete.put(versionColumn, oldLockState.get(versionColumn));
        }
        DBCollection collection = this.getCollection(entityKey);
        DBObject deleted = collection.findAndRemove((DBObject)toDelete);
        return deleted != null;
    }

    private DBObject findAssociation(AssociationKey key, AssociationContext associationContext, AssociationStorageStrategy storageStrategy) {
        ReadPreference readPreference = MongoDBDialect.getReadPreference(associationContext);
        DBObject associationKeyObject = MongoDBDialect.associationKeyToObject(key, storageStrategy);
        return this.getAssociationCollection(key, storageStrategy).findOne(associationKeyObject, MongoDBDialect.getProjection(key, false), readPreference);
    }

    private static DBObject getProjection(AssociationKey key, boolean embedded) {
        if (embedded) {
            return MongoDBDialect.getProjection(Collections.singletonList(key.getMetadata().getCollectionRole()));
        }
        return MongoDBDialect.getProjection(ROWS_FIELDNAME_LIST);
    }

    private static boolean isInTheInsertionQueue(EntityKey key, AssociationContext associationContext) {
        OperationsQueue queue = associationContext.getOperationsQueue();
        return queue != null && queue.isInTheInsertionQueue(key);
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = MongoDBDialect.getAssociationStorageStrategy(key, associationContext);
        if (MongoDBDialect.isEmbeddedAssociation(key) && MongoDBDialect.isInTheInsertionQueue(key.getEntityKey(), associationContext)) {
            BasicDBObject idObject = MongoDBDialect.prepareIdObject(key.getEntityKey());
            return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot((DBObject)idObject, key, storageStrategy));
        }
        this.executeBatch(associationContext.getOperationsQueue());
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            DBObject entity = this.getEmbeddingEntity(key, associationContext);
            if (entity != null && MongoHelpers.hasField(entity, key.getMetadata().getCollectionRole())) {
                return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(entity, key, storageStrategy));
            }
            return null;
        }
        DBObject result = this.findAssociation(key, associationContext, storageStrategy);
        if (result == null) {
            return null;
        }
        return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(result, key, storageStrategy));
    }

    private static boolean isEmbeddedAssociation(AssociationKey key) {
        return AssociationKind.EMBEDDED_COLLECTION == key.getMetadata().getAssociationKind();
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = MongoDBDialect.getAssociationStorageStrategy(key, associationContext);
        DBObject document = storageStrategy == AssociationStorageStrategy.IN_ENTITY ? this.getEmbeddingEntity(key, associationContext) : MongoDBDialect.associationKeyToObject(key, storageStrategy);
        Association association = new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(document, key, storageStrategy));
        if (!association.isEmpty()) {
            association.clear();
        }
        return association;
    }

    private static Object getAssociationRows(Association association, AssociationKey key, AssociationContext associationContext) {
        boolean organizeByRowKey = DotPatternMapHelpers.organizeAssociationMapByRowKey((Association)association, (AssociationKey)key, (AssociationContext)associationContext);
        if (organizeByRowKey) {
            String rowKeyColumn = organizeByRowKey ? key.getMetadata().getRowKeyIndexColumnNames()[0] : null;
            BasicDBObject rows = new BasicDBObject();
            for (RowKey rowKey : association.getKeys()) {
                DBObject row = (DBObject)MongoDBDialect.getAssociationRow(association.get(rowKey), key);
                String rowKeyValue = (String)row.removeField(rowKeyColumn);
                if (row.keySet().size() == 1) {
                    rows.put(rowKeyValue, row.toMap().values().iterator().next());
                    continue;
                }
                rows.put(rowKeyValue, (Object)row);
            }
            return rows;
        }
        ArrayList<Object> rows = new ArrayList<Object>();
        for (RowKey rowKey : association.getKeys()) {
            rows.add(MongoDBDialect.getAssociationRow(association.get(rowKey), key));
        }
        return rows;
    }

    private static Object getAssociationRow(Tuple row, AssociationKey associationKey) {
        String[] rowKeyColumnsToPersist = associationKey.getMetadata().getColumnsWithoutKeyColumns((Iterable)row.getColumnNames());
        if (rowKeyColumnsToPersist.length == 1) {
            return row.get(rowKeyColumnsToPersist[0]);
        }
        String prefix = DotPatternMapHelpers.getColumnSharedPrefixOfAssociatedEntityLink((AssociationKey)associationKey);
        BasicDBObject rowObject = new BasicDBObject(rowKeyColumnsToPersist.length);
        for (String column : rowKeyColumnsToPersist) {
            Object value = row.get(column);
            if (value == null) continue;
            String columnName = column.startsWith(prefix) ? column.substring(prefix.length()) : column;
            MongoHelpers.setValue((DBObject)rowObject, columnName, value);
        }
        return rowObject;
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        throw new UnsupportedOperationException("Method not supported in GridDialect anymore");
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        throw new UnsupportedOperationException("Method not supported in GridDialect anymore");
    }

    public Number nextValue(NextValueRequest request) {
        Object idFromDB;
        DBCollection currentCollection = this.getCollection(request.getKey().getTable());
        BasicDBObject query = MongoDBDialect.prepareIdObject(request.getKey());
        String valueColumnName = request.getKey().getMetadata().getValueColumnName();
        BasicDBObject update = new BasicDBObject();
        Integer incrementObject = request.getIncrement();
        MongoDBDialect.addSubQuery("$inc", update, valueColumnName, incrementObject);
        DBObject result = currentCollection.findAndModify((DBObject)query, null, null, false, (DBObject)update, false, true);
        Object object = idFromDB = result == null ? null : result.get(valueColumnName);
        if (idFromDB == null) {
            BasicDBObject updateForInitial = new BasicDBObject();
            MongoDBDialect.addSubQuery("$inc", updateForInitial, valueColumnName, request.getInitialValue());
            currentCollection.findAndModify((DBObject)query, null, null, false, (DBObject)updateForInitial, false, true);
            idFromDB = request.getInitialValue();
        } else {
            idFromDB = result.get(valueColumnName);
        }
        if (idFromDB.getClass().equals(Integer.class) || idFromDB.getClass().equals(Long.class)) {
            Number id = (Number)idFromDB;
            return id;
        }
        throw new HibernateException("Cannot increment a non numeric field");
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return MongoDBDialect.getAssociationStorageStrategy(associationKeyMetadata, associationTypeContext) == AssociationStorageStrategy.IN_ENTITY;
    }

    public GridType overrideType(Type type) {
        if (type == StandardBasicTypes.CALENDAR || type == StandardBasicTypes.CALENDAR_DATE) {
            return StringCalendarDateType.INSTANCE;
        }
        if (type == StandardBasicTypes.BYTE) {
            return ByteStringType.INSTANCE;
        }
        if (type == StandardBasicTypes.CHARACTER) {
            return CharacterStringType.INSTANCE;
        }
        if (type.getReturnedClass() == ObjectId.class) {
            return ObjectIdGridType.INSTANCE;
        }
        if (type instanceof StringAsObjectIdType) {
            return StringAsObjectIdGridType.INSTANCE;
        }
        return null;
    }

    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        DB db = this.provider.getDatabase();
        DBCollection collection = db.getCollection(entityKeyMetadata.getTable());
        for (DBObject dbObject : collection.find()) {
            consumer.consume(new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(dbObject, entityKeyMetadata), Tuple.SnapshotType.UPDATE));
        }
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<MongoDBQueryDescriptor> backendQuery, QueryParameters queryParameters, TupleContext tupleContext) {
        MongoDBQueryDescriptor queryDescriptor = (MongoDBQueryDescriptor)backendQuery.getQuery();
        EntityKeyMetadata entityKeyMetadata = backendQuery.getSingleEntityMetadataInformationOrNull() == null ? null : backendQuery.getSingleEntityMetadataInformationOrNull().getEntityKeyMetadata();
        String collectionName = MongoDBDialect.getCollectionName(backendQuery, queryDescriptor, entityKeyMetadata);
        DBCollection collection = this.provider.getDatabase().getCollection(collectionName);
        if (!queryParameters.getPositionalParameters().isEmpty()) {
            throw new UnsupportedOperationException("Positional parameters are not yet supported for MongoDB native queries.");
        }
        switch (queryDescriptor.getOperation()) {
            case FIND: {
                return MongoDBDialect.doFind(queryDescriptor, queryParameters, collection, entityKeyMetadata);
            }
            case FINDONE: {
                return MongoDBDialect.doFindOne(queryDescriptor, collection, entityKeyMetadata);
            }
            case FINDANDMODIFY: {
                return MongoDBDialect.doFindAndModify(queryDescriptor, collection, entityKeyMetadata);
            }
            case AGGREGATE: {
                return MongoDBDialect.doAggregate(queryDescriptor, queryParameters, collection, entityKeyMetadata);
            }
            case COUNT: {
                return MongoDBDialect.doCount(queryDescriptor, collection);
            }
            case INSERT: 
            case REMOVE: 
            case UPDATE: {
                throw log.updateQueryMustBeExecutedViaExecuteUpdate(queryDescriptor);
            }
        }
        throw new IllegalArgumentException("Unexpected query operation: " + queryDescriptor);
    }

    public int executeBackendUpdateQuery(BackendQuery<MongoDBQueryDescriptor> backendQuery, QueryParameters queryParameters, TupleContext tupleContext) {
        MongoDBQueryDescriptor queryDescriptor = (MongoDBQueryDescriptor)backendQuery.getQuery();
        EntityKeyMetadata entityKeyMetadata = backendQuery.getSingleEntityMetadataInformationOrNull() == null ? null : backendQuery.getSingleEntityMetadataInformationOrNull().getEntityKeyMetadata();
        String collectionName = MongoDBDialect.getCollectionName(backendQuery, queryDescriptor, entityKeyMetadata);
        DBCollection collection = this.provider.getDatabase().getCollection(collectionName);
        if (!queryParameters.getPositionalParameters().isEmpty()) {
            throw new UnsupportedOperationException("Positional parameters are not yet supported for MongoDB native queries.");
        }
        switch (queryDescriptor.getOperation()) {
            case INSERT: {
                return MongoDBDialect.doInsert(queryDescriptor, collection);
            }
            case REMOVE: {
                return MongoDBDialect.doRemove(queryDescriptor, collection);
            }
            case UPDATE: {
                return MongoDBDialect.doUpdate(queryDescriptor, collection);
            }
            case FIND: 
            case FINDONE: 
            case FINDANDMODIFY: 
            case AGGREGATE: 
            case COUNT: {
                throw log.readQueryMustBeExecutedViaGetResultList(queryDescriptor);
            }
        }
        throw new IllegalArgumentException("Unexpected query operation: " + queryDescriptor);
    }

    public MongoDBQueryDescriptor parseNativeQuery(String nativeQuery) {
        NativeQueryParser parser = (NativeQueryParser)Parboiled.createParser(NativeQueryParser.class, (Object[])new Object[0]);
        ParsingResult parseResult = new RecoveringParseRunner(parser.Query()).run(nativeQuery);
        if (parseResult.hasErrors()) {
            throw new IllegalArgumentException("Unsupported native query: " + ErrorUtils.printParseErrors((List)parseResult.parseErrors));
        }
        return ((MongoDBQueryDescriptorBuilder)parseResult.resultValue).build();
    }

    public DuplicateInsertPreventionStrategy getDuplicateInsertPreventionStrategy(EntityKeyMetadata entityKeyMetadata) {
        return DuplicateInsertPreventionStrategy.NATIVE;
    }

    private static ClosableIterator<Tuple> doAggregate(MongoDBQueryDescriptor query, QueryParameters queryParameters, DBCollection collection, EntityKeyMetadata entityKeyMetadata) {
        ArrayList<DBObject> pipeline = new ArrayList<DBObject>();
        pipeline.add(MongoDBDialect.stage("$match", query.getCriteria()));
        pipeline.add(MongoDBDialect.stage("$project", query.getProjection()));
        if (query.getUnwinds() != null && !query.getUnwinds().isEmpty()) {
            for (String field : query.getUnwinds()) {
                pipeline.add(MongoDBDialect.stage("$unwind", "$" + field));
            }
        }
        if (query.getOrderBy() != null) {
            pipeline.add(MongoDBDialect.stage("$sort", query.getOrderBy()));
        }
        if (queryParameters.getRowSelection().getFirstRow() != null) {
            pipeline.add(MongoDBDialect.stage("$skip", queryParameters.getRowSelection().getFirstRow()));
        }
        if (queryParameters.getRowSelection().getMaxRows() != null) {
            pipeline.add(MongoDBDialect.stage("$limit", queryParameters.getRowSelection().getMaxRows()));
        }
        AggregationOutput output = collection.aggregate(pipeline);
        return new MongoDBAggregationOutput(output, entityKeyMetadata);
    }

    private static DBObject stage(String key, Object value) {
        BasicDBObject stage = new BasicDBObject();
        stage.put(key, value);
        return stage;
    }

    private static ClosableIterator<Tuple> doFind(MongoDBQueryDescriptor query, QueryParameters queryParameters, DBCollection collection, EntityKeyMetadata entityKeyMetadata) {
        BasicDBObject criteria = (BasicDBObject)query.getCriteria();
        DBObject orderby = query.getOrderBy();
        String hintIndexName = null;
        DBObject hintDBObject = null;
        int maxScan = -1;
        long maxTimeMS = -1L;
        boolean snapshot = false;
        DBObject min = null;
        DBObject max = null;
        String comment = null;
        boolean explain = false;
        if (criteria.containsField("$query")) {
            Object hintObject;
            if (orderby == null) {
                orderby = (DBObject)criteria.get("$orderby");
            }
            if ((hintObject = criteria.get("$hint")) instanceof String) {
                hintIndexName = (String)hintObject;
            } else if (hintObject instanceof DBObject) {
                hintDBObject = (DBObject)hintObject;
            }
            maxScan = criteria.getInt("$maxScan", -1);
            maxTimeMS = criteria.getLong("$maxTimeMS", -1L);
            snapshot = criteria.getBoolean("$snapshot", false);
            min = (DBObject)criteria.get("$min");
            max = (DBObject)criteria.get("$max");
            comment = criteria.getString("$comment");
            explain = criteria.getBoolean("$explain", false);
            criteria = (BasicDBObject)criteria.get("$query");
        }
        DBCursor cursor = collection.find((DBObject)criteria, query.getProjection());
        if (orderby != null) {
            cursor.sort(orderby);
        }
        if (!StringHelper.isNullOrEmptyString(hintIndexName)) {
            cursor.hint(hintIndexName);
        }
        if (hintDBObject != null) {
            cursor.hint(hintDBObject);
        }
        if (maxScan > 0) {
            cursor.maxScan(maxScan);
        }
        if (maxTimeMS > 0L) {
            cursor.maxTime(maxTimeMS, TimeUnit.MILLISECONDS);
        }
        if (orderby == null && snapshot) {
            cursor.snapshot();
        }
        if (min != null) {
            cursor.min(min);
        }
        if (max != null) {
            cursor.max(max);
        }
        if (!StringHelper.isNullOrEmptyString(comment)) {
            cursor.comment(comment);
        }
        if (explain) {
            cursor.explain();
        }
        if (queryParameters.getRowSelection().getFirstRow() != null) {
            cursor.skip(queryParameters.getRowSelection().getFirstRow().intValue());
        }
        if (queryParameters.getRowSelection().getMaxRows() != null) {
            cursor.limit(queryParameters.getRowSelection().getMaxRows().intValue());
        }
        return new MongoDBResultsCursor(cursor, entityKeyMetadata);
    }

    private static ClosableIterator<Tuple> doFindOne(MongoDBQueryDescriptor query, DBCollection collection, EntityKeyMetadata entityKeyMetadata) {
        DBObject theOne = collection.findOne(query.getCriteria(), query.getProjection());
        return new SingleTupleIterator(theOne, collection, entityKeyMetadata);
    }

    private static ClosableIterator<Tuple> doFindAndModify(MongoDBQueryDescriptor queryDesc, DBCollection collection, EntityKeyMetadata entityKeyMetadata) {
        DBObject query = (DBObject)queryDesc.getCriteria().get("query");
        DBObject fields = (DBObject)queryDesc.getCriteria().get("fields");
        DBObject sort = (DBObject)queryDesc.getCriteria().get("sort");
        Boolean remove = (Boolean)queryDesc.getCriteria().get("remove");
        DBObject update = (DBObject)queryDesc.getCriteria().get("update");
        Boolean nevv = (Boolean)queryDesc.getCriteria().get("new");
        Boolean upsert = (Boolean)queryDesc.getCriteria().get("upsert");
        Boolean bypass = (Boolean)queryDesc.getCriteria().get("bypassDocumentValidation");
        DBObject o = (DBObject)queryDesc.getCriteria().get("writeConcern");
        WriteConcern wc = MongoDBDialect.getWriteConcern(o);
        DBObject theOne = collection.findAndModify(query, fields, sort, remove != null ? remove : false, update, nevv != null ? nevv : false, upsert != null ? upsert : false, bypass != null ? bypass : false, 0L, TimeUnit.MILLISECONDS, wc != null ? wc : collection.getWriteConcern());
        return new SingleTupleIterator(theOne, collection, entityKeyMetadata);
    }

    private static int doInsert(MongoDBQueryDescriptor queryDesc, DBCollection collection) {
        BulkWriteOperation bo;
        DBObject insert = queryDesc.getUpdateOrInsert();
        DBObject options = queryDesc.getOptions();
        Boolean ordered = Boolean.FALSE;
        WriteConcern wc = null;
        if (options != null) {
            ordered = (Boolean)options.get("ordered");
            ordered = ordered != null ? ordered : Boolean.FALSE;
            DBObject o = (DBObject)options.get("writeConcern");
            wc = MongoDBDialect.getWriteConcern(o);
        }
        BulkWriteOperation bulkWriteOperation = bo = ordered != false ? collection.initializeOrderedBulkOperation() : collection.initializeUnorderedBulkOperation();
        if (insert instanceof List) {
            for (DBObject i : (List)insert) {
                bo.insert(i);
            }
        } else {
            bo.insert(insert);
        }
        BulkWriteResult result = bo.execute(wc != null ? wc : collection.getWriteConcern());
        if (result.isAcknowledged()) {
            return result.getInsertedCount();
        }
        return -1;
    }

    private static int doRemove(MongoDBQueryDescriptor queryDesc, DBCollection collection) {
        WriteResult result;
        DBObject query = queryDesc.getCriteria();
        DBObject options = queryDesc.getOptions();
        Boolean justOne = Boolean.FALSE;
        WriteConcern wc = null;
        if (options != null) {
            justOne = (Boolean)options.get("justOne");
            Boolean bl = justOne = justOne != null ? justOne : Boolean.FALSE;
            if (justOne.booleanValue()) {
                throw new UnsupportedOperationException("Using 'justOne' in a remove query is not yet supported.");
            }
            DBObject o = (DBObject)options.get("writeConcern");
            wc = MongoDBDialect.getWriteConcern(o);
        }
        if ((result = collection.remove(query, wc != null ? wc : collection.getWriteConcern())).wasAcknowledged()) {
            return result.getN();
        }
        return -1;
    }

    private static int doUpdate(MongoDBQueryDescriptor queryDesc, DBCollection collection) {
        WriteResult result;
        DBObject query = queryDesc.getCriteria();
        DBObject update = queryDesc.getUpdateOrInsert();
        DBObject options = queryDesc.getOptions();
        Boolean upsert = Boolean.FALSE;
        Boolean multi = Boolean.FALSE;
        WriteConcern wc = null;
        if (options != null) {
            upsert = (Boolean)options.get("upsert");
            upsert = upsert != null ? upsert : Boolean.FALSE;
            multi = (Boolean)options.get("multi");
            multi = multi != null ? multi : Boolean.FALSE;
            DBObject o = (DBObject)options.get("writeConcern");
            wc = MongoDBDialect.getWriteConcern(o);
        }
        if ((result = collection.update(query, update, upsert.booleanValue(), multi.booleanValue(), wc != null ? wc : collection.getWriteConcern())).wasAcknowledged()) {
            return result.getN();
        }
        return -1;
    }

    private static ClosableIterator<Tuple> doCount(MongoDBQueryDescriptor query, DBCollection collection) {
        long count = collection.count(query.getCriteria());
        MapTupleSnapshot snapshot = new MapTupleSnapshot(Collections.singletonMap("n", count));
        return CollectionHelper.newClosableIterator(Collections.singletonList(new Tuple((TupleSnapshot)snapshot, Tuple.SnapshotType.UNKNOWN)));
    }

    private static WriteConcern getWriteConcern(DBObject obj) {
        WriteConcern wc = null;
        if (obj != null) {
            Object w = obj.get("w");
            Boolean j = (Boolean)obj.get("j");
            Integer t = (Integer)obj.get("wtimeout");
            if (w instanceof String) {
                wc = new WriteConcern((String)w, t != null ? t : 0, false, j != null ? j : false);
            }
            if (w instanceof Number) {
                wc = new WriteConcern(((Number)w).intValue(), t != null ? t : 0, false, j != null ? j : false);
            }
        }
        return wc;
    }

    private static String getCollectionName(BackendQuery<?> customQuery, MongoDBQueryDescriptor queryDescriptor, EntityKeyMetadata entityKeyMetadata) {
        if (queryDescriptor.getCollectionName() != null) {
            return queryDescriptor.getCollectionName();
        }
        if (entityKeyMetadata != null) {
            return entityKeyMetadata.getTable();
        }
        throw log.unableToDetermineCollectionName(customQuery.getQuery().toString());
    }

    private static DBObject associationKeyToObject(AssociationKey key, AssociationStorageStrategy storageStrategy) {
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            throw new AssertionFailure(MongoHelpers.class.getName() + ".associationKeyToObject should not be called for associations embedded in entity documents");
        }
        Object[] columnValues = key.getColumnValues();
        BasicDBObject columns = new BasicDBObject(columnValues.length);
        String prefix = DocumentHelpers.getColumnSharedPrefix((String[])key.getColumnNames());
        prefix = prefix == null ? "" : prefix + PROPERTY_SEPARATOR;
        int i = 0;
        for (String name : key.getColumnNames()) {
            MongoHelpers.setValue((DBObject)columns, name.substring(prefix.length()), columnValues[i++]);
        }
        BasicDBObject idObject = new BasicDBObject(1);
        if (storageStrategy == AssociationStorageStrategy.GLOBAL_COLLECTION) {
            columns.put(TABLE_FIELDNAME, (Object)key.getTable());
        }
        idObject.put((Object)ID_FIELDNAME, (Object)columns);
        return idObject;
    }

    private static AssociationStorageStrategy getAssociationStorageStrategy(AssociationKey key, AssociationContext associationContext) {
        return MongoDBDialect.getAssociationStorageStrategy(key.getMetadata(), associationContext.getAssociationTypeContext());
    }

    private static AssociationStorageStrategy getAssociationStorageStrategy(AssociationKeyMetadata keyMetadata, AssociationTypeContext associationTypeContext) {
        AssociationStorageType associationStorage = (AssociationStorageType)associationTypeContext.getOptionsContext().getUnique(AssociationStorageOption.class);
        AssociationDocumentStorageType associationDocumentStorageType = (AssociationDocumentStorageType)((Object)associationTypeContext.getOptionsContext().getUnique(AssociationDocumentStorageOption.class));
        return AssociationStorageStrategy.getInstance(keyMetadata, associationStorage, associationDocumentStorageType);
    }

    public void executeBatch(OperationsQueue queue) {
        if (!queue.isClosed()) {
            Operation operation = queue.poll();
            HashMap<DBCollection, BatchInsertionTask> inserts = new HashMap<DBCollection, BatchInsertionTask>();
            ArrayList<Tuple> insertTuples = new ArrayList<Tuple>();
            while (operation != null) {
                if (operation instanceof GroupedChangesToEntityOperation) {
                    GroupedChangesToEntityOperation entityOperation = (GroupedChangesToEntityOperation)operation;
                    this.executeBatchUpdate(inserts, insertTuples, entityOperation);
                } else if (operation instanceof RemoveTupleOperation) {
                    RemoveTupleOperation removeTupleOperation = (RemoveTupleOperation)operation;
                    this.executeBatchRemove(inserts, removeTupleOperation);
                } else {
                    throw new UnsupportedOperationException("Operation not supported: " + operation.getClass().getSimpleName());
                }
                operation = queue.poll();
            }
            MongoDBDialect.flushInserts(inserts);
            for (Tuple insertTuple : insertTuples) {
                insertTuple.setSnapshotType(Tuple.SnapshotType.UPDATE);
            }
            queue.clear();
        }
    }

    private void executeBatchRemove(Map<DBCollection, BatchInsertionTask> inserts, RemoveTupleOperation tupleOperation) {
        EntityKey entityKey = tupleOperation.getEntityKey();
        DBCollection collection = this.getCollection(entityKey);
        BatchInsertionTask batchedInserts = inserts.get(collection);
        if (batchedInserts != null && batchedInserts.containsKey(entityKey)) {
            batchedInserts.remove(entityKey);
        } else {
            this.removeTuple(entityKey, tupleOperation.getTupleContext());
        }
    }

    private void executeBatchUpdate(Map<DBCollection, BatchInsertionTask> inserts, List<Tuple> insertTuples, GroupedChangesToEntityOperation groupedOperation) {
        EntityKey entityKey = groupedOperation.getEntityKey();
        DBCollection collection = this.getCollection(entityKey);
        DBObject insertStatement = null;
        BasicDBObject updateStatement = new BasicDBObject();
        WriteConcern writeConcern = null;
        for (Operation operation : groupedOperation.getOperations()) {
            if (operation instanceof InsertOrUpdateTupleOperation) {
                InsertOrUpdateTupleOperation tupleOperation = (InsertOrUpdateTupleOperation)operation;
                Tuple tuple = tupleOperation.getTuplePointer().getTuple();
                MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tuple.getSnapshot();
                writeConcern = MongoDBDialect.mergeWriteConcern(writeConcern, MongoDBDialect.getWriteConcern(tupleOperation.getTupleContext()));
                if (Tuple.SnapshotType.INSERT == tuple.getSnapshotType()) {
                    DBObject document = MongoDBDialect.getCurrentDocument(snapshot, insertStatement, entityKey);
                    insertStatement = MongoDBDialect.objectForInsert(tuple, document);
                    MongoDBDialect.getOrCreateBatchInsertionTask(inserts, entityKey.getMetadata(), collection, writeConcern).put(entityKey, insertStatement);
                    insertTuples.add(tuple);
                    continue;
                }
                updateStatement = MongoDBDialect.objectForUpdate(tuple, tupleOperation.getTupleContext(), updateStatement);
                continue;
            }
            if (operation instanceof InsertOrUpdateAssociationOperation) {
                Object toStore;
                InsertOrUpdateAssociationOperation updateAssociationOperation = (InsertOrUpdateAssociationOperation)operation;
                Association association = updateAssociationOperation.getAssociation();
                AssociationKey associationKey = updateAssociationOperation.getAssociationKey();
                AssociationContext associationContext = updateAssociationOperation.getContext();
                AssociationStorageStrategy storageStrategy = MongoDBDialect.getAssociationStorageStrategy(associationKey, associationContext);
                String collectionRole = associationKey.getMetadata().getCollectionRole();
                Object rows = MongoDBDialect.getAssociationRows(association, associationKey, associationContext);
                Object object = toStore = associationKey.getMetadata().getAssociationType() == AssociationType.ONE_TO_ONE ? ((List)rows).get(0) : rows;
                if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
                    writeConcern = MongoDBDialect.mergeWriteConcern(writeConcern, MongoDBDialect.getWriteConcern(associationContext));
                    if (insertStatement != null) {
                        MongoHelpers.setValue(insertStatement, collectionRole, rows);
                        continue;
                    }
                    MongoHelpers.setValue(((MongoDBTupleSnapshot)associationContext.getEntityTuplePointer().getTuple().getSnapshot()).getDbObject(), associationKey.getMetadata().getCollectionRole(), toStore);
                    MongoDBDialect.addSetToQuery(updateStatement, collectionRole, toStore);
                    continue;
                }
                MongoDBAssociationSnapshot associationSnapshot = (MongoDBAssociationSnapshot)association.getSnapshot();
                DBCollection associationCollection = this.getAssociationCollection(associationKey, storageStrategy);
                DBObject query = associationSnapshot.getQueryObject();
                BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject(ROWS_FIELDNAME, toStore));
                associationCollection.update(query, (DBObject)update, true, false, MongoDBDialect.getWriteConcern(associationContext));
                continue;
            }
            if (operation instanceof RemoveAssociationOperation) {
                AssociationContext associationContext;
                if (insertStatement != null) {
                    throw new IllegalStateException("RemoveAssociationOperation not supported in the INSERT case");
                }
                RemoveAssociationOperation removeAssociationOperation = (RemoveAssociationOperation)operation;
                AssociationKey associationKey = removeAssociationOperation.getAssociationKey();
                AssociationStorageStrategy storageStrategy = MongoDBDialect.getAssociationStorageStrategy(associationKey, associationContext = removeAssociationOperation.getContext());
                if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
                    writeConcern = MongoDBDialect.mergeWriteConcern(writeConcern, MongoDBDialect.getWriteConcern(associationContext));
                    String collectionRole = associationKey.getMetadata().getCollectionRole();
                    if (associationContext.getEntityTuplePointer().getTuple() != null) {
                        MongoHelpers.resetValue(((MongoDBTupleSnapshot)associationContext.getEntityTuplePointer().getTuple().getSnapshot()).getDbObject(), collectionRole);
                    }
                    MongoDBDialect.addUnsetToQuery(updateStatement, collectionRole);
                    continue;
                }
                DBCollection associationCollection = this.getAssociationCollection(associationKey, storageStrategy);
                DBObject query = MongoDBDialect.associationKeyToObject(associationKey, storageStrategy);
                int nAffected = associationCollection.remove(query, MongoDBDialect.getWriteConcern(associationContext)).getN();
                log.removedAssociation(nAffected);
                continue;
            }
            throw new IllegalStateException(operation.getClass().getSimpleName() + " not supported here");
        }
        if (updateStatement != null && !updateStatement.isEmpty()) {
            collection.update((DBObject)MongoDBDialect.prepareIdObject(entityKey), (DBObject)updateStatement, true, false, writeConcern);
        }
    }

    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return NoOpParameterMetadataBuilder.INSTANCE;
    }

    private static DBObject getCurrentDocument(MongoDBTupleSnapshot snapshot, DBObject insertStatement, EntityKey entityKey) {
        return insertStatement != null ? insertStatement : snapshot.getDbObject();
    }

    private static BatchInsertionTask getOrCreateBatchInsertionTask(Map<DBCollection, BatchInsertionTask> inserts, EntityKeyMetadata entityKeyMetadata, DBCollection collection, WriteConcern writeConcern) {
        BatchInsertionTask insertsForCollection = inserts.get(collection);
        if (insertsForCollection == null) {
            insertsForCollection = new BatchInsertionTask(entityKeyMetadata, writeConcern);
            inserts.put(collection, insertsForCollection);
        }
        return insertsForCollection;
    }

    private static void flushInserts(Map<DBCollection, BatchInsertionTask> inserts) {
        for (Map.Entry<DBCollection, BatchInsertionTask> entry : inserts.entrySet()) {
            DBCollection collection = entry.getKey();
            if (entry.getValue().isEmpty()) continue;
            try {
                collection.insert(entry.getValue().getAll(), entry.getValue().getWriteConcern());
            }
            catch (DuplicateKeyException dke) {
                if (PRIMARY_KEY_CONSTRAINT_VIOLATION_MESSAGE.matcher(dke.getMessage()).matches()) {
                    throw new TupleAlreadyExistsException(entry.getValue().getEntityKeyMetadata(), (Throwable)dke);
                }
                throw log.constraintViolationOnFlush(dke.getMessage(), (Exception)((Object)dke));
            }
        }
        inserts.clear();
    }

    private static WriteConcern getWriteConcern(TupleContext tupleContext) {
        return (WriteConcern)tupleContext.getTupleTypeContext().getOptionsContext().getUnique(WriteConcernOption.class);
    }

    private static WriteConcern getWriteConcern(AssociationContext associationContext) {
        return (WriteConcern)associationContext.getAssociationTypeContext().getOptionsContext().getUnique(WriteConcernOption.class);
    }

    private static WriteConcern mergeWriteConcern(WriteConcern original, WriteConcern writeConcern) {
        boolean fsync;
        if (original == null) {
            return writeConcern;
        }
        if (writeConcern == null) {
            return original;
        }
        if (original.equals((Object)writeConcern)) {
            return original;
        }
        Object wObject = original.getWObject() instanceof String ? original.getWString() : (writeConcern.getWObject() instanceof String ? writeConcern.getWString() : Integer.valueOf(Math.max(original.getW(), writeConcern.getW())));
        int wTimeoutMS = Math.min(original.getWtimeout(), writeConcern.getWtimeout());
        boolean bl = fsync = original.getFsync() || writeConcern.getFsync();
        Boolean journal = original.getJournal() == null ? writeConcern.getJournal() : (writeConcern.getJournal() == null ? original.getJournal() : Boolean.valueOf(original.getJournal() != false || writeConcern.getJournal() != false));
        if (wObject instanceof String) {
            return new WriteConcern((String)wObject, wTimeoutMS, fsync, journal.booleanValue());
        }
        return new WriteConcern(((Integer)wObject).intValue(), wTimeoutMS, fsync, journal.booleanValue());
    }

    private static ReadPreference getReadPreference(OperationContext operationContext) {
        return (ReadPreference)operationContext.getTupleTypeContext().getOptionsContext().getUnique(ReadPreferenceOption.class);
    }

    private static ReadPreference getReadPreference(AssociationContext associationContext) {
        return (ReadPreference)associationContext.getAssociationTypeContext().getOptionsContext().getUnique(ReadPreferenceOption.class);
    }

    private static class BatchInsertionTask {
        private final EntityKeyMetadata entityKeyMetadata;
        private final Map<EntityKey, DBObject> inserts;
        private final WriteConcern writeConcern;

        public BatchInsertionTask(EntityKeyMetadata entityKeyMetadata, WriteConcern writeConcern) {
            this.entityKeyMetadata = entityKeyMetadata;
            this.inserts = new HashMap<EntityKey, DBObject>();
            this.writeConcern = writeConcern;
        }

        public EntityKeyMetadata getEntityKeyMetadata() {
            return this.entityKeyMetadata;
        }

        public List<DBObject> getAll() {
            return new ArrayList<DBObject>(this.inserts.values());
        }

        public DBObject get(EntityKey entityKey) {
            return this.inserts.get(entityKey);
        }

        public boolean containsKey(EntityKey entityKey) {
            return this.inserts.containsKey(entityKey);
        }

        public DBObject remove(EntityKey entityKey) {
            return this.inserts.remove(entityKey);
        }

        public void put(EntityKey entityKey, DBObject object) {
            this.inserts.put(entityKey, object);
        }

        public WriteConcern getWriteConcern() {
            return this.writeConcern;
        }

        public boolean isEmpty() {
            return this.inserts.isEmpty();
        }
    }

    private static class SingleTupleIterator
    implements ClosableIterator<Tuple> {
        private DBObject theOne;
        private final EntityKeyMetadata metadata;
        private final DBCollection collection;

        public SingleTupleIterator(DBObject theOne, DBCollection collection, EntityKeyMetadata metadata) {
            this.theOne = theOne;
            this.collection = collection;
            this.metadata = metadata;
        }

        public boolean hasNext() {
            return this.theOne != null;
        }

        public Tuple next() {
            if (this.theOne == null) {
                throw new NoSuchElementException();
            }
            Tuple t = new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(this.theOne, this.metadata), Tuple.SnapshotType.UPDATE);
            this.theOne = null;
            return t;
        }

        public void remove() {
            if (this.theOne == null) {
                throw new IllegalStateException();
            }
            this.collection.remove(this.theOne);
            this.theOne = null;
        }

        public void close() {
        }
    }

    private static class MongoDBResultsCursor
    implements ClosableIterator<Tuple> {
        private final DBCursor cursor;
        private final EntityKeyMetadata metadata;

        public MongoDBResultsCursor(DBCursor cursor, EntityKeyMetadata metadata) {
            this.cursor = cursor;
            this.metadata = metadata;
        }

        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        public Tuple next() {
            DBObject dbObject = this.cursor.next();
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(dbObject, this.metadata), Tuple.SnapshotType.UPDATE);
        }

        public void remove() {
            this.cursor.remove();
        }

        public void close() {
            this.cursor.close();
        }
    }

    private static class MongoDBAggregationOutput
    implements ClosableIterator<Tuple> {
        private final Iterator<DBObject> results;
        private final EntityKeyMetadata metadata;

        public MongoDBAggregationOutput(AggregationOutput output, EntityKeyMetadata metadata) {
            this.results = output.results().iterator();
            this.metadata = metadata;
        }

        public boolean hasNext() {
            return this.results.hasNext();
        }

        public Tuple next() {
            DBObject dbObject = this.results.next();
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(dbObject, this.metadata), Tuple.SnapshotType.UPDATE);
        }

        public void remove() {
            this.results.remove();
        }

        public void close() {
        }
    }
}

