/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBPredicateFactory;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBPropertyHelper;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBQueryParsingResult;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.util.impl.StringHelper;

public class MongoDBQueryRendererDelegate
extends SingleEntityQueryRendererDelegate<DBObject, MongoDBQueryParsingResult> {
    private static final Log log = LoggerFactory.getLogger();
    private final SessionFactoryImplementor sessionFactory;
    private final MongoDBPropertyHelper propertyHelper;
    private DBObject orderBy;
    private List<String> unwinds;

    public MongoDBQueryRendererDelegate(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames, MongoDBPropertyHelper propertyHelper, Map<String, Object> namedParameters) {
        super((PropertyHelper)propertyHelper, entityNames, SingleEntityQueryBuilder.getInstance((PredicateFactory)new MongoDBPredicateFactory(propertyHelper), (PropertyHelper)propertyHelper), namedParameters);
        this.sessionFactory = sessionFactory;
        this.propertyHelper = propertyHelper;
    }

    public MongoDBQueryParsingResult getResult() {
        OgmEntityPersister entityPersister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(this.targetType.getName());
        DBObject query = this.appendDiscriminatorClause(entityPersister, (DBObject)this.builder.build());
        return new MongoDBQueryParsingResult(this.targetType, entityPersister.getTableName(), query, this.getProjectionDBObject(), this.orderBy, this.unwinds);
    }

    private DBObject appendDiscriminatorClause(OgmEntityPersister entityPersister, DBObject query) {
        String discriminatorColumnName = entityPersister.getDiscriminatorColumnName();
        if (discriminatorColumnName != null) {
            BasicDBObject discriminatorFilter = this.createDiscriminatorFilter(entityPersister, discriminatorColumnName);
            if (query.keySet().isEmpty()) {
                return discriminatorFilter;
            }
            return new BasicDBObject("$and", Arrays.asList(query, discriminatorFilter));
        }
        if (entityPersister.hasSubclasses()) {
            Set subclassEntityNames = entityPersister.getEntityMetamodel().getSubclassEntityNames();
            throw log.queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass("MongoDB", subclassEntityNames);
        }
        return query;
    }

    private BasicDBObject createDiscriminatorFilter(OgmEntityPersister entityPersister, String discriminatorColumnName) {
        Object discriminatorValue = entityPersister.getDiscriminatorValue();
        BasicDBObject discriminatorFilter = null;
        Set subclassEntityNames = entityPersister.getEntityMetamodel().getSubclassEntityNames();
        if (subclassEntityNames.size() == 1) {
            discriminatorFilter = new BasicDBObject(discriminatorColumnName, discriminatorValue);
        } else {
            HashSet<Object> discriminatorValues = new HashSet<Object>();
            discriminatorValues.add(discriminatorValue);
            for (String subclass : subclassEntityNames) {
                OgmEntityPersister subclassPersister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(subclass);
                Object subDiscriminatorValue = subclassPersister.getDiscriminatorValue();
                discriminatorValues.add(subDiscriminatorValue);
            }
            discriminatorFilter = new BasicDBObject(discriminatorColumnName, (Object)new BasicDBObject("$in", discriminatorValues));
        }
        return discriminatorFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyPath(PropertyPath propertyPath) {
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_SELECT) {
            List pathWithoutAlias = this.resolveAlias(propertyPath);
            if (this.propertyHelper.isSimpleProperty(pathWithoutAlias)) {
                this.projections.add(this.propertyHelper.getColumnName(this.targetTypeName, (List<String>)propertyPath.getNodeNamesWithoutAlias()));
                return;
            } else {
                String field;
                if (!this.propertyHelper.isNestedProperty(pathWithoutAlias)) return;
                if (!this.propertyHelper.isEmbeddedProperty(this.targetTypeName, pathWithoutAlias)) throw new UnsupportedOperationException("Selecting associated properties not yet implemented.");
                String columnName = this.propertyHelper.getColumnName(this.targetTypeName, (List<String>)pathWithoutAlias);
                this.projections.add(columnName);
                List associationPath = this.propertyHelper.findAssociationPath(this.targetTypeName, pathWithoutAlias);
                if (associationPath == null) return;
                if (this.unwinds == null) {
                    this.unwinds = new ArrayList<String>();
                }
                if (this.unwinds.contains(field = StringHelper.join((Iterable)associationPath, (String)"."))) return;
                this.unwinds.add(field);
            }
            return;
        } else {
            this.propertyPath = propertyPath;
        }
    }

    private DBObject getProjectionDBObject() {
        if (this.projections.isEmpty()) {
            return null;
        }
        BasicDBObject projectionDBObject = new BasicDBObject();
        for (String projection : this.projections) {
            projectionDBObject.put(projection, (Object)1);
        }
        return projectionDBObject;
    }

    protected void addSortField(PropertyPath propertyPath, String collateName, boolean isAscending) {
        if (this.orderBy == null) {
            this.orderBy = new BasicDBObject();
        }
        String columnName = this.propertyHelper.getColumnName(this.targetType, (List<String>)propertyPath.getNodeNamesWithoutAlias());
        this.orderBy.put(columnName, (Object)(isAscending ? 1 : -1));
    }
}

