/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.index.impl;

import com.mongodb.client.model.IndexOptions;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.UniqueKey;

public class MongoDBIndexSpec {
    private String collection;
    private String indexName;
    private Document indexKeys = new Document();
    private IndexOptions options;
    private boolean isTextIndex = false;

    public MongoDBIndexSpec(String collection, String columnName, String indexName, Document options) {
        this.options = this.prepareOptions(options, indexName, true);
        this.collection = collection;
        this.indexName = indexName;
        this.indexKeys.put(columnName, (Object)1);
    }

    public MongoDBIndexSpec(UniqueKey uniqueKey, Document options) {
        this.options = this.prepareOptions(options, uniqueKey.getName(), true);
        this.collection = uniqueKey.getTable().getName();
        this.indexName = uniqueKey.getName();
        this.addIndexKeys(uniqueKey.getColumnIterator(), uniqueKey.getColumnOrderMap());
    }

    public MongoDBIndexSpec(Index index, Document options) {
        this.options = this.prepareOptions(options, index.getName(), false);
        this.collection = index.getTable().getName();
        this.indexName = index.getName();
        this.addIndexKeys(index.getColumnIterator(), Collections.emptyMap());
    }

    private IndexOptions prepareOptions(Document options, String indexName, boolean unique) {
        IndexOptions indexOptions = new IndexOptions();
        indexOptions.name(indexName).unique(unique).background(options.getBoolean((Object)"background", false));
        if (unique) {
            indexOptions.sparse(!options.containsKey((Object)"partialFilterExpression"));
        } else if (options.containsKey((Object)"partialFilterExpression")) {
            indexOptions.partialFilterExpression((Bson)options.get((Object)"partialFilterExpression"));
        }
        if (options.containsKey((Object)"expireAfterSeconds")) {
            indexOptions.expireAfter(Long.valueOf(options.getInteger((Object)"expireAfterSeconds").longValue()), TimeUnit.SECONDS);
        }
        if (Boolean.TRUE.equals(options.get((Object)"text"))) {
            if (options.containsKey((Object)"default_language")) {
                indexOptions.defaultLanguage(options.getString((Object)"default_language"));
            }
            if (options.containsKey((Object)"weights")) {
                indexOptions.weights((Bson)options.get((Object)"weights"));
            }
            this.isTextIndex = true;
            options.remove((Object)"text");
        }
        return indexOptions;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean isTextIndex() {
        return this.isTextIndex;
    }

    private void addIndexKeys(Iterator<Column> columnIterator, Map<Column, String> columnOrderMap) {
        while (columnIterator.hasNext()) {
            Object mongoDBOrder;
            Column column = columnIterator.next();
            if (this.isTextIndex) {
                mongoDBOrder = "text";
            } else {
                String order = columnOrderMap.get(column) != null ? columnOrderMap.get(column) : "asc";
                mongoDBOrder = "asc".equals(order) ? 1 : -1;
            }
            this.indexKeys.put(column.getName(), mongoDBOrder);
        }
    }

    public IndexOptions getOptions() {
        return this.options;
    }

    public Document getIndexKeysDocument() {
        return this.indexKeys;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append("collection: ").append(this.collection).append(", ");
        sb.append("indexName: ").append(this.indexName);
        sb.append("]");
        return sb.toString();
    }
}

