/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.type.impl;

import java.util.function.Function;
import org.bson.Document;
import org.hibernate.ogm.datastore.mongodb.type.AbstractGeoJsonObject;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.descriptor.impl.BasicGridBinder;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.impl.GridValueBinder;
import org.hibernate.ogm.type.descriptor.impl.GridValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

class AbstractGeoJsonObjectGridTypeDescriptor<T extends AbstractGeoJsonObject>
implements GridTypeDescriptor {
    private final Class<T> geoObjectClass;
    private final Function<Document, T> geoObjectSupplier;

    protected AbstractGeoJsonObjectGridTypeDescriptor(Class<T> geoObjectClass, Function<Document, T> geoObjectSupplier) {
        this.geoObjectClass = geoObjectClass;
        this.geoObjectSupplier = geoObjectSupplier;
    }

    public <X> GridValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicGridBinder<X>(javaTypeDescriptor, this){

            protected void doBind(Tuple resultset, X value, String[] names, WrapperOptions options) {
                AbstractGeoJsonObject geoObject = (AbstractGeoJsonObject)javaTypeDescriptor.unwrap(value, AbstractGeoJsonObjectGridTypeDescriptor.this.geoObjectClass, options);
                resultset.put(names[0], (Object)geoObject.toBsonDocument());
            }
        };
    }

    public <X> GridValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new GridValueExtractor<X>(){

            public X extract(Tuple resultset, String name) {
                Document document = (Document)resultset.get(name);
                if (document == null) {
                    return null;
                }
                return javaTypeDescriptor.wrap(AbstractGeoJsonObjectGridTypeDescriptor.this.geoObjectSupplier.apply(document), null);
            }
        };
    }
}

