/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBPredicateFactory;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBPropertyHelper;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBQueryParsingResult;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.util.impl.StringHelper;

public class MongoDBQueryRendererDelegate
extends SingleEntityQueryRendererDelegate<Document, MongoDBQueryParsingResult> {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final SessionFactoryImplementor sessionFactory;
    private final MongoDBPropertyHelper propertyHelper;
    private Document orderBy;
    private List<String> unwinds;

    public MongoDBQueryRendererDelegate(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames, MongoDBPropertyHelper propertyHelper, Map<String, Object> namedParameters) {
        super((PropertyHelper)propertyHelper, entityNames, SingleEntityQueryBuilder.getInstance((PredicateFactory)new MongoDBPredicateFactory(propertyHelper), (PropertyHelper)propertyHelper), namedParameters);
        this.sessionFactory = sessionFactory;
        this.propertyHelper = propertyHelper;
    }

    public MongoDBQueryParsingResult getResult() {
        OgmEntityPersister entityPersister = (OgmEntityPersister)this.sessionFactory.getMetamodel().entityPersister(this.targetType);
        Document query = this.appendDiscriminatorClause(entityPersister, (Document)this.builder.build());
        return new MongoDBQueryParsingResult(this.targetType, entityPersister.getTableName(), query, this.getProjectionDocument(), this.orderBy, this.unwinds);
    }

    private Document appendDiscriminatorClause(OgmEntityPersister entityPersister, Document query) {
        String discriminatorColumnName = entityPersister.getDiscriminatorColumnName();
        if (discriminatorColumnName != null) {
            Document discriminatorFilter = this.createDiscriminatorFilter(entityPersister, discriminatorColumnName);
            if (query.keySet().isEmpty()) {
                return discriminatorFilter;
            }
            return new Document("$and", Arrays.asList(query, discriminatorFilter));
        }
        if (entityPersister.hasSubclasses()) {
            Set subclassEntityNames = entityPersister.getEntityMetamodel().getSubclassEntityNames();
            throw log.queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass("MongoDB", subclassEntityNames);
        }
        return query;
    }

    private Document createDiscriminatorFilter(OgmEntityPersister entityPersister, String discriminatorColumnName) {
        Object discriminatorValue = entityPersister.getDiscriminatorValue();
        Document discriminatorFilter = null;
        Set subclassEntityNames = entityPersister.getEntityMetamodel().getSubclassEntityNames();
        if (subclassEntityNames.size() == 1) {
            discriminatorFilter = new Document(discriminatorColumnName, discriminatorValue);
        } else {
            HashSet<Object> discriminatorValues = new HashSet<Object>();
            discriminatorValues.add(discriminatorValue);
            for (String subclass : subclassEntityNames) {
                OgmEntityPersister subclassPersister = (OgmEntityPersister)this.sessionFactory.getMetamodel().entityPersister(subclass);
                Object subDiscriminatorValue = subclassPersister.getDiscriminatorValue();
                discriminatorValues.add(subDiscriminatorValue);
            }
            discriminatorFilter = new Document(discriminatorColumnName, (Object)new Document("$in", discriminatorValues));
        }
        return discriminatorFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyPath(PropertyPath propertyPath) {
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_SELECT) {
            List pathWithoutAlias = this.resolveAlias(propertyPath);
            if (this.propertyHelper.isSimpleProperty(pathWithoutAlias)) {
                this.projections.add(this.propertyHelper.getColumnName(this.targetTypeName, (List<String>)propertyPath.getNodeNamesWithoutAlias()));
                return;
            } else {
                String field;
                if (!this.propertyHelper.isNestedProperty(pathWithoutAlias)) return;
                if (!this.propertyHelper.isEmbeddedProperty(this.targetTypeName, pathWithoutAlias)) throw new UnsupportedOperationException("Selecting associated properties not yet implemented.");
                String columnName = this.propertyHelper.getColumnName(this.targetTypeName, (List<String>)pathWithoutAlias);
                this.projections.add(columnName);
                List associationPath = this.propertyHelper.findAssociationPath(this.targetTypeName, pathWithoutAlias);
                if (associationPath == null) return;
                if (this.unwinds == null) {
                    this.unwinds = new ArrayList<String>();
                }
                if (this.unwinds.contains(field = StringHelper.join((Iterable)associationPath, (String)"."))) return;
                this.unwinds.add(field);
            }
            return;
        } else {
            this.propertyPath = propertyPath;
        }
    }

    private Document getProjectionDocument() {
        if (this.projections.isEmpty()) {
            return null;
        }
        Document projectionDocument = new Document();
        for (String projection : this.projections) {
            projectionDocument.put(projection, (Object)1);
        }
        return projectionDocument;
    }

    protected void addSortField(PropertyPath propertyPath, String collateName, boolean isAscending) {
        if (this.orderBy == null) {
            this.orderBy = new Document();
        }
        String columnName = this.propertyHelper.getColumnName(this.targetType, (List<String>)propertyPath.getNodeNamesWithoutAlias());
        this.orderBy.put(columnName, (Object)(isAscending ? 1 : -1));
    }
}

