/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import java.util.List;
import org.bson.Document;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.ConjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.DisjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.InPredicate;
import org.hibernate.hql.ast.spi.predicate.IsNullPredicate;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegationPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.hql.ast.spi.predicate.RangePredicate;
import org.hibernate.hql.ast.spi.predicate.RootPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBPropertyHelper;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBComparisonPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBConjunctionPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBDisjunctionPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBInPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBIsNullPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBLikePredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBNegationPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBRangePredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBRootPredicate;

public class MongoDBPredicateFactory
implements PredicateFactory<Document> {
    private final MongoDBPropertyHelper propertyHelper;

    public MongoDBPredicateFactory(MongoDBPropertyHelper propertyHelper) {
        this.propertyHelper = propertyHelper;
    }

    public RootPredicate<Document> getRootPredicate(String entityType) {
        return new MongoDBRootPredicate();
    }

    public ComparisonPredicate<Document> getComparisonPredicate(String entityType, ComparisonPredicate.Type comparisonType, List<String> propertyPath, Object value) {
        String columnName = this.columnName(entityType, propertyPath);
        return new MongoDBComparisonPredicate(columnName, comparisonType, value);
    }

    public RangePredicate<Document> getRangePredicate(String entityType, List<String> propertyPath, Object lowerValue, Object upperValue) {
        String columnName = this.columnName(entityType, propertyPath);
        return new MongoDBRangePredicate(columnName, lowerValue, upperValue);
    }

    public NegationPredicate<Document> getNegationPredicate() {
        return new MongoDBNegationPredicate();
    }

    public DisjunctionPredicate<Document> getDisjunctionPredicate() {
        return new MongoDBDisjunctionPredicate();
    }

    public ConjunctionPredicate<Document> getConjunctionPredicate() {
        return new MongoDBConjunctionPredicate();
    }

    public InPredicate<Document> getInPredicate(String entityType, List<String> propertyPath, List<Object> typedElements) {
        String columnName = this.columnName(entityType, propertyPath);
        return new MongoDBInPredicate(columnName, typedElements);
    }

    public IsNullPredicate<Document> getIsNullPredicate(String entityType, List<String> propertyPath) {
        String columnName = this.columnName(entityType, propertyPath);
        return new MongoDBIsNullPredicate(columnName);
    }

    public LikePredicate<Document> getLikePredicate(String entityType, List<String> propertyPath, String patternValue, Character escapeCharacter) {
        String columnName = this.columnName(entityType, propertyPath);
        return new MongoDBLikePredicate(columnName, patternValue, escapeCharacter);
    }

    private String columnName(String entityType, List<String> propertyPath) {
        return this.propertyHelper.getColumnName(entityType, propertyPath);
    }
}

