/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.query.parsing.impl.ParserPropertyHelper;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class MongoDBPropertyHelper
extends ParserPropertyHelper
implements PropertyHelper {
    private final SessionFactoryImplementor sessionFactory;

    public MongoDBPropertyHelper(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames) {
        super(sessionFactory, entityNames);
        this.sessionFactory = sessionFactory;
    }

    public String getColumnName(Class<?> entityType, List<String> propertyName) {
        return this.getColumnName((OgmEntityPersister)this.getSessionFactory().getMetamodel().entityPersister(entityType), propertyName);
    }

    public String getColumnName(String entityType, List<String> propertyPath) {
        return this.getColumnName(this.getPersister(entityType), propertyPath);
    }

    protected Type getPropertyType(String entityType, List<String> propertyPath) {
        Type propertyType = super.getPropertyType(entityType, propertyPath);
        if (this.isElementCollection(propertyType)) {
            return ((CollectionType)propertyType).getElementType(this.sessionFactory);
        }
        return propertyType;
    }

    public Object convertToBackendType(String entityType, List<String> propertyPath, Object value) {
        Type propertyType = this.getPropertyType(entityType, propertyPath);
        if (this.isElementCollection(propertyType)) {
            propertyType = ((CollectionType)propertyType).getElementType(this.sessionFactory);
        }
        GridType ogmType = ((TypeTranslator)this.sessionFactory.getServiceRegistry().getService(TypeTranslator.class)).getType(propertyType);
        return ogmType.convertToBackendType(value, this.sessionFactory);
    }

    public String getColumnName(OgmEntityPersister persister, List<String> propertyPath) {
        String identifierPropertyName;
        String propertyName = StringHelper.join(propertyPath, (String)".");
        if (propertyName.equals(identifierPropertyName = persister.getIdentifierPropertyName())) {
            return "_id";
        }
        String column = this.getColumn(persister, propertyPath);
        if (propertyPath.size() > 1 && propertyPath.get(0).equals(identifierPropertyName)) {
            column = "_id." + column.substring(propertyPath.get(0).length() + 1);
        }
        return column;
    }
}

