/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.type;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;

public abstract class AbstractGeoJsonObject
implements Serializable {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private String type;

    protected AbstractGeoJsonObject(String type) {
        this.type = type;
    }

    public BsonDocument toBsonDocument() {
        BsonDocument document = new BsonDocument();
        document.put("type", (BsonValue)new BsonString(this.type));
        document.put("coordinates", (BsonValue)this.toCoordinates());
        return document;
    }

    protected abstract BsonArray toCoordinates();

    protected static void checkType(String expectedType, Document document) {
        String documentType = document.getString((Object)"type");
        if (!expectedType.equals(documentType)) {
            throw log.invalidGeoJsonType(documentType, expectedType);
        }
    }
}

