/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.type.impl;

import org.bson.BsonBinary;
import org.bson.types.Binary;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.descriptor.impl.BasicGridBinder;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.impl.GridValueBinder;
import org.hibernate.ogm.type.descriptor.impl.GridValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class BinaryMappedGridTypeDescriptor
implements GridTypeDescriptor {
    public static final BinaryMappedGridTypeDescriptor INSTANCE = new BinaryMappedGridTypeDescriptor();

    public <X> GridValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicGridBinder<X>(javaTypeDescriptor, this){

            protected void doBind(Tuple resultset, X value, String[] names, WrapperOptions options) {
                byte[] data = (byte[])javaTypeDescriptor.unwrap(value, byte[].class, options);
                resultset.put(names[0], (Object)new BsonBinary(data));
            }
        };
    }

    public <X> GridValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new GridValueExtractor<X>(){

            public X extract(Tuple resultset, String name) {
                Binary result = (Binary)resultset.get(name);
                if (result == null) {
                    return null;
                }
                byte[] data = result.getData();
                return javaTypeDescriptor.wrap((Object)data, null);
            }
        };
    }
}

