/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb;

import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoCommandException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.hibernate.AssertionFailure;
import org.hibernate.ogm.datastore.document.association.impl.DocumentHelpers;
import org.hibernate.ogm.datastore.document.impl.DotPatternMapHelpers;
import org.hibernate.ogm.datastore.document.impl.EmbeddableStateFinder;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.spi.AssociationStorageOption;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.AssociationStorageStrategy;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoDBAssociationSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoDBTupleSnapshot;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoHelpers;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.options.AssociationDocumentStorageType;
import org.hibernate.ogm.datastore.mongodb.options.impl.AssociationDocumentStorageOption;
import org.hibernate.ogm.datastore.mongodb.options.impl.ReadConcernOption;
import org.hibernate.ogm.datastore.mongodb.options.impl.ReadPreferenceOption;
import org.hibernate.ogm.datastore.mongodb.options.impl.WriteConcernOption;
import org.hibernate.ogm.datastore.mongodb.query.impl.MongoDBQueryDescriptor;
import org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl.MongoDBQueryDescriptorBuilder;
import org.hibernate.ogm.datastore.mongodb.query.parsing.nativequery.impl.NativeQueryParser;
import org.hibernate.ogm.datastore.mongodb.type.GeoCollection;
import org.hibernate.ogm.datastore.mongodb.type.GeoLineString;
import org.hibernate.ogm.datastore.mongodb.type.GeoMultiLineString;
import org.hibernate.ogm.datastore.mongodb.type.GeoMultiPoint;
import org.hibernate.ogm.datastore.mongodb.type.GeoMultiPolygon;
import org.hibernate.ogm.datastore.mongodb.type.GeoPoint;
import org.hibernate.ogm.datastore.mongodb.type.GeoPolygon;
import org.hibernate.ogm.datastore.mongodb.type.impl.BinaryAsBsonBinaryGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.GeoCollectionGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.GeoLineStringGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.GeoMultiLineStringGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.GeoMultiPointGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.GeoMultiPolygonGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.GeoPointGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.GeoPolygonGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.ObjectIdGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.SerializableAsBinaryGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.StringAsObjectIdGridType;
import org.hibernate.ogm.datastore.mongodb.type.impl.StringAsObjectIdType;
import org.hibernate.ogm.datastore.mongodb.utils.DocumentUtil;
import org.hibernate.ogm.dialect.batch.spi.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.spi.GroupedChangesToEntityOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.Operation;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.batch.spi.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.RemoveTupleOperation;
import org.hibernate.ogm.dialect.identity.spi.IdentityColumnAwareGridDialect;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.optimisticlock.spi.OptimisticLockingAwareGridDialect;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.NoOpParameterMetadataBuilder;
import org.hibernate.ogm.dialect.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.dialect.query.spi.QueryParameters;
import org.hibernate.ogm.dialect.query.spi.QueryableGridDialect;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.dialect.spi.TuplesSupplier;
import org.hibernate.ogm.dialect.storedprocedure.spi.StoredProcedureAwareGridDialect;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.key.spi.AssociationType;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.storedprocedure.ProcedureQueryParameters;
import org.hibernate.ogm.type.impl.ByteStringType;
import org.hibernate.ogm.type.impl.CharacterStringType;
import org.hibernate.ogm.type.impl.LocalDateAsStringType;
import org.hibernate.ogm.type.impl.LocalDateTimeAsStringType;
import org.hibernate.ogm.type.impl.LocalTimeAsStringType;
import org.hibernate.ogm.type.impl.StringCalendarDateType;
import org.hibernate.ogm.type.impl.TimestampAsDateType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.type.MaterializedBlobType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.parboiled.Parboiled;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.RecoveringParseRunner;
import org.parboiled.support.ParsingResult;

public class MongoDBDialect
extends BaseGridDialect
implements QueryableGridDialect<MongoDBQueryDescriptor>,
BatchableGridDialect,
IdentityColumnAwareGridDialect,
MultigetGridDialect,
OptimisticLockingAwareGridDialect,
StoredProcedureAwareGridDialect {
    public static final String ID_FIELDNAME = "_id";
    public static final String PROPERTY_SEPARATOR = ".";
    public static final String ROWS_FIELDNAME = "rows";
    public static final String TABLE_FIELDNAME = "table";
    public static final String ASSOCIATIONS_COLLECTION_PREFIX = "associations_";
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final NativeQueryParser NATIVE_QUERY_PARSER = (NativeQueryParser)Parboiled.createParser(NativeQueryParser.class, (Object[])new Object[0]);
    private static final List<String> ROWS_FIELDNAME_LIST = Collections.singletonList("rows");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+(\\.\\d+)?");
    private static final Pattern PRIMARY_KEY_CONSTRAINT_VIOLATION_MESSAGE = Pattern.compile(".*[. ]\\$?_id_? .*");
    private final MongoDBDatastoreProvider provider;
    private final MongoDatabase currentDB;

    public MongoDBDialect(MongoDBDatastoreProvider provider) {
        this.provider = provider;
        this.currentDB = this.provider.getDatabase();
    }

    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        Document found = this.getObject(key, operationContext);
        return MongoDBDialect.createTuple(key, operationContext, found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        Object[] searchObjects = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            searchObjects[i] = MongoDBDialect.prepareIdObjectValue(keys[i].getColumnNames(), keys[i].getColumnValues());
        }
        try (MongoCursor<Document> cursor = this.getObjects(keys[0].getMetadata(), searchObjects, tupleContext);){
            List<Tuple> list = MongoDBDialect.tuplesResult(keys, searchObjects, tupleContext, cursor);
            return list;
        }
    }

    private static List<Tuple> tuplesResult(EntityKey[] keys, Object[] searchObjects, TupleContext tupleContext, MongoCursor<Document> cursor) {
        Tuple[] tuples = new Tuple[searchObjects.length];
        block0: while (cursor.hasNext()) {
            Document document = (Document)cursor.next();
            for (int i = 0; i < searchObjects.length; ++i) {
                if (!document.get((Object)ID_FIELDNAME).equals(searchObjects[i])) continue;
                tuples[i] = MongoDBDialect.createTuple(keys[i], (OperationContext)tupleContext, document);
                continue block0;
            }
        }
        return Arrays.asList(tuples);
    }

    private static Tuple createTuple(EntityKey key, OperationContext operationContext, Document found) {
        if (found != null) {
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(found, key.getMetadata()), Tuple.SnapshotType.UPDATE);
        }
        if (MongoDBDialect.isInTheInsertionQueue((EntityKey)key, (OperationContext)operationContext)) {
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(MongoDBDialect.prepareIdObject(key), key.getMetadata()), Tuple.SnapshotType.INSERT);
        }
        return null;
    }

    public Tuple createTuple(EntityKeyMetadata entityKeyMetadata, OperationContext operationContext) {
        return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(new Document(), entityKeyMetadata), Tuple.SnapshotType.INSERT);
    }

    public Tuple createTuple(EntityKey key, OperationContext OperationContext2) {
        Document toSave = MongoDBDialect.prepareIdObject(key);
        return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(toSave, key.getMetadata()), Tuple.SnapshotType.INSERT);
    }

    private Document getEmbeddingEntity(AssociationKey key, AssociationContext associationContext) {
        Document embeddingEntityDocument;
        Document document = embeddingEntityDocument = associationContext.getEntityTuplePointer().getTuple() != null ? ((MongoDBTupleSnapshot)associationContext.getEntityTuplePointer().getTuple().getSnapshot()).getDbObject() : null;
        if (embeddingEntityDocument != null) {
            return embeddingEntityDocument;
        }
        MongoCollection<Document> collection = this.getCollection(key.getEntityKey(), associationContext.getAssociationTypeContext().getOptionsContext());
        Document searchObject = MongoDBDialect.prepareIdObject(key.getEntityKey());
        Document projection = MongoDBDialect.getProjection(key, true);
        return (Document)collection.find((Bson)searchObject).projection((Bson)projection).first();
    }

    private Document getObject(EntityKey key, OperationContext operationContext) {
        MongoCollection<Document> collection = this.getCollection(key, operationContext.getTupleTypeContext().getOptionsContext());
        Document searchObject = MongoDBDialect.prepareIdObject(key);
        Document projection = MongoDBDialect.getProjection(operationContext);
        FindIterable fi = collection.find((Bson)searchObject);
        return fi != null ? (Document)fi.projection((Bson)projection).first() : null;
    }

    private MongoCursor<Document> getObjects(EntityKeyMetadata entityKeyMetadata, Object[] searchObjects, TupleContext tupleContext) {
        MongoCollection<Document> collection = this.getCollection(entityKeyMetadata.getTable(), tupleContext.getTupleTypeContext().getOptionsContext());
        Document projection = MongoDBDialect.getProjection((OperationContext)tupleContext);
        Document query = new Document();
        query.put(ID_FIELDNAME, (Object)new Document("$in", Arrays.asList(searchObjects)));
        return collection.find((Bson)query).projection((Bson)projection).iterator();
    }

    private static Document getProjection(OperationContext operationContext) {
        HashSet columns = new HashSet();
        columns.addAll(operationContext.getTupleTypeContext().getPolymorphicEntityColumns());
        columns.addAll(operationContext.getTupleTypeContext().getSelectableColumns());
        return MongoDBDialect.getProjection(new ArrayList<String>(columns));
    }

    private static Document getProjection(List<String> fieldNames) {
        Document projection = new Document();
        for (String column : fieldNames) {
            projection.put(column, (Object)1);
        }
        return projection;
    }

    private static Document prepareIdObject(EntityKey key) {
        return MongoDBDialect.prepareIdObject(key.getColumnNames(), key.getColumnValues());
    }

    private static Document prepareIdObject(IdSourceKey key) {
        return MongoDBDialect.prepareIdObject(key.getColumnName(), key.getColumnValue());
    }

    private static Document prepareIdObject(String columnName, String columnValue) {
        return new Document(ID_FIELDNAME, MongoDBDialect.prepareIdObjectValue(columnName, columnValue));
    }

    private static Document prepareIdObject(String[] columnNames, Object[] columnValues) {
        return new Document(ID_FIELDNAME, MongoDBDialect.prepareIdObjectValue(columnNames, columnValues));
    }

    private static Object prepareIdObjectValue(String columnName, String columnValue) {
        return columnValue;
    }

    private static Object prepareIdObjectValue(String[] columnNames, Object[] columnValues) {
        if (columnNames.length == 1) {
            return columnValues[0];
        }
        Document idObject = new Document();
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            Object columnValue = columnValues[i];
            if (columnName.contains(PROPERTY_SEPARATOR)) {
                int dotIndex = columnName.indexOf(PROPERTY_SEPARATOR);
                String shortColumnName = columnName.substring(dotIndex + 1);
                idObject.put(shortColumnName, columnValue);
                continue;
            }
            idObject.put(columnNames[i], columnValue);
        }
        return idObject;
    }

    private MongoCollection<Document> getCollection(String table, OptionsContext context) {
        MongoCollection collection = this.currentDB.getCollection(table);
        if (context != null) {
            return this.withOptions((MongoCollection<Document>)collection, context);
        }
        return collection;
    }

    private MongoCollection<Document> getCollection(EntityKey key) {
        return this.getCollection(key.getTable(), null);
    }

    private MongoCollection<Document> getCollection(EntityKey key, OptionsContext context) {
        return this.getCollection(key.getTable(), context);
    }

    private MongoCollection<Document> withOptions(MongoCollection<Document> collection, OptionsContext context) {
        MongoCollection<Document> newCollection = collection;
        newCollection = this.withReadPreference(context, newCollection);
        newCollection = this.withReadConcern(context, newCollection);
        newCollection = this.withWriteConcern(context, newCollection);
        return newCollection;
    }

    private MongoCollection<Document> withReadConcern(OptionsContext context, MongoCollection<Document> newCollection) {
        ReadConcern readConcern = (ReadConcern)context.getUnique(ReadConcernOption.class);
        if (readConcern != null) {
            newCollection = newCollection.withReadConcern(readConcern);
        }
        return newCollection;
    }

    private MongoCollection<Document> withReadPreference(OptionsContext context, MongoCollection<Document> newCollection) {
        ReadPreference readPreference = (ReadPreference)context.getUnique(ReadPreferenceOption.class);
        if (readPreference != null) {
            return newCollection.withReadPreference(readPreference);
        }
        return newCollection;
    }

    private MongoCollection<Document> withWriteConcern(OptionsContext context, MongoCollection<Document> newCollection) {
        WriteConcern writeConcern = (WriteConcern)context.getUnique(WriteConcernOption.class);
        if (writeConcern != null) {
            return newCollection.withWriteConcern(writeConcern);
        }
        return newCollection;
    }

    private MongoCollection<Document> getAssociationCollection(AssociationKey key, AssociationStorageStrategy storageStrategy, AssociationContext associationContext) {
        if (storageStrategy == AssociationStorageStrategy.GLOBAL_COLLECTION) {
            return this.getCollection("Associations", associationContext.getAssociationTypeContext().getOptionsContext());
        }
        return this.getCollection(ASSOCIATIONS_COLLECTION_PREFIX + key.getTable(), associationContext.getAssociationTypeContext().getOptionsContext());
    }

    private static Document getSubQuery(String operator, Document query) {
        return query.get((Object)operator) != null ? (Document)query.get((Object)operator) : new Document();
    }

    private static void addSubQuery(String operator, Document query, String column, Object value) {
        Document subQuery = MongoDBDialect.getSubQuery(operator, query);
        query.append(operator, (Object)subQuery.append(column, value));
    }

    private static void addSetToQuery(Document query, String column, Object value) {
        MongoDBDialect.removeSubQuery("$unset", query, column);
        MongoDBDialect.addSubQuery("$set", query, column, value);
    }

    private static void addUnsetToQuery(Document query, String column) {
        MongoDBDialect.removeSubQuery("$set", query, column);
        MongoDBDialect.addSubQuery("$unset", query, column, 1);
    }

    private static void removeSubQuery(String operator, Document query, String column) {
        Document subQuery = MongoDBDialect.getSubQuery(operator, query);
        subQuery.remove((Object)column);
        if (subQuery.isEmpty()) {
            query.remove((Object)operator);
        }
    }

    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) {
        throw new UnsupportedOperationException("Method not supported in GridDialect anymore");
    }

    public boolean updateTupleWithOptimisticLock(EntityKey entityKey, Tuple oldLockState, Tuple tuple, TupleContext tupleContext) {
        Document idObject = MongoDBDialect.prepareIdObject(entityKey);
        for (String versionColumn : oldLockState.getColumnNames()) {
            idObject.put(versionColumn, oldLockState.get(versionColumn));
        }
        Document updater = MongoDBDialect.objectForUpdate(tuple, tupleContext);
        if (updater.isEmpty()) {
            return false;
        }
        Document doc = (Document)this.getCollection(entityKey).findOneAndUpdate((Bson)idObject, (Bson)updater);
        return doc != null;
    }

    public void insertTuple(EntityKeyMetadata entityKeyMetadata, Tuple tuple, TupleContext tupleContext) {
        Document objectWithId = this.insertDocument(entityKeyMetadata, tuple, tupleContext);
        String idColumnName = entityKeyMetadata.getColumnNames()[0];
        tuple.put(idColumnName, objectWithId.get((Object)ID_FIELDNAME));
    }

    private Document insertDocument(EntityKeyMetadata entityKeyMetadata, Tuple tuple, TupleContext tupleContext) {
        Document dbObject = MongoDBDialect.objectForInsert(tuple, ((MongoDBTupleSnapshot)tuple.getSnapshot()).getDbObject());
        this.getCollection(entityKeyMetadata.getTable(), tupleContext.getTupleTypeContext().getOptionsContext()).insertOne((Object)dbObject);
        return dbObject;
    }

    private static Document objectForInsert(Tuple tuple, Document dbObject) {
        MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tuple.getSnapshot();
        for (TupleOperation operation : tuple.getOperations()) {
            String column = operation.getColumn();
            if (!MongoDBDialect.notInIdField(snapshot, column)) continue;
            switch (operation.getType()) {
                case PUT: {
                    MongoHelpers.setValue(dbObject, column, operation.getValue());
                    break;
                }
                case PUT_NULL: 
                case REMOVE: {
                    MongoHelpers.resetValue(dbObject, column);
                }
            }
        }
        return dbObject;
    }

    private static Document objectForUpdate(Tuple tuple, TupleContext tupleContext) {
        return MongoDBDialect.objectForUpdate(tuple, tupleContext, new Document());
    }

    private static Document objectForUpdate(Tuple tuple, TupleContext tupleContext, Document updateStatement) {
        MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tuple.getSnapshot();
        EmbeddableStateFinder embeddableStateFinder = new EmbeddableStateFinder(tuple, tupleContext);
        HashSet<String> nullEmbeddables = new HashSet<String>();
        for (TupleOperation operation : tuple.getOperations()) {
            String column = operation.getColumn();
            if (!MongoDBDialect.notInIdField(snapshot, column)) continue;
            switch (operation.getType()) {
                case PUT: {
                    MongoDBDialect.addSetToQuery(updateStatement, column, operation.getValue());
                    break;
                }
                case PUT_NULL: 
                case REMOVE: {
                    String nullEmbeddable = embeddableStateFinder.getOuterMostNullEmbeddableIfAny(column);
                    if (nullEmbeddable != null) {
                        if (nullEmbeddables.contains(nullEmbeddable)) break;
                        MongoDBDialect.addUnsetToQuery(updateStatement, nullEmbeddable);
                        nullEmbeddables.add(nullEmbeddable);
                        break;
                    }
                    MongoDBDialect.addUnsetToQuery(updateStatement, column);
                }
            }
        }
        return updateStatement;
    }

    private static boolean notInIdField(MongoDBTupleSnapshot snapshot, String column) {
        return !column.equals(ID_FIELDNAME) && !column.endsWith("._id") && !snapshot.isKeyColumn(column);
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        Document toDelete = MongoDBDialect.prepareIdObject(key);
        MongoCollection<Document> collection = this.getCollection(key, MongoDBDialect.getOptionsContext(tupleContext));
        collection.deleteMany((Bson)toDelete);
    }

    public boolean removeTupleWithOptimisticLock(EntityKey entityKey, Tuple oldLockState, TupleContext tupleContext) {
        Document toDelete = MongoDBDialect.prepareIdObject(entityKey);
        for (String versionColumn : oldLockState.getColumnNames()) {
            toDelete.put(versionColumn, oldLockState.get(versionColumn));
        }
        MongoCollection<Document> collection = this.getCollection(entityKey);
        Document deleted = (Document)collection.findOneAndDelete((Bson)toDelete);
        return deleted != null;
    }

    private Document findAssociation(AssociationKey key, AssociationContext associationContext, AssociationStorageStrategy storageStrategy) {
        Document associationKeyObject = MongoDBDialect.associationKeyToObject(key, storageStrategy);
        MongoCollection<Document> associationCollection = this.getAssociationCollection(key, storageStrategy, associationContext);
        FindIterable fi = associationCollection.find((Bson)associationKeyObject);
        return fi != null ? (Document)fi.projection((Bson)MongoDBDialect.getProjection(key, false)).first() : null;
    }

    private static Document getProjection(AssociationKey key, boolean embedded) {
        if (embedded) {
            return MongoDBDialect.getProjection(Collections.singletonList(key.getMetadata().getCollectionRole()));
        }
        return MongoDBDialect.getProjection(ROWS_FIELDNAME_LIST);
    }

    private static boolean isInTheInsertionQueue(EntityKey key, AssociationContext associationContext) {
        OperationsQueue queue = associationContext.getOperationsQueue();
        return queue != null && queue.isInTheInsertionQueue(key);
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = MongoDBDialect.getAssociationStorageStrategy(key, associationContext);
        if (MongoDBDialect.isEmbeddedAssociation(key) && MongoDBDialect.isInTheInsertionQueue(key.getEntityKey(), associationContext)) {
            Document idObject = MongoDBDialect.prepareIdObject(key.getEntityKey());
            return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(idObject, key, storageStrategy));
        }
        this.executeBatch(associationContext.getOperationsQueue());
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            Document entity = this.getEmbeddingEntity(key, associationContext);
            if (entity != null && MongoHelpers.hasField(entity, key.getMetadata().getCollectionRole())) {
                return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(entity, key, storageStrategy));
            }
            return null;
        }
        Document result = this.findAssociation(key, associationContext, storageStrategy);
        if (result == null) {
            return null;
        }
        return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(result, key, storageStrategy));
    }

    private static boolean isEmbeddedAssociation(AssociationKey key) {
        return AssociationKind.EMBEDDED_COLLECTION == key.getMetadata().getAssociationKind();
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationStorageStrategy storageStrategy = MongoDBDialect.getAssociationStorageStrategy(key, associationContext);
        Document document = storageStrategy == AssociationStorageStrategy.IN_ENTITY ? this.getEmbeddingEntity(key, associationContext) : MongoDBDialect.associationKeyToObject(key, storageStrategy);
        Association association = new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(document, key, storageStrategy));
        if (!association.isEmpty()) {
            association.clear();
        }
        return association;
    }

    private static Object getAssociationRows(Association association, AssociationKey key, AssociationContext associationContext) {
        boolean organizeByRowKey = DotPatternMapHelpers.organizeAssociationMapByRowKey((Association)association, (AssociationKey)key, (AssociationContext)associationContext);
        if (organizeByRowKey) {
            String rowKeyColumn = organizeByRowKey ? key.getMetadata().getRowKeyIndexColumnNames()[0] : null;
            Document rows = new Document();
            for (RowKey rowKey : association.getKeys()) {
                Document row = (Document)MongoDBDialect.getAssociationRow(association.get(rowKey), key);
                String rowKeyValue = (String)row.remove((Object)rowKeyColumn);
                if (row.keySet().size() == 1) {
                    rows.put(rowKeyValue, DocumentUtil.toMap(row).values().iterator().next());
                    continue;
                }
                rows.put(rowKeyValue, (Object)row);
            }
            return rows;
        }
        ArrayList<Object> rows = new ArrayList<Object>();
        for (RowKey rowKey : association.getKeys()) {
            rows.add(MongoDBDialect.getAssociationRow(association.get(rowKey), key));
        }
        return rows;
    }

    private static Object getAssociationRow(Tuple row, AssociationKey associationKey) {
        String[] rowKeyColumnsToPersist = associationKey.getMetadata().getColumnsWithoutKeyColumns((Iterable)row.getColumnNames());
        if (rowKeyColumnsToPersist.length == 1) {
            return row.get(rowKeyColumnsToPersist[0]);
        }
        String prefix = DotPatternMapHelpers.getColumnSharedPrefixOfAssociatedEntityLink((AssociationKey)associationKey);
        Document rowObject = new Document();
        for (String column : rowKeyColumnsToPersist) {
            Object value = row.get(column);
            if (value == null) continue;
            String columnName = column.startsWith(prefix) ? column.substring(prefix.length()) : column;
            MongoHelpers.setValue(rowObject, columnName, value);
        }
        return rowObject;
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        throw new UnsupportedOperationException("Method not supported in GridDialect anymore");
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        throw new UnsupportedOperationException("Method not supported in GridDialect anymore");
    }

    public Number nextValue(NextValueRequest request) {
        String valueColumnName = request.getKey().getMetadata().getValueColumnName();
        MongoCollection<Document> sequenceCollection = this.getCollection(request.getKey().getTable(), null);
        Document sequenceId = MongoDBDialect.prepareIdObject(request.getKey());
        Document setInitialValueOnInsert = new Document();
        MongoDBDialect.addSubQuery("$setOnInsert", setInitialValueOnInsert, valueColumnName, request.getInitialValue() + request.getIncrement());
        FindOneAndUpdateOptions enableUpsert = new FindOneAndUpdateOptions().upsert(true);
        Document originalDocument = (Document)sequenceCollection.findOneAndUpdate((Bson)sequenceId, (Bson)setInitialValueOnInsert, enableUpsert);
        Object nextValue = null;
        if (originalDocument == null) {
            return request.getInitialValue();
        }
        Document incrementUpdate = new Document();
        MongoDBDialect.addSubQuery("$inc", incrementUpdate, valueColumnName, request.getIncrement());
        Document beforeUpdateDoc = (Document)sequenceCollection.findOneAndUpdate((Bson)sequenceId, (Bson)incrementUpdate, new FindOneAndUpdateOptions().upsert(true));
        nextValue = beforeUpdateDoc.get((Object)valueColumnName);
        return (Number)nextValue;
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return MongoDBDialect.getAssociationStorageStrategy(associationKeyMetadata, associationTypeContext) == AssociationStorageStrategy.IN_ENTITY;
    }

    public GridType overrideType(Type type) {
        if (type == StandardBasicTypes.CALENDAR || type == StandardBasicTypes.CALENDAR_DATE) {
            return StringCalendarDateType.INSTANCE;
        }
        if (type == StandardBasicTypes.TIMESTAMP) {
            return TimestampAsDateType.INSTANCE;
        }
        if (type == StandardBasicTypes.BINARY) {
            return BinaryAsBsonBinaryGridType.INSTANCE;
        }
        if (type == StandardBasicTypes.BYTE) {
            return ByteStringType.INSTANCE;
        }
        if (type == StandardBasicTypes.CHARACTER) {
            return CharacterStringType.INSTANCE;
        }
        if (type.getReturnedClass() == ObjectId.class) {
            return ObjectIdGridType.INSTANCE;
        }
        if (type instanceof StringAsObjectIdType) {
            return StringAsObjectIdGridType.INSTANCE;
        }
        if (type instanceof SerializableToBlobType) {
            SerializableToBlobType exposedType = (SerializableToBlobType)type;
            return new SerializableAsBinaryGridType(exposedType.getJavaTypeDescriptor());
        }
        if (type instanceof MaterializedBlobType) {
            MaterializedBlobType exposedType = (MaterializedBlobType)type;
            return new SerializableAsBinaryGridType(exposedType.getJavaTypeDescriptor());
        }
        if (type.getReturnedClass() == GeoPoint.class) {
            return GeoPointGridType.INSTANCE;
        }
        if (type.getReturnedClass() == GeoMultiPoint.class) {
            return GeoMultiPointGridType.INSTANCE;
        }
        if (type.getReturnedClass() == GeoLineString.class) {
            return GeoLineStringGridType.INSTANCE;
        }
        if (type.getReturnedClass() == GeoMultiLineString.class) {
            return GeoMultiLineStringGridType.INSTANCE;
        }
        if (type.getReturnedClass() == GeoPolygon.class) {
            return GeoPolygonGridType.INSTANCE;
        }
        if (type.getReturnedClass() == GeoMultiPolygon.class) {
            return GeoMultiPolygonGridType.INSTANCE;
        }
        if (type.getReturnedClass() == GeoCollection.class) {
            return GeoCollectionGridType.INSTANCE;
        }
        if (type.getReturnedClass().equals(LocalDate.class)) {
            return LocalDateAsStringType.INSTANCE;
        }
        if (type.getReturnedClass().equals(LocalDateTime.class)) {
            return LocalDateTimeAsStringType.INSTANCE;
        }
        if (type.getReturnedClass().equals(LocalTime.class)) {
            return LocalTimeAsStringType.INSTANCE;
        }
        return null;
    }

    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        MongoCollection<Document> collection = this.getCollection(entityKeyMetadata.getTable(), tupleTypeContext.getOptionsContext());
        consumer.consume((TuplesSupplier)new MongoDBTuplesSupplier(collection, entityKeyMetadata));
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<MongoDBQueryDescriptor> backendQuery, QueryParameters queryParameters, TupleContext tupleContext) {
        EntityKeyMetadata entityKeyMetadata;
        MongoDBQueryDescriptor queryDescriptor = (MongoDBQueryDescriptor)backendQuery.getQuery();
        EntityKeyMetadata entityKeyMetadata2 = entityKeyMetadata = backendQuery.getSingleEntityMetadataInformationOrNull() == null ? null : backendQuery.getSingleEntityMetadataInformationOrNull().getEntityKeyMetadata();
        if (entityKeyMetadata != null && queryDescriptor.getProjection() != null) {
            throw log.addEntityNotAllowedInNativeQueriesUsingProjection(entityKeyMetadata.getTable(), backendQuery.toString());
        }
        String collectionName = MongoDBDialect.getCollectionName(backendQuery, queryDescriptor, entityKeyMetadata);
        OptionsContext typeContext = entityKeyMetadata == null ? null : MongoDBDialect.getOptionsContext(tupleContext);
        MongoCollection<Document> collection = this.getCollection(collectionName, typeContext);
        if (!queryParameters.getPositionalParameters().isEmpty()) {
            throw new UnsupportedOperationException("Positional parameters are not yet supported for MongoDB native queries.");
        }
        switch (queryDescriptor.getOperation()) {
            case FIND: {
                return MongoDBDialect.doFind(queryDescriptor, queryParameters, collection, entityKeyMetadata);
            }
            case FINDONE: {
                return MongoDBDialect.doFindOne(queryDescriptor, collection, entityKeyMetadata);
            }
            case FINDANDMODIFY: {
                return MongoDBDialect.doFindAndModify(queryDescriptor, collection, entityKeyMetadata);
            }
            case AGGREGATE: {
                return MongoDBDialect.doAggregate(queryDescriptor, queryParameters, collection, entityKeyMetadata);
            }
            case AGGREGATE_PIPELINE: {
                return MongoDBDialect.doAggregatePipeline(queryDescriptor, queryParameters, collection, entityKeyMetadata);
            }
            case COUNT: {
                return MongoDBDialect.doCount(queryDescriptor, collection);
            }
            case DISTINCT: {
                return MongoDBDialect.doDistinct(queryDescriptor, collection);
            }
            case MAP_REDUCE: {
                return MongoDBDialect.doMapReduce(queryDescriptor, collection);
            }
            case INSERT: 
            case INSERTONE: 
            case INSERTMANY: 
            case REMOVE: 
            case DELETEMANY: 
            case DELETEONE: 
            case UPDATE: 
            case UPDATEONE: 
            case UPDATEMANY: 
            case REPLACEONE: {
                throw log.updateQueryMustBeExecutedViaExecuteUpdate(queryDescriptor);
            }
        }
        throw new IllegalArgumentException("Unexpected query operation: " + queryDescriptor);
    }

    public int executeBackendUpdateQuery(BackendQuery<MongoDBQueryDescriptor> backendQuery, QueryParameters queryParameters, TupleContext tupleContext) {
        MongoDBQueryDescriptor queryDescriptor = (MongoDBQueryDescriptor)backendQuery.getQuery();
        EntityKeyMetadata entityKeyMetadata = backendQuery.getSingleEntityMetadataInformationOrNull() == null ? null : backendQuery.getSingleEntityMetadataInformationOrNull().getEntityKeyMetadata();
        String collectionName = MongoDBDialect.getCollectionName(backendQuery, queryDescriptor, entityKeyMetadata);
        MongoCollection collection = this.provider.getDatabase().getCollection(collectionName);
        if (!queryParameters.getPositionalParameters().isEmpty()) {
            throw new UnsupportedOperationException("Positional parameters are not yet supported for MongoDB native queries.");
        }
        switch (queryDescriptor.getOperation()) {
            case INSERT: 
            case INSERTONE: 
            case INSERTMANY: {
                return MongoDBDialect.doInsert(queryDescriptor, (MongoCollection<Document>)collection);
            }
            case REPLACEONE: {
                return MongoDBDialect.doReplaceOne(queryDescriptor, (MongoCollection<Document>)collection);
            }
            case REMOVE: 
            case DELETEMANY: 
            case DELETEONE: {
                return MongoDBDialect.doRemove(queryDescriptor, (MongoCollection<Document>)collection, queryDescriptor.getOperation());
            }
            case UPDATE: 
            case UPDATEONE: 
            case UPDATEMANY: {
                return MongoDBDialect.doUpdate(queryDescriptor, (MongoCollection<Document>)collection, queryDescriptor.getOperation());
            }
            case DROP: {
                return MongoDBDialect.doDrop((MongoCollection<Document>)collection);
            }
            case FIND: 
            case FINDONE: 
            case FINDANDMODIFY: 
            case AGGREGATE: 
            case AGGREGATE_PIPELINE: 
            case COUNT: 
            case DISTINCT: {
                throw log.readQueryMustBeExecutedViaGetResultList(queryDescriptor);
            }
        }
        throw new IllegalArgumentException("Unexpected query operation: " + queryDescriptor);
    }

    public MongoDBQueryDescriptor parseNativeQuery(String nativeQuery) {
        ParsingResult parseResult = new RecoveringParseRunner(NATIVE_QUERY_PARSER.Query()).run(nativeQuery);
        if (parseResult.hasErrors()) {
            throw new IllegalArgumentException("Unsupported native query: " + ErrorUtils.printParseErrors((List)parseResult.parseErrors));
        }
        return ((MongoDBQueryDescriptorBuilder)parseResult.resultValue).build();
    }

    public DuplicateInsertPreventionStrategy getDuplicateInsertPreventionStrategy(EntityKeyMetadata entityKeyMetadata) {
        return DuplicateInsertPreventionStrategy.NATIVE;
    }

    private static ClosableIterator<Tuple> doAggregate(MongoDBQueryDescriptor query, QueryParameters queryParameters, MongoCollection<Document> collection, EntityKeyMetadata entityKeyMetadata) {
        ArrayList<Document> pipeline = new ArrayList<Document>();
        pipeline.add(MongoDBDialect.stage("$match", query.getCriteria()));
        pipeline.add(MongoDBDialect.stage("$project", query.getProjection()));
        if (query.getUnwinds() != null && !query.getUnwinds().isEmpty()) {
            for (String field : query.getUnwinds()) {
                pipeline.add(MongoDBDialect.stage("$unwind", "$" + field));
            }
        }
        if (query.getOrderBy() != null) {
            pipeline.add(MongoDBDialect.stage("$sort", query.getOrderBy()));
        }
        MongoDBDialect.applyFirstResult(queryParameters, pipeline);
        MongoDBDialect.applyMaxResults(queryParameters, pipeline);
        AggregateIterable output = collection.aggregate(pipeline);
        return new MongoDBAggregationOutput((AggregateIterable<Document>)output, entityKeyMetadata);
    }

    private static final OptionsContext getOptionsContext(TupleContext tupleContext) {
        return tupleContext.getTupleTypeContext().getOptionsContext();
    }

    private static void applyMaxResults(QueryParameters queryParameters, List<Document> pipeline) {
        if (queryParameters.getRowSelection().getMaxRows() != null) {
            pipeline.add(MongoDBDialect.stage("$limit", queryParameters.getRowSelection().getMaxRows()));
        }
    }

    private static void applyFirstResult(QueryParameters queryParameters, List<Document> pipeline) {
        if (queryParameters.getRowSelection().getFirstRow() != null) {
            pipeline.add(MongoDBDialect.stage("$skip", queryParameters.getRowSelection().getFirstRow()));
        }
    }

    private static ClosableIterator<Tuple> doAggregatePipeline(MongoDBQueryDescriptor query, QueryParameters queryParameters, MongoCollection<Document> collection, EntityKeyMetadata entityKeyMetadata) {
        ArrayList<Document> pipeline = new ArrayList<Document>(query.getPipeline());
        MongoDBDialect.applyFirstResult(queryParameters, pipeline);
        MongoDBDialect.applyMaxResults(queryParameters, pipeline);
        AggregateIterable output = collection.aggregate(pipeline);
        return new MongoDBAggregationOutput((AggregateIterable<Document>)output, entityKeyMetadata);
    }

    private static Document stage(String key, Object value) {
        Document stage = new Document();
        stage.put(key, value);
        return stage;
    }

    private static ClosableIterator<Tuple> doDistinct(MongoDBQueryDescriptor queryDescriptor, MongoCollection<Document> collection) {
        DistinctIterable distinctFieldValues = collection.distinct(queryDescriptor.getDistinctFieldName(), (Bson)queryDescriptor.getCriteria(), String.class);
        Collation collation = MongoDBDialect.getCollation(queryDescriptor.getOptions());
        distinctFieldValues = collation != null ? distinctFieldValues.collation(collation) : distinctFieldValues;
        MongoCursor cursor = distinctFieldValues.iterator();
        ArrayList<Object> documents = new ArrayList<Object>();
        while (cursor.hasNext()) {
            documents.add(cursor.next());
        }
        MapTupleSnapshot snapshot = new MapTupleSnapshot(Collections.singletonMap("n", documents));
        return CollectionHelper.newClosableIterator(Collections.singletonList(new Tuple((TupleSnapshot)snapshot, Tuple.SnapshotType.UNKNOWN)));
    }

    private static ClosableIterator<Tuple> doMapReduce(MongoDBQueryDescriptor queryDescriptor, MongoCollection<Document> collection) {
        MapReduceIterable mapReduceIterable = collection.mapReduce(queryDescriptor.getMapFunction(), queryDescriptor.getReduceFunction());
        Document options = queryDescriptor.getOptions();
        if (options != null) {
            Document query = (Document)options.get((Object)"query");
            Document sort = (Document)options.get((Object)"sort");
            Integer limit = options.getInteger((Object)"limit");
            String finalizeFunction = options.getString((Object)"finalize");
            Document scope = (Document)options.get((Object)"scope");
            Boolean jsMode = options.getBoolean((Object)"jsMode");
            Boolean verbose = options.getBoolean((Object)"verbose");
            Boolean bypassDocumentValidation = options.getBoolean((Object)"bypassDocumentValidation");
            Collation collation = MongoDBDialect.getCollation((Document)options.get((Object)"collation"));
            MapReduceAction mapReduceAction = null;
            String collectionName = null;
            String dbName = null;
            Boolean sharded = null;
            Boolean nonAtomic = null;
            Object out = options.get((Object)"out");
            if (out != null) {
                if (out instanceof String) {
                    collectionName = (String)out;
                } else if (out instanceof Document) {
                    Document outDocument = (Document)out;
                    if (outDocument.containsKey((Object)"merge")) {
                        mapReduceAction = MapReduceAction.MERGE;
                        collectionName = outDocument.getString((Object)"merge");
                    } else if (outDocument.containsKey((Object)"replace")) {
                        mapReduceAction = MapReduceAction.REPLACE;
                        collectionName = outDocument.getString((Object)"replace");
                    } else if (((Document)out).containsKey((Object)"reduce")) {
                        mapReduceAction = MapReduceAction.REDUCE;
                        collectionName = outDocument.getString((Object)"reduce");
                    }
                    dbName = outDocument.getString((Object)"db");
                    sharded = outDocument.getBoolean((Object)"sharded");
                    nonAtomic = outDocument.getBoolean((Object)"nonAtomic");
                }
            }
            mapReduceIterable = query != null ? mapReduceIterable.filter((Bson)query) : mapReduceIterable;
            mapReduceIterable = sort != null ? mapReduceIterable.sort((Bson)sort) : mapReduceIterable;
            mapReduceIterable = limit != null ? mapReduceIterable.limit(limit.intValue()) : mapReduceIterable;
            mapReduceIterable = finalizeFunction != null ? mapReduceIterable.finalizeFunction(finalizeFunction) : mapReduceIterable;
            mapReduceIterable = scope != null ? mapReduceIterable.scope((Bson)scope) : mapReduceIterable;
            mapReduceIterable = jsMode != null ? mapReduceIterable.jsMode(jsMode.booleanValue()) : mapReduceIterable;
            mapReduceIterable = verbose != null ? mapReduceIterable.verbose(verbose.booleanValue()) : mapReduceIterable;
            mapReduceIterable = bypassDocumentValidation != null ? mapReduceIterable.bypassDocumentValidation(bypassDocumentValidation) : mapReduceIterable;
            mapReduceIterable = collation != null ? mapReduceIterable.collation(collation) : mapReduceIterable;
            mapReduceIterable = mapReduceAction != null ? mapReduceIterable.action(mapReduceAction) : mapReduceIterable;
            mapReduceIterable = collectionName != null ? mapReduceIterable.collectionName(collectionName) : mapReduceIterable;
            mapReduceIterable = dbName != null ? mapReduceIterable.databaseName(dbName) : mapReduceIterable;
            mapReduceIterable = sharded != null ? mapReduceIterable.sharded(sharded.booleanValue()) : mapReduceIterable;
            mapReduceIterable = nonAtomic != null ? mapReduceIterable.nonAtomic(nonAtomic.booleanValue()) : mapReduceIterable;
        }
        MongoCursor cursor = mapReduceIterable.iterator();
        LinkedHashMap<Object, Object> documents = new LinkedHashMap<Object, Object>();
        while (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            documents.put(doc.get((Object)ID_FIELDNAME), doc.get((Object)"value"));
        }
        MapTupleSnapshot snapshot = new MapTupleSnapshot(Collections.singletonMap("n", documents));
        return CollectionHelper.newClosableIterator(Collections.singletonList(new Tuple((TupleSnapshot)snapshot, Tuple.SnapshotType.UNKNOWN)));
    }

    private static Collation getCollation(Document dbObject) {
        Collation collation = null;
        if (dbObject != null) {
            String caseFirst = dbObject.getString((Object)"caseFirst");
            Integer strength = dbObject.getInteger((Object)"strength");
            String alternate = dbObject.getString((Object)"alternate");
            String maxVariable = dbObject.getString((Object)"maxVariable");
            collation = Collation.builder().locale((String)dbObject.get((Object)"locale")).caseLevel((Boolean)dbObject.get((Object)"caseLevel")).numericOrdering((Boolean)dbObject.get((Object)"numericOrdering")).backwards((Boolean)dbObject.get((Object)"backwards")).collationCaseFirst(caseFirst == null ? null : CollationCaseFirst.fromString((String)caseFirst)).collationStrength(strength == null ? null : CollationStrength.fromInt((int)strength)).collationAlternate(alternate == null ? null : CollationAlternate.fromString((String)alternate)).collationMaxVariable(maxVariable == null ? null : CollationMaxVariable.fromString((String)maxVariable)).build();
        }
        return collation;
    }

    private static ClosableIterator<Tuple> doFind(MongoDBQueryDescriptor query, QueryParameters queryParameters, MongoCollection<Document> collection, EntityKeyMetadata entityKeyMetadata) {
        Document criteria = query.getCriteria();
        Document orderby = query.getOrderBy();
        int maxTimeMS = -1;
        Document modifiers = new Document();
        if (criteria.containsKey((Object)"$query")) {
            if (orderby == null) {
                orderby = (Document)criteria.get((Object)"$orderby");
            }
            maxTimeMS = criteria.getInteger((Object)"$maxTimeMS", -1);
            MongoDBDialect.addModifier(modifiers, criteria, "$hint");
            MongoDBDialect.addModifier(modifiers, criteria, "$maxScan");
            MongoDBDialect.addModifier(modifiers, criteria, "$snapshot", false);
            MongoDBDialect.addModifier(modifiers, criteria, "$min");
            MongoDBDialect.addModifier(modifiers, criteria, "$max");
            MongoDBDialect.addModifier(modifiers, criteria, "$comment");
            MongoDBDialect.addModifier(modifiers, criteria, "$explain", false);
            criteria = (Document)criteria.get((Object)"$query");
        }
        FindIterable prepareFind = collection.find((Bson)criteria).modifiers((Bson)modifiers).projection((Bson)query.getProjection());
        if (orderby != null) {
            prepareFind.sort((Bson)orderby);
        }
        if (maxTimeMS > 0) {
            prepareFind.maxTime((long)maxTimeMS, TimeUnit.MILLISECONDS);
        }
        if (queryParameters.getRowSelection().getFirstRow() != null) {
            prepareFind.skip(queryParameters.getRowSelection().getFirstRow().intValue());
        }
        if (queryParameters.getRowSelection().getMaxRows() != null) {
            prepareFind.limit(queryParameters.getRowSelection().getMaxRows().intValue());
        }
        MongoCursor iterator = prepareFind.iterator();
        return new MongoDBResultsCursor((MongoCursor<Document>)iterator, entityKeyMetadata);
    }

    private static void addModifier(Document modifiers, Document criteria, String key) {
        Object value = criteria.get((Object)key);
        if (value != null) {
            modifiers.append(key, value);
        }
    }

    private static <T> void addModifier(Document modifiers, Document criteria, String key, T defaultValue) {
        Object value = criteria.get((Object)key);
        if (value == null) {
            value = defaultValue;
        }
        modifiers.append(key, value);
    }

    private static ClosableIterator<Tuple> doFindOne(MongoDBQueryDescriptor query, MongoCollection<Document> collection, EntityKeyMetadata entityKeyMetadata) {
        Document theOne = (Document)collection.find((Bson)query.getCriteria()).projection((Bson)query.getProjection()).first();
        return new SingleTupleIterator(theOne, collection, entityKeyMetadata);
    }

    private static ClosableIterator<Tuple> doFindAndModify(MongoDBQueryDescriptor queryDesc, MongoCollection<Document> collection, EntityKeyMetadata entityKeyMetadata) {
        Document query = (Document)queryDesc.getCriteria().get((Object)"query");
        Document fields = (Document)queryDesc.getCriteria().get((Object)"fields");
        Document sort = (Document)queryDesc.getCriteria().get((Object)"sort");
        Boolean remove = (Boolean)queryDesc.getCriteria().get((Object)"remove");
        Document update = (Document)queryDesc.getCriteria().get((Object)"update");
        Boolean returnNewDocument = (Boolean)queryDesc.getCriteria().get((Object)"new");
        Boolean upsert = (Boolean)queryDesc.getCriteria().get((Object)"upsert");
        Boolean bypass = (Boolean)queryDesc.getCriteria().get((Object)"bypassDocumentValidation");
        Document o = (Document)queryDesc.getCriteria().get((Object)"writeConcern");
        WriteConcern wc = MongoDBDialect.getWriteConcern(o);
        Document theOne = null;
        if (remove != null && remove.booleanValue()) {
            theOne = (Document)collection.findOneAndDelete((Bson)query, new FindOneAndDeleteOptions().sort((Bson)sort).projection((Bson)fields).maxTime(0L, TimeUnit.MILLISECONDS));
        } else {
            FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().sort((Bson)sort).bypassDocumentValidation(Boolean.valueOf(bypass != null ? bypass : false)).upsert(upsert != null ? upsert : false).projection((Bson)fields).returnDocument(returnNewDocument != null && returnNewDocument != false ? ReturnDocument.AFTER : ReturnDocument.BEFORE).maxTime(0L, TimeUnit.MILLISECONDS);
            theOne = (Document)collection.withWriteConcern(wc != null ? wc : collection.getWriteConcern()).findOneAndUpdate((Bson)query, (Bson)update, options);
        }
        return new SingleTupleIterator(theOne, collection, entityKeyMetadata);
    }

    private static int doInsert(MongoDBQueryDescriptor queryDesc, MongoCollection<Document> collection) {
        Document options = queryDesc.getOptions();
        Boolean ordered = Boolean.FALSE;
        WriteConcern wc = null;
        if (options != null) {
            ordered = (Boolean)options.get((Object)"ordered");
            ordered = ordered != null ? ordered : Boolean.FALSE;
            Document o = (Document)options.get((Object)"writeConcern");
            wc = MongoDBDialect.getWriteConcern(o);
        }
        ArrayList<InsertOneModel> operationList = null;
        if (queryDesc.getUpdateOrInsertMany() != null) {
            operationList = new ArrayList(queryDesc.getUpdateOrInsertMany().size());
            for (Document doc : queryDesc.getUpdateOrInsertMany()) {
                operationList.add(new InsertOneModel((Object)doc));
            }
        } else {
            operationList = new ArrayList<InsertOneModel>(1);
            operationList.add(new InsertOneModel((Object)queryDesc.getUpdateOrInsertOne()));
        }
        BulkWriteResult result = collection.withWriteConcern(wc != null ? wc : collection.getWriteConcern()).bulkWrite(operationList, new BulkWriteOptions().ordered(ordered.booleanValue()));
        if (result.wasAcknowledged()) {
            return result.getInsertedCount();
        }
        return -1;
    }

    private static int doRemove(MongoDBQueryDescriptor queryDesc, MongoCollection<Document> collection, MongoDBQueryDescriptor.Operation operation) {
        Document query = queryDesc.getCriteria();
        Document options = queryDesc.getOptions();
        Boolean justOne = Boolean.FALSE;
        WriteConcern wc = null;
        if (options != null) {
            justOne = (Boolean)options.get((Object)"justOne");
            justOne = justOne != null ? justOne : Boolean.FALSE;
            Document o = (Document)options.get((Object)"writeConcern");
            wc = MongoDBDialect.getWriteConcern(o);
        }
        MongoCollection collectionWithConcern = collection.withWriteConcern(wc != null ? wc : collection.getWriteConcern());
        DeleteResult result = null;
        switch (operation) {
            case REMOVE: {
                result = justOne != false ? collectionWithConcern.deleteOne((Bson)query) : collectionWithConcern.deleteMany((Bson)query);
                break;
            }
            case DELETEONE: {
                result = collectionWithConcern.deleteOne((Bson)query);
                break;
            }
            case DELETEMANY: {
                result = collectionWithConcern.deleteMany((Bson)query);
            }
        }
        if (result.wasAcknowledged()) {
            return (int)result.getDeletedCount();
        }
        return -1;
    }

    private static int doUpdate(MongoDBQueryDescriptor queryDesc, MongoCollection<Document> collection, MongoDBQueryDescriptor.Operation operation) {
        Document query = queryDesc.getCriteria();
        Document update = queryDesc.getUpdateOrInsertOne();
        Document options = queryDesc.getOptions();
        Boolean upsert = Boolean.FALSE;
        Boolean multi = Boolean.FALSE;
        WriteConcern wc = null;
        if (options != null) {
            upsert = (Boolean)options.get((Object)"upsert");
            upsert = upsert != null ? upsert : Boolean.FALSE;
            multi = (Boolean)options.get((Object)"multi");
            multi = multi != null ? multi : Boolean.FALSE;
            Document o = (Document)options.get((Object)"writeConcern");
            wc = MongoDBDialect.getWriteConcern(o);
        }
        UpdateOptions updateOptions = new UpdateOptions().upsert(upsert.booleanValue());
        UpdateResult result = null;
        switch (operation) {
            case UPDATEONE: {
                result = collection.withWriteConcern(wc != null ? wc : collection.getWriteConcern()).updateOne((Bson)query, (Bson)update, updateOptions);
                break;
            }
            case UPDATEMANY: {
                result = collection.withWriteConcern(wc != null ? wc : collection.getWriteConcern()).updateMany((Bson)query, (Bson)update, updateOptions);
                break;
            }
            case UPDATE: {
                result = multi != false ? collection.withWriteConcern(wc != null ? wc : collection.getWriteConcern()).updateMany((Bson)query, (Bson)update, updateOptions) : collection.withWriteConcern(wc != null ? wc : collection.getWriteConcern()).updateOne((Bson)query, (Bson)update, updateOptions);
            }
        }
        if (result.wasAcknowledged()) {
            return (int)result.getModifiedCount();
        }
        return -1;
    }

    private static int doReplaceOne(MongoDBQueryDescriptor queryDescriptor, MongoCollection<Document> collection) {
        Document query = queryDescriptor.getCriteria();
        Document update = queryDescriptor.getUpdateOrInsertOne();
        Document options = queryDescriptor.getOptions();
        Boolean upsert = Boolean.FALSE;
        Collation collation = null;
        WriteConcern writeConcern = null;
        if (options != null) {
            upsert = (Boolean)options.get((Object)"upsert");
            upsert = upsert != null ? upsert : Boolean.FALSE;
            Document wc = (Document)options.get((Object)"writeConcern");
            writeConcern = wc != null ? MongoDBDialect.getWriteConcern(wc) : null;
            Document col = (Document)options.get((Object)"collation");
            collation = col != null ? MongoDBDialect.getCollation(col) : null;
        }
        UpdateOptions updateOptions = new UpdateOptions().upsert(upsert.booleanValue()).collation(collation);
        UpdateResult result = collection.withWriteConcern(writeConcern != null ? writeConcern : collection.getWriteConcern()).replaceOne((Bson)query, (Object)update, updateOptions);
        if (result.wasAcknowledged()) {
            return (int)result.getModifiedCount();
        }
        return -1;
    }

    private static ClosableIterator<Tuple> doCount(MongoDBQueryDescriptor query, MongoCollection<Document> collection) {
        long count = collection.count((Bson)query.getCriteria());
        MapTupleSnapshot snapshot = new MapTupleSnapshot(Collections.singletonMap("n", count));
        return CollectionHelper.newClosableIterator(Collections.singletonList(new Tuple((TupleSnapshot)snapshot, Tuple.SnapshotType.UNKNOWN)));
    }

    private static int doDrop(MongoCollection<Document> collection) {
        collection.drop();
        return 1;
    }

    private static WriteConcern getWriteConcern(Document obj) {
        WriteConcern wc = null;
        if (obj != null) {
            Object w = obj.get((Object)"w");
            Boolean j = (Boolean)obj.get((Object)"j");
            Integer t = (Integer)obj.get((Object)"wtimeout");
            if (w instanceof String) {
                wc = new WriteConcern((String)w, t != null ? t : 0, false, j != null ? j : false);
            }
            if (w instanceof Number) {
                wc = new WriteConcern(((Number)w).intValue(), t != null ? t : 0, false, j != null ? j : false);
            }
        }
        return wc;
    }

    private static String getCollectionName(BackendQuery<?> customQuery, MongoDBQueryDescriptor queryDescriptor, EntityKeyMetadata entityKeyMetadata) {
        if (queryDescriptor.getCollectionName() != null) {
            return queryDescriptor.getCollectionName();
        }
        if (entityKeyMetadata != null) {
            return entityKeyMetadata.getTable();
        }
        throw log.unableToDetermineCollectionName(customQuery.getQuery().toString());
    }

    private static Document associationKeyToObject(AssociationKey key, AssociationStorageStrategy storageStrategy) {
        if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
            throw new AssertionFailure(MongoHelpers.class.getName() + ".associationKeyToObject should not be called for associations embedded in entity documents");
        }
        Object[] columnValues = key.getColumnValues();
        Document columns = new Document();
        String prefix = DocumentHelpers.getColumnSharedPrefix((String[])key.getColumnNames());
        prefix = prefix == null ? "" : prefix + PROPERTY_SEPARATOR;
        int i = 0;
        for (String name : key.getColumnNames()) {
            MongoHelpers.setValue(columns, name.substring(prefix.length()), columnValues[i++]);
        }
        Document idObject = new Document();
        if (storageStrategy == AssociationStorageStrategy.GLOBAL_COLLECTION) {
            columns.put(TABLE_FIELDNAME, (Object)key.getTable());
        }
        idObject.put(ID_FIELDNAME, (Object)columns);
        return idObject;
    }

    private static AssociationStorageStrategy getAssociationStorageStrategy(AssociationKey key, AssociationContext associationContext) {
        return MongoDBDialect.getAssociationStorageStrategy(key.getMetadata(), associationContext.getAssociationTypeContext());
    }

    private static AssociationStorageStrategy getAssociationStorageStrategy(AssociationKeyMetadata keyMetadata, AssociationTypeContext associationTypeContext) {
        AssociationStorageType associationStorage = (AssociationStorageType)associationTypeContext.getOptionsContext().getUnique(AssociationStorageOption.class);
        AssociationDocumentStorageType associationDocumentStorageType = (AssociationDocumentStorageType)((Object)associationTypeContext.getOptionsContext().getUnique(AssociationDocumentStorageOption.class));
        return AssociationStorageStrategy.getInstance(keyMetadata, associationStorage, associationDocumentStorageType);
    }

    public void executeBatch(OperationsQueue queue) {
        if (!queue.isClosed()) {
            Operation operation = queue.poll();
            HashMap<MongoCollection<Document>, BatchInsertionTask> inserts = new HashMap<MongoCollection<Document>, BatchInsertionTask>();
            ArrayList<Tuple> insertTuples = new ArrayList<Tuple>();
            while (operation != null) {
                if (operation instanceof GroupedChangesToEntityOperation) {
                    GroupedChangesToEntityOperation entityOperation = (GroupedChangesToEntityOperation)operation;
                    this.executeBatchUpdate(inserts, insertTuples, entityOperation);
                } else if (operation instanceof RemoveTupleOperation) {
                    RemoveTupleOperation removeTupleOperation = (RemoveTupleOperation)operation;
                    this.executeBatchRemove(inserts, removeTupleOperation);
                } else {
                    throw new UnsupportedOperationException("Operation not supported: " + operation.getClass().getSimpleName());
                }
                operation = queue.poll();
            }
            MongoDBDialect.flushInserts(inserts);
            for (Tuple insertTuple : insertTuples) {
                insertTuple.setSnapshotType(Tuple.SnapshotType.UPDATE);
            }
            queue.clear();
        }
    }

    private void executeBatchRemove(Map<MongoCollection<Document>, BatchInsertionTask> inserts, RemoveTupleOperation tupleOperation) {
        EntityKey entityKey = tupleOperation.getEntityKey();
        MongoCollection<Document> collection = this.getCollection(entityKey, tupleOperation.getTupleContext().getTupleTypeContext().getOptionsContext());
        BatchInsertionTask batchedInserts = inserts.get(collection);
        if (batchedInserts != null && batchedInserts.containsKey(entityKey)) {
            batchedInserts.remove(entityKey);
        } else {
            this.removeTuple(entityKey, tupleOperation.getTupleContext());
        }
    }

    private void executeBatchUpdate(Map<MongoCollection<Document>, BatchInsertionTask> inserts, List<Tuple> insertTuples, GroupedChangesToEntityOperation groupedOperation) {
        EntityKey entityKey = groupedOperation.getEntityKey();
        MongoCollection<Document> collection = this.getCollection(entityKey);
        Document insertStatement = null;
        Document updateStatement = new Document();
        WriteConcern writeConcern = null;
        UpdateOptions updateOptions = new UpdateOptions().upsert(true);
        for (Operation operation : groupedOperation.getOperations()) {
            if (operation instanceof InsertOrUpdateTupleOperation) {
                InsertOrUpdateTupleOperation tupleOperation = (InsertOrUpdateTupleOperation)operation;
                Tuple tuple = tupleOperation.getTuplePointer().getTuple();
                MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tuple.getSnapshot();
                writeConcern = MongoDBDialect.mergeWriteConcern(writeConcern, MongoDBDialect.getWriteConcern(tupleOperation.getTupleContext()));
                if (Tuple.SnapshotType.INSERT == tuple.getSnapshotType()) {
                    Document document = MongoDBDialect.getCurrentDocument(snapshot, insertStatement, entityKey);
                    insertStatement = MongoDBDialect.objectForInsert(tuple, document);
                    MongoDBDialect.getOrCreateBatchInsertionTask(inserts, entityKey.getMetadata(), collection).put(entityKey, insertStatement);
                    insertTuples.add(tuple);
                    continue;
                }
                updateStatement = MongoDBDialect.objectForUpdate(tuple, tupleOperation.getTupleContext(), updateStatement);
                continue;
            }
            if (operation instanceof InsertOrUpdateAssociationOperation) {
                Object toStore;
                InsertOrUpdateAssociationOperation updateAssociationOperation = (InsertOrUpdateAssociationOperation)operation;
                Association association = updateAssociationOperation.getAssociation();
                AssociationKey associationKey = updateAssociationOperation.getAssociationKey();
                AssociationContext associationContext = updateAssociationOperation.getContext();
                AssociationStorageStrategy storageStrategy = MongoDBDialect.getAssociationStorageStrategy(associationKey, associationContext);
                String collectionRole = associationKey.getMetadata().getCollectionRole();
                Object rows = MongoDBDialect.getAssociationRows(association, associationKey, associationContext);
                Object object = toStore = associationKey.getMetadata().getAssociationType() == AssociationType.ONE_TO_ONE ? ((List)rows).get(0) : rows;
                if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
                    writeConcern = MongoDBDialect.mergeWriteConcern(writeConcern, MongoDBDialect.getWriteConcern(associationContext));
                    if (insertStatement != null) {
                        MongoHelpers.setValue(insertStatement, collectionRole, rows);
                        continue;
                    }
                    MongoDBDialect.addSetToQuery(updateStatement, collectionRole, toStore);
                    Document document = this.getDocument(association, associationContext);
                    if (document == null) continue;
                    MongoHelpers.setValue(document, associationKey.getMetadata().getCollectionRole(), toStore);
                    continue;
                }
                MongoDBAssociationSnapshot associationSnapshot = (MongoDBAssociationSnapshot)association.getSnapshot();
                MongoCollection<Document> associationCollection = this.getAssociationCollection(associationKey, storageStrategy, associationContext);
                Document query = associationSnapshot.getQueryObject();
                Document update = new Document("$set", (Object)new Document(ROWS_FIELDNAME, toStore));
                associationCollection.updateOne((Bson)query, (Bson)update, updateOptions);
                continue;
            }
            if (operation instanceof RemoveAssociationOperation) {
                AssociationContext associationContext;
                if (insertStatement != null) {
                    throw new IllegalStateException("RemoveAssociationOperation not supported in the INSERT case");
                }
                RemoveAssociationOperation removeAssociationOperation = (RemoveAssociationOperation)operation;
                AssociationKey associationKey = removeAssociationOperation.getAssociationKey();
                AssociationStorageStrategy storageStrategy = MongoDBDialect.getAssociationStorageStrategy(associationKey, associationContext = removeAssociationOperation.getContext());
                if (storageStrategy == AssociationStorageStrategy.IN_ENTITY) {
                    writeConcern = MongoDBDialect.mergeWriteConcern(writeConcern, MongoDBDialect.getWriteConcern(associationContext));
                    String collectionRole = associationKey.getMetadata().getCollectionRole();
                    if (associationContext.getEntityTuplePointer().getTuple() != null) {
                        MongoHelpers.resetValue(((MongoDBTupleSnapshot)associationContext.getEntityTuplePointer().getTuple().getSnapshot()).getDbObject(), collectionRole);
                    }
                    MongoDBDialect.addUnsetToQuery(updateStatement, collectionRole);
                    continue;
                }
                MongoCollection associationCollection = this.getAssociationCollection(associationKey, storageStrategy, associationContext).withWriteConcern(MongoDBDialect.getWriteConcern(associationContext));
                Document query = MongoDBDialect.associationKeyToObject(associationKey, storageStrategy);
                DeleteResult result = associationCollection.deleteMany((Bson)query);
                long nAffected = -1L;
                if (result.wasAcknowledged()) {
                    nAffected = result.getDeletedCount();
                }
                log.removedAssociation(nAffected);
                continue;
            }
            throw new IllegalStateException(operation.getClass().getSimpleName() + " not supported here");
        }
        if (updateStatement != null && !updateStatement.isEmpty()) {
            collection.withWriteConcern(writeConcern).updateOne((Bson)MongoDBDialect.prepareIdObject(entityKey), (Bson)updateStatement, updateOptions);
        }
    }

    private Document getDocument(Association association, AssociationContext associationContext) {
        TuplePointer tuplePointer = associationContext.getEntityTuplePointer();
        if (tuplePointer.getTuple() != null) {
            Tuple tuple = tuplePointer.getTuple();
            MongoDBTupleSnapshot tupleSnapshot = (MongoDBTupleSnapshot)tuple.getSnapshot();
            return tupleSnapshot.getDbObject();
        }
        return null;
    }

    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return NoOpParameterMetadataBuilder.INSTANCE;
    }

    private static Document getCurrentDocument(MongoDBTupleSnapshot snapshot, Document insertStatement, EntityKey entityKey) {
        return insertStatement != null ? insertStatement : snapshot.getDbObject();
    }

    private static BatchInsertionTask getOrCreateBatchInsertionTask(Map<MongoCollection<Document>, BatchInsertionTask> inserts, EntityKeyMetadata entityKeyMetadata, MongoCollection<Document> collection) {
        BatchInsertionTask insertsForCollection = inserts.get(collection);
        if (insertsForCollection == null) {
            insertsForCollection = new BatchInsertionTask(entityKeyMetadata);
            inserts.put(collection, insertsForCollection);
        }
        return insertsForCollection;
    }

    private static void flushInserts(Map<MongoCollection<Document>, BatchInsertionTask> inserts) {
        for (Map.Entry<MongoCollection<Document>, BatchInsertionTask> entry : inserts.entrySet()) {
            MongoCollection<Document> collection = entry.getKey();
            if (entry.getValue().isEmpty()) continue;
            try {
                collection.insertMany(entry.getValue().getAll());
            }
            catch (DuplicateKeyException | MongoBulkWriteException dke) {
                if (PRIMARY_KEY_CONSTRAINT_VIOLATION_MESSAGE.matcher(dke.getMessage()).matches()) {
                    throw new TupleAlreadyExistsException(entry.getValue().getEntityKeyMetadata(), dke);
                }
                throw log.constraintViolationOnFlush(dke.getMessage(), (Exception)dke);
            }
        }
        inserts.clear();
    }

    private static WriteConcern getWriteConcern(TupleContext tupleContext) {
        return (WriteConcern)tupleContext.getTupleTypeContext().getOptionsContext().getUnique(WriteConcernOption.class);
    }

    private static WriteConcern getWriteConcern(AssociationContext associationContext) {
        return (WriteConcern)associationContext.getAssociationTypeContext().getOptionsContext().getUnique(WriteConcernOption.class);
    }

    private static WriteConcern mergeWriteConcern(WriteConcern original, WriteConcern writeConcern) {
        boolean fsync;
        if (original == null) {
            return writeConcern;
        }
        if (writeConcern == null) {
            return original;
        }
        if (original.equals((Object)writeConcern)) {
            return original;
        }
        Object wObject = original.getWObject() instanceof String ? original.getWString() : (writeConcern.getWObject() instanceof String ? writeConcern.getWString() : Integer.valueOf(Math.max(original.getW(), writeConcern.getW())));
        int wTimeoutMS = Math.min(original.getWtimeout(), writeConcern.getWtimeout());
        boolean bl = fsync = original.getFsync() || writeConcern.getFsync();
        Boolean journal = original.getJournal() == null ? writeConcern.getJournal() : (writeConcern.getJournal() == null ? original.getJournal() : Boolean.valueOf(original.getJournal() != false || writeConcern.getJournal() != false));
        if (wObject instanceof String) {
            return new WriteConcern((String)wObject, wTimeoutMS, fsync, journal.booleanValue());
        }
        return new WriteConcern(((Integer)wObject).intValue(), wTimeoutMS, fsync, journal.booleanValue());
    }

    public ClosableIterator<Tuple> callStoredProcedure(String storedProcedureName, ProcedureQueryParameters params, TupleContext tupleContext) {
        this.validate(params);
        StringBuilder commandLine = this.createCallStoreProcedureCommand(storedProcedureName, params);
        Document result = this.callStoredProcedure(commandLine);
        Object resultValue = result.get((Object)"retval");
        List<Tuple> resultTuples = this.extractTuples(storedProcedureName, resultValue);
        return CollectionHelper.newClosableIterator(resultTuples);
    }

    private void validate(ProcedureQueryParameters params) {
        if (!params.getNamedParameters().isEmpty()) {
            throw log.dialectDoesNotSupportNamedParametersForStoredProcedures(((Object)((Object)this)).getClass());
        }
    }

    private List<Tuple> extractTuples(String storedProcedureName, Object retvalObj) {
        if (retvalObj instanceof Document) {
            Document retval = (Document)retvalObj;
            if (retval.size() > 1) {
                throw log.multipleDocumentReturnedByStoredProcedure(storedProcedureName, retval.size());
            }
            String firstRetValTag = (String)retval.keySet().iterator().next();
            Object firstRetVal = retval.get((Object)firstRetValTag);
            Iterable documents = (Iterable)firstRetVal;
            ArrayList<Tuple> resultTuples = new ArrayList<Tuple>();
            for (Document doc : documents) {
                resultTuples.add(this.convert(doc));
            }
            return resultTuples;
        }
        Tuple tuple = new Tuple();
        tuple.put("result", retvalObj);
        return Collections.singletonList(tuple);
    }

    private Document callStoredProcedure(StringBuilder commandLine) {
        try {
            Document result = this.provider.getDatabase().runCommand((Bson)new Document("$eval", (Object)commandLine.toString()));
            return result;
        }
        catch (MongoCommandException mce) {
            BsonDocument response = mce.getResponse();
            throw log.unableToExecuteCommand(commandLine.toString(), response.getString((Object)"errmsg").getValue(), response.getString((Object)"codeName").getValue(), (Exception)((Object)mce));
        }
    }

    private StringBuilder createCallStoreProcedureCommand(String storedProcedureName, ProcedureQueryParameters params) {
        StringBuilder commandLine = new StringBuilder(storedProcedureName).append("(");
        List positionalParameters = params.getPositionalParameters();
        for (Object paramValue : positionalParameters) {
            this.appendStoredProcedureParamValue(storedProcedureName, commandLine, paramValue);
            commandLine.append(",");
        }
        commandLine.setLength(commandLine.length() - 1);
        commandLine.append(")");
        return commandLine;
    }

    private void appendStoredProcedureParamValue(String storedProcedureName, StringBuilder commandLine, Object paramValue) {
        if (paramValue == null) {
            commandLine.append("null");
        } else if (this.requiresQuotes(paramValue)) {
            String escapedValue = StringHelper.escapeDoubleQuotesForJson((String)paramValue.toString());
            commandLine.append('\"').append(escapedValue).append('\"');
        } else {
            commandLine.append(paramValue);
        }
    }

    private boolean requiresQuotes(Object value) {
        return value instanceof String || this.isNotNumeric(value.toString());
    }

    private boolean isNotNumeric(String value) {
        return !NUMBER_PATTERN.matcher(value).matches();
    }

    private Tuple convert(Document document) {
        Tuple tuple = new Tuple();
        if (document != null) {
            for (Map.Entry entry : document.entrySet()) {
                tuple.put((String)entry.getKey(), entry.getValue());
            }
        }
        return tuple;
    }

    private static class BatchInsertionTask {
        private final EntityKeyMetadata entityKeyMetadata;
        private final Map<EntityKey, Document> inserts;

        public BatchInsertionTask(EntityKeyMetadata entityKeyMetadata) {
            this.entityKeyMetadata = entityKeyMetadata;
            this.inserts = new HashMap<EntityKey, Document>();
        }

        public EntityKeyMetadata getEntityKeyMetadata() {
            return this.entityKeyMetadata;
        }

        public List<Document> getAll() {
            return new ArrayList<Document>(this.inserts.values());
        }

        public boolean containsKey(EntityKey entityKey) {
            return this.inserts.containsKey(entityKey);
        }

        public Document remove(EntityKey entityKey) {
            return this.inserts.remove(entityKey);
        }

        public void put(EntityKey entityKey, Document object) {
            this.inserts.put(entityKey, object);
        }

        public boolean isEmpty() {
            return this.inserts.isEmpty();
        }
    }

    private static class SingleTupleIterator
    implements ClosableIterator<Tuple> {
        private Document theOne;
        private final EntityKeyMetadata metadata;
        private final MongoCollection<Document> collection;

        public SingleTupleIterator(Document theOne, MongoCollection<Document> collection, EntityKeyMetadata metadata) {
            this.theOne = theOne;
            this.collection = collection;
            this.metadata = metadata;
        }

        public boolean hasNext() {
            return this.theOne != null;
        }

        public Tuple next() {
            if (this.theOne == null) {
                throw new NoSuchElementException();
            }
            Tuple t = new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(this.theOne, this.metadata), Tuple.SnapshotType.UPDATE);
            this.theOne = null;
            return t;
        }

        public void remove() {
            if (this.theOne == null) {
                throw new IllegalStateException();
            }
            this.collection.deleteOne((Bson)this.theOne);
            this.theOne = null;
        }

        public void close() {
        }
    }

    private static class MongoDBResultsCursor
    implements ClosableIterator<Tuple> {
        private final MongoCursor<Document> cursor;
        private final EntityKeyMetadata metadata;

        public MongoDBResultsCursor(MongoCursor<Document> cursor, EntityKeyMetadata metadata) {
            this.cursor = cursor;
            this.metadata = metadata;
        }

        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        public Tuple next() {
            Document dbObject = (Document)this.cursor.next();
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(dbObject, this.metadata), Tuple.SnapshotType.UPDATE);
        }

        public void remove() {
            this.cursor.remove();
        }

        public void close() {
            this.cursor.close();
        }
    }

    private static class MongoDBTuplesSupplier
    implements TuplesSupplier {
        private final MongoCollection<Document> collection;
        private final EntityKeyMetadata entityKeyMetadata;

        public MongoDBTuplesSupplier(MongoCollection<Document> collection, EntityKeyMetadata entityKeyMetadata) {
            this.collection = collection;
            this.entityKeyMetadata = entityKeyMetadata;
        }

        public ClosableIterator<Tuple> get(TransactionContext transactionContext) {
            return new MongoDBResultsCursor((MongoCursor<Document>)this.collection.find().iterator(), this.entityKeyMetadata);
        }
    }

    private static class MongoDBAggregationOutput
    implements ClosableIterator<Tuple> {
        private final Iterator<Document> results;
        private final EntityKeyMetadata metadata;

        public MongoDBAggregationOutput(AggregateIterable<Document> output, EntityKeyMetadata metadata) {
            this.results = output.iterator();
            this.metadata = metadata;
        }

        public boolean hasNext() {
            return this.results.hasNext();
        }

        public Tuple next() {
            Document dbObject = this.results.next();
            return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(dbObject, this.metadata), Tuple.SnapshotType.UPDATE);
        }

        public void remove() {
            this.results.remove();
        }

        public void close() {
        }
    }
}

