/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.binarystorage;

import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.Filters;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.hibernate.ogm.datastore.mongodb.binarystorage.GridFSFields;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.datastore.mongodb.options.impl.GridFSBucketOption;
import org.hibernate.ogm.datastore.mongodb.type.GridFS;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.options.spi.OptionsService;

public class GridFSStorageManager {
    private static final String BUCKET_SUFFIX = "_bucket";
    private final Map<String, GridFSFields> tableEntityTypeMapping;
    private final OptionsService optionsService;
    private final MongoDatabase mongoDatabase;

    public GridFSStorageManager(MongoDBDatastoreProvider provider, OptionsService optionsService, Map<String, GridFSFields> tableEntityTypeMapping) {
        this.optionsService = optionsService;
        this.tableEntityTypeMapping = tableEntityTypeMapping == null ? (Map)((Object)Collections.emptyList()) : tableEntityTypeMapping;
        this.mongoDatabase = provider.getDatabase();
    }

    public void storeContentToBinaryStorage(Document currentDocument, EntityKeyMetadata metadata, Object documentId) {
        GridFSFields gridFSFields;
        if (currentDocument != null && metadata != null && (gridFSFields = this.tableEntityTypeMapping.get(metadata.getTable())) != null) {
            for (Field field : gridFSFields.getFields()) {
                String bucketName = this.bucketName(metadata, field.getName());
                this.storeContentFromFieldToBinaryStorage(bucketName, currentDocument, field.getName(), documentId);
            }
        }
    }

    private void storeContentFromFieldToBinaryStorage(String bucketName, Document documentToInsert, String fieldName, Object documentId) {
        if (documentToInsert.containsKey((Object)fieldName)) {
            GridFSBucket gridFSFilesBucket = this.getGridFSFilesBucket(this.mongoDatabase, bucketName);
            this.deleteExistingContent(fieldName, documentId, gridFSFilesBucket);
            GridFS gridfsObject = (GridFS)documentToInsert.get((Object)fieldName, GridFS.class);
            if (gridfsObject != null) {
                ObjectId uploadId = gridFSFilesBucket.uploadFromStream(this.fileName(fieldName, documentId), gridfsObject.getInputStream());
                documentToInsert.put(fieldName, (Object)uploadId);
            }
        }
    }

    private void deleteExistingContent(String fieldName, Object documentId, GridFSBucket gridFSFilesBucket) {
        GridFSFindIterable results = gridFSFilesBucket.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"filename", (Object)this.fileName(fieldName, documentId))}));
        try (MongoCursor iterator = results.iterator();){
            while (iterator.hasNext()) {
                GridFSFile next = (GridFSFile)iterator.next();
                gridFSFilesBucket.delete(next.getId());
            }
        }
    }

    private String fileName(String fieldName, Object documentId) {
        return fieldName + "_" + String.valueOf(documentId);
    }

    public void removeEntityFromBinaryStorage(Document deletedDocument, EntityKeyMetadata entityKeyMetadata) {
        this.removeFieldsFromBinaryStorage(deletedDocument, entityKeyMetadata, deletedDocument.get((Object)"_id"));
    }

    public void removeFieldsFromBinaryStorage(Document fieldsToDelete, EntityKeyMetadata entityKeyMetadata, Object documentId) {
        GridFSFields storageFields;
        if (fieldsToDelete != null && entityKeyMetadata != null && (storageFields = this.tableEntityTypeMapping.get(entityKeyMetadata.getTable())) != null) {
            Set<Field> fields = storageFields.getFields();
            for (Field gridfsField : fields) {
                if (!fieldsToDelete.containsKey((Object)gridfsField.getName())) continue;
                String gridfsBucketName = this.bucketName(entityKeyMetadata, gridfsField.getName());
                GridFSBucket gridFSFilesBucket = this.getGridFSFilesBucket(this.mongoDatabase, gridfsBucketName);
                this.deleteExistingContent(gridfsField.getName(), documentId, gridFSFilesBucket);
            }
        }
    }

    private String bucketName(EntityKeyMetadata entityKeyMetadata, String fieldName) {
        GridFSFields storageFields = this.tableEntityTypeMapping.get(entityKeyMetadata.getTable());
        OptionsContext optionsContext = this.propertyOptions(storageFields.getEntityClass(), fieldName);
        String gridfsBucketName = (String)optionsContext.getUnique(GridFSBucketOption.class);
        if (gridfsBucketName != null) {
            return gridfsBucketName;
        }
        return entityKeyMetadata.getTable() + BUCKET_SUFFIX;
    }

    public void loadContentFromBinaryStorage(Document currentDocument, EntityKeyMetadata metadata) {
        if (metadata != null) {
            GridFSFields fields = this.tableEntityTypeMapping.get(metadata.getTable());
            if (currentDocument != null && fields != null) {
                for (Field field : fields.getFields()) {
                    String bucketName = this.bucketName(metadata, field.getName());
                    this.loadContentFromBinaryStorageToField(bucketName, currentDocument, field.getName());
                }
            }
        }
    }

    private void loadContentFromBinaryStorageToField(String bucketName, Document currentDocument, String fieldName) {
        GridFSBucket gridFSFilesBucket = this.getGridFSFilesBucket(this.mongoDatabase, bucketName);
        Object uploadId = currentDocument.get((Object)fieldName);
        if (uploadId != null) {
            GridFSDownloadStream gridFSDownloadStream = gridFSFilesBucket.openDownloadStream((ObjectId)uploadId);
            GridFS value = new GridFS((InputStream)gridFSDownloadStream);
            currentDocument.put(fieldName, (Object)value);
        }
    }

    private OptionsContext propertyOptions(Class<?> entityType, String fieldName) {
        OptionsContext propertyOptions = this.optionsService.context().getPropertyOptions(entityType, fieldName);
        return propertyOptions;
    }

    private GridFSBucket getGridFSFilesBucket(MongoDatabase mongoDatabase, String bucketName) {
        return bucketName != null ? GridFSBuckets.create((MongoDatabase)mongoDatabase, (String)bucketName) : GridFSBuckets.create((MongoDatabase)mongoDatabase);
    }
}

