/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.impl;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.ogm.cfg.spi.Hosts;
import org.hibernate.ogm.datastore.mongodb.MongoDBDialect;
import org.hibernate.ogm.datastore.mongodb.binarystorage.GridFSFields;
import org.hibernate.ogm.datastore.mongodb.binarystorage.GridFSStorageManager;
import org.hibernate.ogm.datastore.mongodb.configuration.impl.MongoDBConfiguration;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBSchemaDefiner;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBBasedQueryParserService;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.query.spi.QueryParserService;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class MongoDBDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
Configurable,
ServiceRegistryAwareService {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private ServiceRegistryImplementor serviceRegistry;
    private MongoClient mongo;
    private MongoDatabase mongoDb;
    private MongoDBConfiguration config;
    private JndiService jndiService;
    private GridFSStorageManager binaryStorageManager;

    public MongoDBDatastoreProvider() {
    }

    public MongoDBDatastoreProvider(MongoClient mongoClient) {
        this.mongo = mongoClient;
    }

    public void configure(Map configurationValues) {
        OptionsService optionsService = (OptionsService)this.serviceRegistry.getService(OptionsService.class);
        ClassLoaderService classLoaderService = (ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class);
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues, classLoaderService);
        try {
            this.config = new MongoDBConfiguration(propertyReader, optionsService.context().getGlobalOptions());
        }
        catch (Exception e) {
            throw log.unableToConfigureDatastoreProvider(e);
        }
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.jndiService = (JndiService)serviceRegistry.getService(JndiService.class);
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return MongoDBDialect.class;
    }

    public Class<? extends QueryParserService> getDefaultQueryParserServiceType() {
        return MongoDBBasedQueryParserService.class;
    }

    public Class<? extends SchemaDefiner> getSchemaDefinerType() {
        return MongoDBSchemaDefiner.class;
    }

    public boolean allowsTransactionEmulation() {
        return true;
    }

    public void start() {
        if (this.config.getNativeClientResource() == null) {
            this.startClientAndExtractDatabase();
        } else {
            this.lookupDatabase();
        }
        this.jndiService = null;
    }

    private void lookupDatabase() {
        try {
            log.tracef("Retrieving MongoDatabase from JNDI at %1$s", this.config.getNativeClientResource());
            this.mongoDb = (MongoDatabase)this.jndiService.locate(this.config.getNativeClientResource());
        }
        catch (RuntimeException e) {
            throw log.errorOnFetchJndiClientProperty(this.config.getNativeClientResource());
        }
    }

    private void startClientAndExtractDatabase() {
        try {
            if (this.mongo == null) {
                this.mongo = this.createMongoClient(this.config);
            }
            this.mongoDb = this.extractDatabase(this.mongo, this.config);
        }
        catch (Exception e) {
            throw log.unableToStartDatastoreProvider(e);
        }
    }

    protected MongoClient createMongoClient(MongoDBConfiguration config) {
        MongoClientOptions clientOptions = config.buildOptions();
        List<MongoCredential> credentials = config.buildCredentials();
        log.connectingToMongo(config.getHosts().toString(), clientOptions.getConnectTimeout());
        try {
            ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>(config.getHosts().size());
            for (Hosts.HostAndPort hostAndPort : config.getHosts()) {
                serverAddresses.add(new ServerAddress(hostAndPort.getHost(), hostAndPort.getPort().intValue()));
            }
            return credentials == null ? new MongoClient(serverAddresses, clientOptions) : new MongoClient(serverAddresses, credentials, clientOptions);
        }
        catch (RuntimeException e) {
            throw log.unableToInitializeMongoDB(e);
        }
    }

    public void stop() {
        log.disconnectingFromMongo();
        this.mongo.close();
    }

    public MongoDatabase getDatabase() {
        return this.mongoDb;
    }

    private MongoDatabase extractDatabase(MongoClient mongo, MongoDBConfiguration config) {
        try {
            String databaseName = config.getDatabaseName();
            log.connectingToMongoDatabase(databaseName);
            Boolean containsDatabase = this.containsDatabase(mongo, databaseName);
            if (containsDatabase == Boolean.FALSE) {
                if (config.isCreateDatabase()) {
                    log.creatingDatabase(databaseName);
                } else {
                    throw log.databaseDoesNotExistException(config.getDatabaseName());
                }
            }
            MongoDatabase db = mongo.getDatabase(databaseName);
            if (containsDatabase == null) {
                MongoCursor it = db.listCollectionNames().iterator();
                while (it.hasNext()) {
                    if (!((String)it.next()).equalsIgnoreCase("WeDoNotCareWhatItIsWeNeedToConnect")) continue;
                    containsDatabase = true;
                    break;
                }
            }
            return mongo.getDatabase(databaseName);
        }
        catch (MongoException me) {
            throw log.unableToConnectToDatastore(me.getMessage(), (Exception)((Object)me));
        }
    }

    private Boolean containsDatabase(MongoClient mongo, String databaseName) {
        try {
            for (String existingName : mongo.listDatabaseNames()) {
                if (!existingName.equals(databaseName)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (MongoException me) {
            return null;
        }
    }

    public void initializeBinaryStorageManager(OptionsService optionsService, Map<String, GridFSFields> map) {
        this.binaryStorageManager = new GridFSStorageManager(this, optionsService, map);
    }

    public GridFSStorageManager getBinaryStorageManager() {
        return this.binaryStorageManager;
    }
}

