/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bson.Document;
import org.hibernate.hql.ast.origin.hql.resolve.path.AggregationPropertyPath;

public class AggregationRenderer {
    private static final String PROJECTION_FIELD = "n";
    private final AggregationPropertyPath.Type aggregationType;
    private final String propertyPath;
    private final String aggregationTypeOperator;

    public AggregationRenderer(AggregationPropertyPath.Type aggregationType) {
        this(null, aggregationType);
    }

    public AggregationRenderer(String propertypath, AggregationPropertyPath.Type aggregationType) {
        this.propertyPath = propertypath != null ? "$" + propertypath : null;
        this.aggregationTypeOperator = "$" + aggregationType.name().toLowerCase(Locale.ROOT).split("_")[0];
        this.aggregationType = aggregationType;
    }

    public List<Document> asDocumentPipeline() {
        if (this.aggregationType == AggregationPropertyPath.Type.COUNT_DISTINCT) {
            return this.getDistinctCountGroup();
        }
        if (this.aggregationType == AggregationPropertyPath.Type.COUNT) {
            return Arrays.asList(this.getCount());
        }
        return Arrays.asList(this.getGroup());
    }

    private Document getGroup() {
        Document groupOptions = new Document();
        groupOptions.append("_id", null);
        groupOptions.append(PROJECTION_FIELD, (Object)new Document().append(this.aggregationTypeOperator, (Object)this.propertyPath));
        Document group = new Document();
        group.append("$group", (Object)groupOptions);
        return group;
    }

    private List<Document> getDistinctCountGroup() {
        String groupColumn = this.propertyPath == null ? "$_id" : this.propertyPath;
        Document group = new Document();
        group.append("$group", (Object)new Document("_id", (Object)groupColumn));
        Document groupSum = new Document();
        groupSum.append("$group", (Object)new Document().append("_id", (Object)this.propertyPath).append(PROJECTION_FIELD, (Object)new Document("$sum", (Object)1)));
        return Arrays.asList(group, groupSum);
    }

    private Document getCount() {
        Document count = new Document();
        count.append(this.aggregationTypeOperator, (Object)PROJECTION_FIELD);
        return count;
    }

    public String getAggregationProjection() {
        return PROJECTION_FIELD;
    }
}

