/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.impl;

import java.util.Map;
import java.util.Properties;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jGraphDatabaseServiceFactoryProvider;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.spi.GraphDatabaseServiceFactory;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.neo4j.Neo4jDialect;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.options.navigation.context.GlobalContext;
import org.hibernate.ogm.options.navigation.impl.ConfigurationContext;
import org.hibernate.ogm.options.navigation.impl.GenericOptionModel;
import org.hibernate.ogm.service.impl.LuceneBasedQueryParserService;
import org.hibernate.ogm.service.impl.QueryParserService;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;

public class Neo4jDatastoreProvider
implements DatastoreProvider,
Startable,
Stoppable,
Configurable {
    private String sequenceIndexName = "_sequences_ogm_index";
    private String nodeIndexName = "_nodes_ogm_index";
    private String relationshipIndexName = "_relationships_ogm_index";
    private GraphDatabaseService neo4jDb;
    private Neo4jSequenceGenerator neo4jSequenceGenerator;
    private GraphDatabaseServiceFactory graphDbFactory;

    public Class<? extends QueryParserService> getDefaultQueryParserServiceType() {
        return LuceneBasedQueryParserService.class;
    }

    public void configure(Map cfg) {
        this.graphDbFactory = new Neo4jGraphDatabaseServiceFactoryProvider().load(this.properties(cfg));
        this.sequenceIndexName = this.defaultIfNull(cfg, "hibernate.ogm.neo4j.index.sequence", "_sequences_ogm_index");
        this.nodeIndexName = this.defaultIfNull(cfg, "hibernate.ogm.neo4j.index.entity", "_nodes_ogm_index");
        this.relationshipIndexName = this.defaultIfNull(cfg, "hibernate.ogm.neo4j.index.association", "_relationships_ogm_index");
    }

    private String defaultIfNull(Map<?, ?> cfg, String key, String defaultValue) {
        String indexName = (String)cfg.get(key);
        return indexName == null ? defaultValue : indexName;
    }

    public void stop() {
        this.neo4jDb.shutdown();
    }

    public void start() {
        this.neo4jDb = this.graphDbFactory.create();
        this.neo4jSequenceGenerator = new Neo4jSequenceGenerator(this.neo4jDb, this.sequenceIndexName);
        this.graphDbFactory = null;
    }

    private Properties properties(Map<?, ?> configuration) {
        Properties properties = new Properties();
        properties.putAll(configuration);
        return properties;
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return Neo4jDialect.class;
    }

    public Node createNode() {
        return this.neo4jDb.createNode();
    }

    public GraphDatabaseService getDataBase() {
        return this.neo4jDb;
    }

    public int nextValue(RowKey key, int increment, int initialValue) {
        return this.neo4jSequenceGenerator.nextValue(key, increment, initialValue);
    }

    public Index<Node> getNodesIndex() {
        return this.neo4jDb.index().forNodes(this.nodeIndexName);
    }

    public Index<Relationship> getRelationshipsIndex() {
        return this.neo4jDb.index().forRelationships(this.relationshipIndexName);
    }

    public GlobalContext<?, ?> getConfigurationBuilder(ConfigurationContext context) {
        return GenericOptionModel.createGlobalContext((ConfigurationContext)context);
    }
}

