/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.impl;

import java.util.Properties;
import org.hibernate.ogm.datastore.neo4j.impl.EmbeddedGraphDatabaseFactory;
import org.hibernate.ogm.datastore.neo4j.spi.GraphDatabaseServiceFactory;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.neo4j.graphdb.GraphDatabaseService;

public class Neo4jGraphDatabaseServiceFactoryProvider {
    public GraphDatabaseServiceFactory load(Properties properties) {
        String factoryClassName = (String)properties.get("hibernate.ogm.neo4j.graphdb.factoryclass");
        GraphDatabaseServiceFactory factory = this.createFactory(factoryClassName);
        factory.initialize(properties);
        return factory;
    }

    private GraphDatabaseServiceFactory createFactory(String className) {
        if (className == null) {
            return new EmbeddedGraphDatabaseFactory();
        }
        return (GraphDatabaseServiceFactory)ClassLoaderHelper.instanceFromName(GraphDatabaseServiceFactory.class, (String)className, this.getClass(), (String)GraphDatabaseService.class.getName());
    }
}

