/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.neo4j;

import java.util.Iterator;
import java.util.Set;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.ogm.datastore.impl.EmptyAssociationSnapshot;
import org.hibernate.ogm.datastore.impl.EmptyTupleSnapshot;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jTypeConverter;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.AssociationOperation;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.datastore.spi.TupleOperation;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.neo4j.Neo4jAssociationSnapshot;
import org.hibernate.ogm.dialect.neo4j.Neo4jIndexManager;
import org.hibernate.ogm.dialect.neo4j.Neo4jTupleSnapshot;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.massindex.batchindexing.Consumer;
import org.hibernate.ogm.type.GridType;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.type.Type;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.IndexHits;

public class Neo4jDialect
implements GridDialect {
    public static final String TABLE_PROPERTY = "_table";
    private final Neo4jDatastoreProvider provider;
    private final Neo4jIndexManager indexer;

    public Neo4jDialect(Neo4jDatastoreProvider provider) {
        this.provider = provider;
        this.indexer = new Neo4jIndexManager(provider);
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        throw new UnsupportedOperationException("LockMode " + lockMode + " is not supported by the Neo4j GridDialect");
    }

    public Tuple getTuple(EntityKey key, TupleContext context) {
        Node entityNode = this.findNode(key);
        if (entityNode == null) {
            return null;
        }
        return this.createTuple(entityNode);
    }

    private Tuple createTuple(Node entityNode) {
        return new Tuple((TupleSnapshot)new Neo4jTupleSnapshot((PropertyContainer)entityNode));
    }

    public Tuple createTuple(EntityKey key) {
        return new Tuple(EmptyTupleSnapshot.SINGLETON);
    }

    public void updateTuple(Tuple tuple, EntityKey key) {
        Node node = this.createNodeUnlessExists(key);
        this.applyTupleOperations(node, tuple.getOperations());
    }

    public void removeTuple(EntityKey key) {
        Node entityNode = this.findNode(key);
        if (entityNode != null) {
            this.removeRelationships(entityNode);
            this.removeNode(entityNode);
        }
    }

    public Tuple createTupleAssociation(AssociationKey associationKey, RowKey rowKey) {
        return new Tuple(EmptyTupleSnapshot.SINGLETON);
    }

    public Association getAssociation(AssociationKey associationKey, AssociationContext associationContext) {
        Node entityNode = this.findNode(associationKey.getEntityKey());
        if (entityNode == null) {
            return null;
        }
        return new Association((AssociationSnapshot)new Neo4jAssociationSnapshot(entityNode, this.relationshipType(associationKey), associationKey));
    }

    public Association createAssociation(AssociationKey associationKey) {
        return new Association((AssociationSnapshot)EmptyAssociationSnapshot.SINGLETON);
    }

    public void updateAssociation(Association association, AssociationKey key) {
        for (AssociationOperation action : association.getOperations()) {
            this.applyAssociationOperation(key, action);
        }
    }

    public void nextValue(RowKey key, IntegralDataTypeHolder value, int increment, int initialValue) {
        int nextValue = this.provider.nextValue(key, increment, initialValue);
        value.initialize((long)nextValue);
    }

    public GridType overrideType(Type type) {
        return Neo4jTypeConverter.INSTANCE.convert(type);
    }

    public void removeAssociation(AssociationKey key) {
        if (key != null) {
            Node node = this.findNode(key.getEntityKey());
            Iterable relationships = node.getRelationships(Direction.OUTGOING, new RelationshipType[]{this.relationshipType(key)});
            for (Relationship rel : relationships) {
                this.removeRelationship(rel);
            }
        }
    }

    private void applyAssociationOperation(AssociationKey key, AssociationOperation operation) {
        switch (operation.getType()) {
            case CLEAR: {
                this.removeAssociation(key);
                break;
            }
            case PUT: {
                this.putAssociationOperation(key, operation);
                break;
            }
            case PUT_NULL: {
                this.removeAssociationOperation(key, operation);
                break;
            }
            case REMOVE: {
                this.removeAssociationOperation(key, operation);
            }
        }
    }

    private void putAssociationOperation(AssociationKey associationKey, AssociationOperation action) {
        RowKey rowKey = action.getKey();
        Relationship relationship = this.createRelationshipUnlessExists(this.findNode(associationKey.getEntityKey()), associationKey, rowKey);
        this.applyTupleOperations(relationship.getEndNode(), action.getValue().getOperations());
    }

    private Relationship createRelationshipUnlessExists(Node startNode, AssociationKey associationKey, RowKey rowKey) {
        Relationship relationship = this.indexer.findRelationship(this.relationshipType(associationKey), rowKey);
        if (relationship == null) {
            return this.createRelationship(startNode, associationKey, rowKey);
        }
        return relationship;
    }

    private Node findNode(EntityKey entityKey) {
        return this.indexer.findNode(entityKey);
    }

    private void removeAssociationOperation(AssociationKey associationKey, AssociationOperation action) {
        RowKey rowKey = action.getKey();
        Relationship relationship = this.indexer.findRelationship(this.relationshipType(associationKey), rowKey);
        this.removeRelationship(relationship);
    }

    private void removeRelationship(Relationship relationship) {
        if (relationship != null) {
            this.indexer.remove(relationship);
            relationship.delete();
        }
    }

    private void applyTupleOperations(Node node, Set<TupleOperation> operations) {
        for (TupleOperation operation : operations) {
            this.applyOperation(node, operation);
        }
    }

    private void applyOperation(Node node, TupleOperation operation) {
        switch (operation.getType()) {
            case PUT: {
                this.putTupleOperation(node, operation);
                break;
            }
            case PUT_NULL: {
                this.removeTupleOperation(node, operation);
                break;
            }
            case REMOVE: {
                this.removeTupleOperation(node, operation);
            }
        }
    }

    private void removeTupleOperation(Node node, TupleOperation operation) {
        if (node.hasProperty(operation.getColumn())) {
            node.removeProperty(operation.getColumn());
        }
    }

    private void putTupleOperation(Node node, TupleOperation operation) {
        node.setProperty(operation.getColumn(), operation.getValue());
    }

    private Node createNodeUnlessExists(EntityKey key) {
        Node node = this.findNode(key);
        if (node == null) {
            node = this.createNode(key);
        }
        return node;
    }

    private Node createNode(EntityKey key) {
        Node node = this.provider.createNode();
        node.setProperty(TABLE_PROPERTY, (Object)key.getTable());
        for (int i = 0; i < key.getColumnNames().length; ++i) {
            node.setProperty(key.getColumnNames()[i], key.getColumnValues()[i]);
        }
        this.indexer.index(node, key);
        return node;
    }

    private void removeNode(Node entityNode) {
        this.removeRelationships(entityNode);
        this.indexer.remove(entityNode);
        entityNode.delete();
    }

    private Relationship createRelationship(Node startNode, AssociationKey associationKey, RowKey rowKey) {
        Relationship relationship = startNode.createRelationshipTo(this.provider.createNode(), this.relationshipType(associationKey));
        for (int i = 0; i < rowKey.getColumnNames().length; ++i) {
            relationship.setProperty(rowKey.getColumnNames()[i], rowKey.getColumnValues()[i]);
        }
        this.indexer.index(relationship);
        return relationship;
    }

    private RelationshipType relationshipType(AssociationKey associationKey) {
        StringBuilder builder = new StringBuilder(associationKey.getEntityKey().getTable());
        builder.append(":");
        builder.append(associationKey.getCollectionRole());
        return DynamicRelationshipType.withName((String)builder.toString());
    }

    private void removeRelationships(Node node) {
        if (node != null) {
            for (Relationship rel : node.getRelationships()) {
                this.removeRelationship(rel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachTuple(Consumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            IndexHits<Node> queryNodes = this.indexer.findNodes(entityKeyMetadata.getTable());
            try {
                for (Node node : queryNodes) {
                    Tuple tuple = this.createTuple(node);
                    consumer.consume(tuple);
                }
            }
            finally {
                queryNodes.close();
            }
        }
    }

    public Iterator<Tuple> executeBackendQuery(CustomQuery customQuery, EntityKeyMetadata[] metadatas) {
        throw new UnsupportedOperationException("Native queries not suported for Neo4j");
    }
}

