/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jTupleSnapshot;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.RowKey;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public final class Neo4jAssociationSnapshot
implements AssociationSnapshot {
    private final Node ownerNode;
    private final RelationshipType relationshipType;
    private final AssociationKey associationKey;

    public Neo4jAssociationSnapshot(Node ownerNode, RelationshipType type, AssociationKey associationKey) {
        this.ownerNode = ownerNode;
        this.relationshipType = type;
        this.associationKey = associationKey;
    }

    public Tuple get(RowKey rowKey) {
        for (Relationship relationship : this.relationships()) {
            if (!this.matches(rowKey, (PropertyContainer)relationship)) continue;
            return new Tuple((TupleSnapshot)new Neo4jTupleSnapshot((PropertyContainer)relationship.getEndNode()));
        }
        return null;
    }

    public boolean containsKey(RowKey rowKey) {
        Iterator<Relationship> i$ = this.relationships().iterator();
        if (i$.hasNext()) {
            Relationship relationship = i$.next();
            return this.matches(rowKey, (PropertyContainer)relationship);
        }
        return false;
    }

    private boolean matches(RowKey key, PropertyContainer container) {
        for (int i = 0; i < key.getColumnNames().length; ++i) {
            String column = key.getColumnNames()[i];
            if (container.hasProperty(column) && key.getColumnValues()[i].equals(container.getProperty(column))) continue;
            return false;
        }
        return true;
    }

    public int size() {
        int count = 0;
        for (Relationship relationship : this.relationships()) {
            ++count;
        }
        return count;
    }

    private Iterable<Relationship> relationships() {
        return this.ownerNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{this.relationshipType});
    }

    public Set<RowKey> getRowKeys() {
        HashSet<RowKey> rowKeys = new HashSet<RowKey>();
        for (Relationship relationship : this.relationships()) {
            rowKeys.add(this.convert((PropertyContainer)relationship));
        }
        return rowKeys;
    }

    private RowKey convert(PropertyContainer container) {
        String[] columnNames = this.associationKey.getRowKeyColumnNames();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (String column : columnNames) {
            columns.add(column);
            values.add(container.getProperty(column));
        }
        return new RowKey(this.associationKey.getTable(), columns.toArray(new String[columns.size()]), values.toArray(new Object[values.size()]));
    }
}

