/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.impl;

import java.util.Map;
import org.hibernate.ogm.grid.RowKey;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.UniqueFactory;

public class Neo4jSequenceGenerator {
    private static final String ID_SEQUENCE_PROPERTY = "id_sequence_ogm";
    private static final String VALUE_SEQUENCE_PROPERTY = "value_sequence_ogm";
    private final GraphDatabaseService neo4jDb;
    private final String sequenceIndexName;

    public Neo4jSequenceGenerator(GraphDatabaseService neo4jDb, String indexName) {
        this.neo4jDb = neo4jDb;
        this.sequenceIndexName = indexName;
    }

    public int nextValue(RowKey rowKey, int increment, int initialValue) {
        Node sequenceNode = this.getOrCreateSequence(rowKey, initialValue);
        return this.updateSequence(sequenceNode, increment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getOrCreateSequence(RowKey key, int initialValue) {
        Transaction tx = this.neo4jDb.beginTx();
        try {
            UniqueFactory<Node> factory = this.nodeFactory(initialValue);
            Node sequenceNode = (Node)factory.getOrCreate(ID_SEQUENCE_PROPERTY, this.generateId(key));
            tx.success();
            Node node = sequenceNode;
            return node;
        }
        finally {
            tx.finish();
        }
    }

    private Object generateId(RowKey key) {
        StringBuilder builder = new StringBuilder(key.getTable());
        for (int i = 0; i < key.getColumnNames().length; ++i) {
            builder.append(key.getColumnNames()[i]);
            builder.append(key.getColumnValues()[i]);
        }
        return builder.toString();
    }

    private UniqueFactory<Node> nodeFactory(final int initialValue) {
        UniqueFactory.UniqueNodeFactory factory = new UniqueFactory.UniqueNodeFactory(this.neo4jDb, this.sequenceIndexName){

            protected void initialize(Node created, Map<String, Object> properties) {
                created.setProperty(Neo4jSequenceGenerator.ID_SEQUENCE_PROPERTY, properties.get(Neo4jSequenceGenerator.ID_SEQUENCE_PROPERTY));
                created.setProperty(Neo4jSequenceGenerator.VALUE_SEQUENCE_PROPERTY, (Object)initialValue);
            }
        };
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateSequence(Node sequence, int increment) {
        Transaction tx = this.neo4jDb.beginTx();
        Lock lock = null;
        try {
            lock = tx.acquireWriteLock((PropertyContainer)sequence);
            int nextValue = this.updateSequenceValue(sequence, increment);
            tx.success();
            lock.release();
            int n = nextValue;
            return n;
        }
        finally {
            tx.finish();
        }
    }

    private int updateSequenceValue(Node sequence, int increment) {
        int currentValue = (Integer)sequence.getProperty(VALUE_SEQUENCE_PROPERTY);
        int updatedValue = currentValue + increment;
        sequence.setProperty(VALUE_SEQUENCE_PROPERTY, (Object)updatedValue);
        return currentValue;
    }
}

