/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.grid.RowKey;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;

public class Neo4jSequenceGenerator {
    public static final String SEQUENCE_NAME_PROPERTY = "sequence_name";
    private static final Log log = LoggerFactory.getLogger();
    private static final int MAX_GENERATION_ATTEMPT = 5;
    private final ConcurrentMap<RowKey, String> queryCache = new ConcurrentHashMap<RowKey, String>();
    private final GraphDatabaseService neo4jDb;
    private final ExecutionEngine engine;

    public Neo4jSequenceGenerator(GraphDatabaseService neo4jDb) {
        this.neo4jDb = neo4jDb;
        this.engine = new ExecutionEngine(neo4jDb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUniqueConstraint(Set<String> generatorsKey) {
        Transaction tx = null;
        try {
            tx = this.neo4jDb.beginTx();
            for (String generatorKey : generatorsKey) {
                Label label = DynamicLabel.label((String)generatorKey);
                if (!this.isMissingUniqueConstraint(this.neo4jDb, label, SEQUENCE_NAME_PROPERTY)) continue;
                this.neo4jDb.schema().constraintFor(label).assertPropertyIsUnique(SEQUENCE_NAME_PROPERTY).create();
            }
            tx.success();
        }
        finally {
            tx.close();
        }
    }

    private boolean isMissingUniqueConstraint(GraphDatabaseService neo4jDb, Label sequenceLabel, String segmentName) {
        Iterable constraints = neo4jDb.schema().getConstraints(sequenceLabel);
        for (ConstraintDefinition constraint : constraints) {
            if (!constraint.isConstraintType(ConstraintType.UNIQUENESS)) continue;
            for (String property : constraint.getPropertyKeys()) {
                if (!segmentName.equals(property)) continue;
                return false;
            }
        }
        return true;
    }

    public int nextValue(RowKey rowKey, int increment, int initialValue) {
        int number = 0;
        while (number++ < 5) {
            try {
                return this.sequence(rowKey, increment, initialValue);
            }
            catch (Exception e) {
                log.errorGeneratingSequence(this.sequenceName(rowKey), e);
            }
        }
        throw log.cannotGenerateSequence(this.sequenceName(rowKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sequence(RowKey rowKey, int increment, int initialValue) {
        Transaction tx = this.neo4jDb.beginTx();
        Lock lock = null;
        try {
            Node sequence = this.getOrCreateSequence(rowKey, initialValue);
            lock = tx.acquireWriteLock((PropertyContainer)sequence);
            int nextValue = this.updateSequenceValue(this.sequenceName(rowKey), sequence, increment);
            tx.success();
            lock.release();
            int n = nextValue;
            return n;
        }
        finally {
            tx.close();
        }
    }

    private Node getOrCreateSequence(RowKey rowKey, int initialValue) {
        String updateSequenceQuery = this.getQuery(rowKey);
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("initialValue", initialValue);
        parameters.put("sequenceName", this.sequenceName(rowKey));
        ExecutionResult result = this.engine.execute(updateSequenceQuery, parameters);
        ResourceIterator column = result.columnAs("n");
        Node node = null;
        if (column.hasNext()) {
            node = (Node)column.next();
        }
        column.close();
        return node;
    }

    private String getQuery(RowKey rowKey) {
        String query = (String)this.queryCache.get(rowKey);
        if (query == null) {
            String sequenceName = this.sequenceName(rowKey);
            query = "MERGE (n:" + rowKey.getTable() + ":`" + sequenceName + "`) ON CREATE SET n.`" + sequenceName + "` = {initialValue}, n." + SEQUENCE_NAME_PROPERTY + " = {sequenceName} RETURN n";
            String cached = this.queryCache.putIfAbsent(rowKey, query);
            if (cached != null) {
                query = cached;
            }
        }
        return query;
    }

    private String sequenceName(RowKey key) {
        return (String)key.getColumnValues()[0];
    }

    private int updateSequenceValue(String sequenceName, Node sequence, int increment) {
        int currentValue = (Integer)sequence.getProperty(sequenceName);
        int updatedValue = currentValue + increment;
        sequence.setProperty(sequenceName, (Object)updatedValue);
        return currentValue;
    }
}

