/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.neo4j.graphdb.PropertyContainer;

public final class Neo4jTupleSnapshot
implements TupleSnapshot {
    private final PropertyContainer propertyContainer;

    public Neo4jTupleSnapshot(PropertyContainer propertyContainer) {
        this.propertyContainer = propertyContainer;
    }

    public Object get(String column) {
        if (this.propertyContainer.hasProperty(column)) {
            return this.propertyContainer.getProperty(column);
        }
        return null;
    }

    public boolean isEmpty() {
        return !this.propertyContainer.getPropertyKeys().iterator().hasNext();
    }

    public Set<String> getColumnNames() {
        HashSet<String> names = new HashSet<String>();
        for (String string : this.propertyContainer.getPropertyKeys()) {
            names.add(string);
        }
        return names;
    }

    public PropertyContainer getPropertyContainer() {
        return this.propertyContainer;
    }
}

