/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.CypherCRUD;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.MapsTupleIterator;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jAssociationSnapshot;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jTupleSnapshot;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jTypeConverter;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodesTupleIterator;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.query.impl.Neo4jParameterMetadataBuilder;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.AssociationOperation;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.datastore.spi.TupleOperation;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.AssociationKind;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.grid.Key;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.id.spi.NextValueRequest;
import org.hibernate.ogm.loader.nativeloader.BackendCustomQuery;
import org.hibernate.ogm.massindex.batchindexing.Consumer;
import org.hibernate.ogm.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.type.TypeTranslator;
import org.hibernate.ogm.util.ClosableIterator;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.Type;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;

public class Neo4jDialect
implements GridDialect,
ServiceRegistryAwareService {
    private final CypherCRUD neo4jCRUD;
    private final Neo4jSequenceGenerator neo4jSequenceGenerator;
    private ServiceRegistryImplementor serviceRegistry;

    public Neo4jDialect(Neo4jDatastoreProvider provider) {
        this.neo4jCRUD = new CypherCRUD(provider.getDataBase());
        this.neo4jSequenceGenerator = provider.getSequenceGenerator();
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        throw new UnsupportedOperationException("LockMode " + lockMode + " is not supported by the Neo4j GridDialect");
    }

    public Tuple getTuple(EntityKey key, TupleContext context) {
        Node entityNode = this.neo4jCRUD.findNode((Key)key, NodeLabel.ENTITY);
        if (entityNode == null) {
            return null;
        }
        return Neo4jDialect.createTuple(entityNode);
    }

    private static Tuple createTuple(Node entityNode) {
        return new Tuple((TupleSnapshot)new Neo4jTupleSnapshot((PropertyContainer)entityNode));
    }

    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        return Neo4jDialect.createTuple(this.neo4jCRUD.createNodeUnlessExists((Key)key, NodeLabel.ENTITY));
    }

    public void updateTuple(Tuple tuple, EntityKey key, TupleContext tupleContext) {
        Node node = (Node)((Neo4jTupleSnapshot)tuple.getSnapshot()).getPropertyContainer();
        this.applyTupleOperations((PropertyContainer)node, tuple.getOperations());
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        this.neo4jCRUD.remove(key);
    }

    public Tuple createTupleAssociation(AssociationKey associationKey, RowKey rowKey) {
        PropertyContainer property = this.createRelationshipToEntityOrToTempNode(associationKey, rowKey);
        return new Tuple((TupleSnapshot)new Neo4jTupleSnapshot(property));
    }

    private PropertyContainer createRelationshipToEntityOrToTempNode(AssociationKey associationKey, RowKey rowKey) {
        Node rowKeyNode = this.neo4jCRUD.findNode((Key)rowKey);
        if (rowKeyNode == null) {
            if (associationKey.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION) {
                return this.createNodeAndAddRelationship(associationKey, rowKey, NodeLabel.EMBEDDED);
            }
            return this.findEntityOrCreateTempNode(associationKey, rowKey);
        }
        if (rowKeyNode.hasLabel((Label)NodeLabel.ENTITY)) {
            return this.createRelationshipWithEntity(associationKey, rowKey, rowKeyNode);
        }
        if (rowKeyNode.hasLabel((Label)NodeLabel.TEMP_NODE)) {
            return this.deleteTempNodeAndCreateRelationshipWithEntity(associationKey, rowKey, rowKeyNode);
        }
        throw new AssertionFailure("Unrecognized row key node: " + rowKeyNode);
    }

    private PropertyContainer findEntityOrCreateTempNode(AssociationKey associationKey, RowKey rowKey) {
        EntityKey endNodeKey = this.endNodeKey(associationKey, rowKey);
        Node endNode = this.neo4jCRUD.findNode((Key)endNodeKey, NodeLabel.ENTITY);
        if (endNode == null) {
            return this.createNodeAndAddRelationship(associationKey, rowKey, NodeLabel.TEMP_NODE);
        }
        if (associationKey.getCollectionRole().equals(rowKey.getTable())) {
            return endNode;
        }
        return this.createRelationshipWithEntity(associationKey, rowKey, endNode);
    }

    private EntityKey endNodeKey(AssociationKey associationKey, RowKey rowKey) {
        ArrayList<String> keyColumnNames = new ArrayList<String>();
        ArrayList<Object> keyColumnValues = new ArrayList<Object>();
        String[] columnNames = rowKey.getColumnNames();
        int i = 0;
        for (String columnName : columnNames) {
            boolean entityColumn = true;
            for (String associationColumnName : associationKey.getColumnNames()) {
                if (!associationColumnName.equals(columnName)) continue;
                entityColumn = false;
                break;
            }
            if (entityColumn) {
                keyColumnNames.add(columnName);
                keyColumnValues.add(rowKey.getColumnValues()[i]);
            }
            ++i;
        }
        return new EntityKey(new EntityKeyMetadata(associationKey.getTable(), keyColumnNames.toArray(new String[keyColumnNames.size()])), keyColumnValues.toArray(new Object[keyColumnValues.size()]));
    }

    private Relationship deleteTempNodeAndCreateRelationshipWithEntity(AssociationKey associationKey, RowKey rowKey, Node tempNode) {
        Node ownerNode = this.neo4jCRUD.findNode((Key)associationKey.getEntityKey(), NodeLabel.ENTITY);
        Iterator iterator = tempNode.getRelationships(Direction.INCOMING).iterator();
        Relationship tempRelationship = (Relationship)iterator.next();
        Relationship relationship = ownerNode.createRelationshipTo(tempRelationship.getStartNode(), CypherCRUD.relationshipType(associationKey));
        this.applyColumnValues(rowKey, (PropertyContainer)relationship);
        tempRelationship.delete();
        tempNode.delete();
        return relationship;
    }

    private PropertyContainer createRelationshipWithEntity(AssociationKey associationKey, RowKey rowKey, Node node) {
        Node ownerNode = this.neo4jCRUD.findNode((Key)associationKey.getEntityKey(), NodeLabel.ENTITY);
        Relationship relationship = ownerNode.createRelationshipTo(node, CypherCRUD.relationshipType(associationKey));
        this.applyColumnValues(rowKey, (PropertyContainer)relationship);
        return relationship;
    }

    private PropertyContainer createNodeAndAddRelationship(AssociationKey associationKey, RowKey rowKey, NodeLabel label) {
        Node rowKeyNode = this.neo4jCRUD.createNodeUnlessExists((Key)rowKey, label);
        return this.createRelationshipWithEntity(associationKey, rowKey, rowKeyNode);
    }

    private void applyColumnValues(RowKey rowKey, PropertyContainer relationship) {
        for (int i = 0; i < rowKey.getColumnNames().length; ++i) {
            if (rowKey.getColumnValues()[i] == null) continue;
            relationship.setProperty(rowKey.getColumnNames()[i], rowKey.getColumnValues()[i]);
        }
    }

    public Association getAssociation(AssociationKey associationKey, AssociationContext associationContext) {
        Node entityNode = this.neo4jCRUD.findNode((Key)associationKey.getEntityKey(), NodeLabel.ENTITY);
        if (entityNode == null) {
            return null;
        }
        return new Association((AssociationSnapshot)new Neo4jAssociationSnapshot(entityNode, associationKey));
    }

    public Association createAssociation(AssociationKey associationKey, AssociationContext associationContext) {
        return new Association();
    }

    public void updateAssociation(Association association, AssociationKey key, AssociationContext associationContext) {
        for (AssociationOperation action : association.getOperations()) {
            this.applyAssociationOperation(key, action, associationContext);
        }
    }

    public boolean isStoredInEntityStructure(AssociationKey associationKey, AssociationContext associationContext) {
        return false;
    }

    public Number nextValue(NextValueRequest request) {
        return this.neo4jSequenceGenerator.nextValue(request.getKey(), request.getIncrement());
    }

    public boolean supportsSequences() {
        return true;
    }

    public GridType overrideType(Type type) {
        return Neo4jTypeConverter.INSTANCE.convert(type);
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (key != null) {
            this.neo4jCRUD.remove(key);
        }
    }

    private void applyAssociationOperation(AssociationKey key, AssociationOperation operation, AssociationContext associationContext) {
        switch (operation.getType()) {
            case CLEAR: {
                this.removeAssociation(key, associationContext);
                break;
            }
            case PUT: {
                this.putAssociationOperation(key, operation);
                break;
            }
            case PUT_NULL: {
                this.removeAssociationOperation(key, operation);
                break;
            }
            case REMOVE: {
                this.removeAssociationOperation(key, operation);
            }
        }
    }

    private void putAssociationOperation(AssociationKey associationKey, AssociationOperation action) {
        Relationship relationship = this.neo4jCRUD.findRelationship(associationKey, action.getKey());
        if (relationship != null) {
            this.applyTupleOperations((PropertyContainer)relationship, action.getValue().getOperations());
        }
    }

    private void removeAssociationOperation(AssociationKey associationKey, AssociationOperation action) {
        this.neo4jCRUD.remove(associationKey, action.getKey());
    }

    private void applyTupleOperations(PropertyContainer propertyContainer, Set<TupleOperation> operations) {
        for (TupleOperation operation : operations) {
            this.applyOperation(propertyContainer, operation);
        }
    }

    private void applyOperation(PropertyContainer node, TupleOperation operation) {
        switch (operation.getType()) {
            case PUT: {
                this.putTupleOperation(node, operation);
                break;
            }
            case PUT_NULL: {
                this.removeTupleOperation(node, operation);
                break;
            }
            case REMOVE: {
                this.removeTupleOperation(node, operation);
            }
        }
    }

    private void removeTupleOperation(PropertyContainer node, TupleOperation operation) {
        if (node.hasProperty(operation.getColumn())) {
            node.removeProperty(operation.getColumn());
        }
    }

    private void putTupleOperation(PropertyContainer node, TupleOperation operation) {
        node.setProperty(operation.getColumn(), operation.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachTuple(Consumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            ResourceIterator<Node> queryNodes = this.neo4jCRUD.findNodes(entityKeyMetadata.getTable());
            try {
                while (queryNodes.hasNext()) {
                    Node next = (Node)queryNodes.next();
                    Tuple tuple = Neo4jDialect.createTuple(next);
                    consumer.consume(tuple);
                }
            }
            finally {
                queryNodes.close();
            }
        }
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendCustomQuery customQuery, QueryParameters queryParameters) {
        Map<String, Object> parameters = this.getNamedParameterValuesConvertedByGridType(queryParameters);
        String nativeQuery = this.buildNativeQuery(customQuery, queryParameters);
        ExecutionResult result = this.neo4jCRUD.executeQuery(nativeQuery, parameters);
        if (customQuery.getSingleEntityKeyMetadataOrNull() != null) {
            return new NodesTupleIterator(result);
        }
        return new MapsTupleIterator(result);
    }

    private String buildNativeQuery(BackendCustomQuery customQuery, QueryParameters queryParameters) {
        StringBuilder nativeQuery = new StringBuilder(customQuery.getQueryString());
        this.applyFirstRow(queryParameters, nativeQuery);
        this.applyMaxRows(queryParameters, nativeQuery);
        return nativeQuery.toString();
    }

    private void applyFirstRow(QueryParameters queryParameters, StringBuilder nativeQuery) {
        Integer firstRow = queryParameters.getRowSelection().getFirstRow();
        if (firstRow != null) {
            CypherDSL.skip(nativeQuery, firstRow);
        }
    }

    private void applyMaxRows(QueryParameters queryParameters, StringBuilder nativeQuery) {
        Integer maxRows = queryParameters.getRowSelection().getMaxRows();
        if (maxRows != null) {
            CypherDSL.limit(nativeQuery, maxRows);
        }
    }

    private Map<String, Object> getNamedParameterValuesConvertedByGridType(QueryParameters queryParameters) {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>(queryParameters.getNamedParameters().size());
        Tuple dummy = new Tuple();
        TypeTranslator typeTranslator = (TypeTranslator)this.serviceRegistry.getService(TypeTranslator.class);
        for (Map.Entry parameter : queryParameters.getNamedParameters().entrySet()) {
            GridType gridType = typeTranslator.getType(((TypedValue)parameter.getValue()).getType());
            gridType.nullSafeSet(dummy, ((TypedValue)parameter.getValue()).getValue(), new String[]{(String)parameter.getKey()}, null);
            parameterValues.put((String)parameter.getKey(), dummy.get((String)parameter.getKey()));
        }
        return parameterValues;
    }

    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return new Neo4jParameterMetadataBuilder();
    }
}

