/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.AssociationKind;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.Key;
import org.hibernate.ogm.grid.RowKey;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;

public class CypherCRUD {
    private final ExecutionEngine engine;

    public CypherCRUD(GraphDatabaseService graphDb) {
        this.engine = new ExecutionEngine(graphDb);
    }

    public Relationship findRelationship(AssociationKey associationKey, RowKey rowKey) {
        EntityKey targetKey = rowKey.getEntityKey();
        EntityKey entityKey = associationKey.getEntityKey();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder query = new StringBuilder("MATCH");
        this.appendNodePattern("o", (Key)entityKey, parameters, query, NodeLabel.ENTITY);
        query.append(" - ");
        query.append(this.relationshipCypher(associationKey, rowKey, parameters));
        query.append(" - ");
        this.appendNodePattern("t", (Key)targetKey, parameters, query, new NodeLabel[0]);
        query.append(" RETURN r");
        ExecutionResult result = this.engine.execute(query.toString(), parameters);
        ResourceIterator column = result.columnAs("r");
        Relationship relationship = null;
        if (column.hasNext()) {
            relationship = (Relationship)column.next();
        }
        column.close();
        return relationship;
    }

    public Node findNode(Key key, NodeLabel ... labels) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(key.getColumnNames().length);
        StringBuilder query = new StringBuilder("MATCH");
        this.appendNodePattern(key, parameters, query, labels);
        query.append(" RETURN n");
        ExecutionResult result = this.engine.execute(query.toString(), parameters);
        ResourceIterator column = result.columnAs("n");
        Node node = null;
        if (column.hasNext()) {
            node = (Node)column.next();
        }
        column.close();
        return node;
    }

    public void remove(EntityKey entityKey) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(entityKey.getColumnNames().length);
        StringBuilder query = new StringBuilder("MATCH");
        this.appendNodePattern((Key)entityKey, parameters, query, NodeLabel.ENTITY);
        query.append(" OPTIONAL MATCH (n) - [r] - () DELETE r,n");
        this.engine.execute(query.toString(), parameters);
    }

    public ResourceIterator<Node> findNodes(String tableName) {
        String query = "MATCH (n:`" + tableName + "`) RETURN n";
        ExecutionResult result = this.engine.execute(query.toString());
        return result.columnAs("n");
    }

    public Node createNodeUnlessExists(Key key, NodeLabel label) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(key.getColumnNames().length);
        StringBuilder query = new StringBuilder("MERGE");
        this.appendNodePattern(key, parameters, query, label);
        query.append(" RETURN n");
        ExecutionResult result = this.engine.execute(query.toString(), parameters);
        ResourceIterator column = result.columnAs("n");
        Node node = null;
        if (column.hasNext()) {
            node = (Node)column.next();
        }
        column.close();
        return node;
    }

    public Node createNode(Key key, NodeLabel label) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(key.getColumnNames().length);
        StringBuilder query = new StringBuilder("CREATE");
        this.appendNodePattern(key, parameters, query, label);
        query.append(" RETURN n");
        ExecutionResult result = this.engine.execute(query.toString(), parameters);
        ResourceIterator column = result.columnAs("n");
        Node node = null;
        if (column.hasNext()) {
            node = (Node)column.next();
        }
        column.close();
        return node;
    }

    private void appendNodePattern(Key key, Map<String, Object> parameters, StringBuilder query, NodeLabel ... labels) {
        this.appendNodePattern("n", key, parameters, query, labels);
    }

    private void appendNodePattern(String alias, Key key, Map<String, Object> parameters, StringBuilder query, NodeLabel ... labels) {
        query.append("(");
        CypherDSL.identifier(query, alias);
        query.append(":");
        CypherDSL.identifier(query, CypherCRUD.nodeLabel(key).name());
        if (labels != null) {
            for (NodeLabel label : labels) {
                query.append(":");
                CypherDSL.identifier(query, label.name());
            }
        }
        if (key.getColumnNames().length > 0) {
            query.append(" {");
            int counter = parameters.size();
            int columnsLength = key.getColumnNames().length;
            for (int i = 0; i < columnsLength; ++i) {
                if (key.getColumnValues()[i] == null) continue;
                CypherDSL.identifier(query, key.getColumnNames()[i]);
                query.append(": {");
                query.append(counter);
                query.append("}");
                parameters.put(String.valueOf(counter), key.getColumnValues()[i]);
                query.append(", ");
                ++counter;
            }
            if (query.toString().endsWith(", ")) {
                query.replace(query.length() - 2, query.length(), "");
            }
            query.append("}");
        }
        query.append(")");
    }

    public static Label nodeLabel(Key key) {
        return DynamicLabel.label((String)key.getTable());
    }

    private String relationshipCypher(AssociationKey associationKey, RowKey rowKey, Map<String, Object> parameters) {
        String[] indexColumnNames = associationKey.getMetadata().getRowKeyIndexColumnNames();
        Object[] indexColumnValues = new Object[indexColumnNames.length];
        for (int i = 0; i < indexColumnNames.length; ++i) {
            for (int j = 0; j < rowKey.getColumnNames().length; ++j) {
                if (!indexColumnNames[i].equals(rowKey.getColumnNames()[j])) continue;
                indexColumnValues[i] = rowKey.getColumnValues()[j];
            }
        }
        String table = rowKey.getTable();
        StringBuilder relationshipBuilder = new StringBuilder("[r");
        if (associationKey != null) {
            relationshipBuilder.append(":");
            CypherDSL.identifier(relationshipBuilder, CypherCRUD.relationshipType(associationKey).name());
        }
        this.appendRelationshipProperties(parameters, indexColumnNames, indexColumnValues, table, relationshipBuilder);
        relationshipBuilder.append("]");
        return relationshipBuilder.toString();
    }

    private void appendRelationshipProperties(Map<String, Object> parameters, String[] columnNames, Object[] columnValues, String table, StringBuilder relationshipBuilder) {
        if (columnNames.length > 0) {
            int counter = parameters.size();
            relationshipBuilder.append(" { ");
            for (int i = 0; i < columnNames.length; ++i) {
                if (columnValues[i] == null) continue;
                CypherDSL.identifier(relationshipBuilder, columnNames[i]);
                relationshipBuilder.append(" : {");
                relationshipBuilder.append(counter);
                relationshipBuilder.append("}");
                parameters.put(String.valueOf(counter), columnValues[i]);
                if (i < columnNames.length - 1) {
                    relationshipBuilder.append(",");
                }
                ++counter;
            }
            relationshipBuilder.append("}");
        }
    }

    public static RelationshipType relationshipType(AssociationKey associationKey) {
        return DynamicRelationshipType.withName((String)associationKey.getTable());
    }

    public void remove(AssociationKey associationKey) {
        HashMap parameters = new HashMap();
        StringBuilder query = new StringBuilder();
        query.append("MATCH (n:");
        query.append(CypherCRUD.nodeLabel((Key)associationKey.getEntityKey()).name());
        query.append(") - ");
        query.append("[r");
        query.append(":");
        query.append(CypherCRUD.relationshipType(associationKey).name());
        query.append("]");
        if (associationKey.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION) {
            query.append(" - (x:");
            query.append(NodeLabel.EMBEDDED.name());
            query.append(") DELETE r, x");
        } else {
            query.append(" - () DELETE r");
        }
        this.engine.execute(query.toString(), parameters);
    }

    public void remove(AssociationKey associationKey, RowKey rowKey) {
        EntityKey targetKey = rowKey.getEntityKey();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder query = new StringBuilder("MATCH ");
        this.appendNodePattern((Key)associationKey.getEntityKey(), parameters, query, NodeLabel.ENTITY);
        query.append(" - ");
        query.append(this.relationshipCypher(associationKey, rowKey, parameters));
        query.append(" - ");
        if (associationKey.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION) {
            this.appendNodePattern("x", (Key)targetKey, parameters, query, NodeLabel.EMBEDDED);
            query.append(" DELETE r, x");
        } else {
            this.appendNodePattern("x", (Key)targetKey, parameters, query, NodeLabel.ENTITY);
            query.append(" DELETE r");
        }
        this.engine.execute(query.toString(), parameters);
    }

    public ExecutionResult executeQuery(String query, Map<String, Object> parameters) {
        return this.engine.execute(query, parameters);
    }
}

