/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.CypherCRUD;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.Key;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class Neo4jTupleAssociationSnapshot
implements TupleSnapshot {
    private final Map<String, Object> properties;

    public Neo4jTupleAssociationSnapshot(Relationship relationship, AssociationKey associationKey) {
        this.properties = this.collectProperties(relationship, associationKey);
    }

    private Map<String, Object> collectProperties(Relationship relationship, AssociationKey associationKey) {
        int i;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String[] rowKeyColumnNames = associationKey.getMetadata().getRowKeyColumnNames();
        Node ownerNode = Neo4jTupleAssociationSnapshot.ownerNode(associationKey, relationship);
        Node targetNode = relationship.getOtherNode(ownerNode);
        for (int i2 = 0; i2 < rowKeyColumnNames.length; ++i2) {
            if (!relationship.hasProperty(rowKeyColumnNames[i2])) continue;
            properties.put(rowKeyColumnNames[i2], relationship.getProperty(rowKeyColumnNames[i2]));
        }
        String[] targetColumnNames = associationKey.getMetadata().getRowKeyEntityKeyMetadata().getColumnNames();
        String[] associationTargetColumnNames = associationKey.getMetadata().getRowKeyTargetAssociationKeyColumnNames();
        for (i = 0; i < associationTargetColumnNames.length; ++i) {
            if (!targetNode.hasProperty(targetColumnNames[i])) continue;
            properties.put(associationTargetColumnNames[i], targetNode.getProperty(targetColumnNames[i]));
        }
        for (i = 0; i < associationKey.getColumnNames().length; ++i) {
            if (!ownerNode.hasProperty(associationKey.getEntityKey().getColumnNames()[i])) continue;
            properties.put(associationKey.getColumnNames()[i], ownerNode.getProperty(associationKey.getEntityKey().getColumnNames()[i]));
        }
        return properties;
    }

    private static Node ownerNode(AssociationKey associationKey, Relationship relationship) {
        if (relationship.getStartNode().hasLabel(CypherCRUD.nodeLabel((Key)associationKey.getEntityKey()))) {
            return relationship.getStartNode();
        }
        return relationship.getEndNode();
    }

    public Object get(String column) {
        return this.properties.get(column);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Set<String> getColumnNames() {
        return this.properties.keySet();
    }
}

