/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.neo4j.graphdb.Node;

public final class Neo4jTupleSnapshot
implements TupleSnapshot {
    private final Node node;

    public Neo4jTupleSnapshot(Node node) {
        this.node = node;
    }

    public Object get(String column) {
        if (this.node.hasProperty(column)) {
            return this.node.getProperty(column);
        }
        return null;
    }

    public boolean isEmpty() {
        return !this.node.getPropertyKeys().iterator().hasNext();
    }

    public Set<String> getColumnNames() {
        HashSet<String> names = new HashSet<String>();
        for (String string : this.node.getPropertyKeys()) {
            names.add(string);
        }
        return names;
    }

    public Node getNode() {
        return this.node;
    }
}

