/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jPropertyHelper;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParameter;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParsingResult;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryResolverDelegate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.OrderByClause;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jPredicateFactory;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.persister.OgmEntityPersister;

public class Neo4jQueryRendererDelegate
extends SingleEntityQueryRendererDelegate<StringBuilder, Neo4jQueryParsingResult> {
    private final Neo4jPropertyHelper propertyHelper;
    private final Neo4jQueryResolverDelegate resolverDelegate;
    private final SessionFactoryImplementor sessionFactory;
    private List<OrderByClause> orderByExpressions;

    public Neo4jQueryRendererDelegate(SessionFactoryImplementor sessionFactory, Neo4jQueryResolverDelegate resolverDelegate, EntityNamesResolver entityNames, Neo4jPropertyHelper propertyHelper, Map<String, Object> namedParameters) {
        super(entityNames, Neo4jQueryRendererDelegate.singleEntityQueryBuilder(propertyHelper, resolverDelegate), namedParameters);
        this.sessionFactory = sessionFactory;
        this.resolverDelegate = resolverDelegate;
        this.propertyHelper = propertyHelper;
    }

    private static SingleEntityQueryBuilder<StringBuilder> singleEntityQueryBuilder(Neo4jPropertyHelper propertyHelper, Neo4jQueryResolverDelegate resolverDelegate) {
        return SingleEntityQueryBuilder.getInstance((PredicateFactory)new Neo4jPredicateFactory(propertyHelper, resolverDelegate), (PropertyHelper)propertyHelper);
    }

    private EntityKeyMetadata getKeyMetaData(Class<?> entityType) {
        OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(entityType.getName());
        return new EntityKeyMetadata(persister.getTableName(), persister.getRootTableIdentifierColumnNames());
    }

    public Neo4jQueryParsingResult getResult() {
        String targetAlias = this.resolverDelegate.findAliasForType(this.targetTypeName);
        String label = this.getKeyMetaData(this.targetType).getTable();
        StringBuilder queryBuilder = new StringBuilder();
        this.match(queryBuilder, targetAlias, label);
        this.where(queryBuilder);
        this.returns(queryBuilder, targetAlias);
        this.orderBy(queryBuilder);
        return new Neo4jQueryParsingResult(this.targetType, this.projections, queryBuilder.toString());
    }

    private void match(StringBuilder queryBuilder, String targetAlias, String label) {
        queryBuilder.append("MATCH ");
        CypherDSL.node(queryBuilder, targetAlias, label);
    }

    private void where(StringBuilder queryBuilder) {
        StringBuilder whereCondition = (StringBuilder)this.builder.build();
        if (whereCondition != null) {
            queryBuilder.append(" WHERE ");
            queryBuilder.append((CharSequence)whereCondition);
        }
    }

    private void orderBy(StringBuilder queryBuilder) {
        if (this.orderByExpressions != null && !this.orderByExpressions.isEmpty()) {
            queryBuilder.append(" ORDER BY ");
            int counter = 1;
            for (OrderByClause orderBy : this.orderByExpressions) {
                orderBy.asString(queryBuilder);
                if (counter++ >= this.orderByExpressions.size()) continue;
                queryBuilder.append(", ");
            }
        }
    }

    private void returns(StringBuilder builder, String targetAlias) {
        builder.append(" RETURN ");
        if (this.projections.isEmpty()) {
            CypherDSL.identifier(builder, targetAlias);
        } else {
            int counter = 1;
            for (String projection : this.projections) {
                CypherDSL.identifier(builder, targetAlias, projection);
                CypherDSL.as(builder, projection);
                if (counter++ >= this.projections.size()) continue;
                builder.append(", ");
            }
        }
    }

    public void setPropertyPath(PropertyPath propertyPath) {
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_SELECT) {
            if (propertyPath.getNodes().size() == 1 && !propertyPath.getLastNode().isAlias() || propertyPath.getNodes().size() == 2 && ((PathedPropertyReferenceSource)propertyPath.getNodes().get(0)).isAlias()) {
                this.projections.add(this.propertyHelper.getColumnName(this.targetTypeName, propertyPath.asStringPathWithoutAlias()));
            } else if (propertyPath.getNodes().size() != 1) {
                throw new UnsupportedOperationException("Selecting nested/associated properties not yet implemented.");
            }
        } else {
            this.propertyPath = propertyPath;
        }
    }

    protected void addSortField(PropertyPath propertyPath, String collateName, boolean isAscending) {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = new ArrayList<OrderByClause>();
        }
        String columnName = this.propertyHelper.getColumnName(this.targetType, propertyPath.asStringPathWithoutAlias());
        String alias = this.resolverDelegate.findAliasForType(this.targetTypeName);
        OrderByClause order = new OrderByClause(alias, columnName, isAscending);
        this.orderByExpressions.add(order);
    }

    public void predicateLess(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS);
    }

    public void predicateLessOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS_OR_EQUAL);
    }

    public void predicateEquals(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
    }

    public void predicateNotEquals(String comparativePredicate) {
        this.builder.pushNotPredicate();
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
        this.builder.popBooleanPredicate();
    }

    public void predicateGreaterOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER_OR_EQUAL);
    }

    public void predicateGreater(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER);
    }

    private void addComparisonPredicate(String comparativePredicate, ComparisonPredicate.Type comparisonType) {
        Object comparisonValue = this.fromNamedQuery(comparativePredicate);
        this.builder.addComparisonPredicate(this.propertyPath.getNodeNamesWithoutAlias(), comparisonType, comparisonValue);
    }

    public void predicateIn(List<String> list) {
        List<Object> values = this.fromNamedQuery(list);
        this.builder.addInPredicate(this.propertyPath.getNodeNamesWithoutAlias(), values);
    }

    public void predicateBetween(String lower, String upper) {
        Object lowerComparisonValue = this.fromNamedQuery(lower);
        Object upperComparisonValue = this.fromNamedQuery(upper);
        this.builder.addRangePredicate(this.propertyPath.getNodeNamesWithoutAlias(), lowerComparisonValue, upperComparisonValue);
    }

    public void predicateLike(String patternValue, Character escapeCharacter) {
        Object pattern = this.fromNamedQuery(patternValue);
        this.builder.addLikePredicate(this.propertyPath.getNodeNamesWithoutAlias(), (String)pattern, escapeCharacter);
    }

    public void predicateIsNull() {
        this.builder.addIsNullPredicate(this.propertyPath.getNodeNamesWithoutAlias());
    }

    private Object fromNamedQuery(String comparativePredicate) {
        if (comparativePredicate.startsWith(":")) {
            return new Neo4jQueryParameter(comparativePredicate.substring(1));
        }
        return comparativePredicate;
    }

    private List<Object> fromNamedQuery(List<String> list) {
        ArrayList<Object> elements = new ArrayList<Object>(list.size());
        for (String string : list) {
            elements.add(this.fromNamedQuery(string));
        }
        return elements;
    }
}

