/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.QueriesBase;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

public class Neo4jEntityQueries
extends QueriesBase {
    private static final int CACHE_CAPACITY = 1000;
    private static final int CACHE_CONCURRENCY_LEVEL = 20;
    private static final Pattern EMBEDDED_FIELDNAME_SEPARATOR = Pattern.compile("\\.");
    private final BoundedConcurrentHashMap<String, String> updateEmbeddedPropertyQueryCache = new BoundedConcurrentHashMap(1000, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    private final String createEmbeddedNodeQuery;
    private final String findEntityQuery;
    private final String findEntitiesQuery;
    private final String createEntityQuery;
    private final String removeEntityQuery;
    private final String updateEmbeddedNodeQuery;
    private final String removeEmbdeddedElementQuery;

    public Neo4jEntityQueries(EntityKeyMetadata entityKeyMetadata) {
        this.createEmbeddedNodeQuery = Neo4jEntityQueries.initCreateEmbeddedNodeQuery(entityKeyMetadata);
        this.findEntityQuery = Neo4jEntityQueries.initFindEntityQuery(entityKeyMetadata);
        this.findEntitiesQuery = Neo4jEntityQueries.initFindEntitiesQuery(entityKeyMetadata);
        this.createEntityQuery = Neo4jEntityQueries.initCreateEntityQuery(entityKeyMetadata);
        this.removeEntityQuery = Neo4jEntityQueries.initRemoveEntityQuery(entityKeyMetadata);
        this.updateEmbeddedNodeQuery = Neo4jEntityQueries.initUpdateEmbeddedNodeQuery(entityKeyMetadata);
        this.removeEmbdeddedElementQuery = Neo4jEntityQueries.initRemoveEmbdeddedElementQuery(entityKeyMetadata);
    }

    private static String initCreateEmbeddedNodeQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("CREATE ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.EMBEDDED);
        queryBuilder.append(":");
        Neo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        Neo4jEntityQueries.appendProperties(entityKeyMetadata, queryBuilder);
        queryBuilder.append(") RETURN n");
        return queryBuilder.toString();
    }

    private static String initUpdateEmbeddedNodeQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("MERGE ");
        queryBuilder.append("(owner:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        Neo4jEntityQueries.appendProperties(entityKeyMetadata, queryBuilder);
        queryBuilder.append(") MERGE (owner)");
        return queryBuilder.toString();
    }

    private static void appendRelationshipType(StringBuilder queryBuilder, String relationshipType) {
        CypherDSL.escapeIdentifier(queryBuilder, relationshipType);
    }

    private static String initFindEntityQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        Neo4jEntityQueries.appendProperties(entityKeyMetadata, queryBuilder);
        queryBuilder.append(")");
        queryBuilder.append(" RETURN n");
        return queryBuilder.toString();
    }

    private static String initFindEntitiesQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        queryBuilder.append(") RETURN n");
        return queryBuilder.toString();
    }

    private static String initCreateEntityQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("CREATE ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        Neo4jEntityQueries.appendProperties(entityKeyMetadata, queryBuilder);
        queryBuilder.append(")");
        queryBuilder.append(" RETURN n");
        return queryBuilder.toString();
    }

    private static String initRemoveEmbdeddedElementQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        Neo4jEntityQueries.appendProperties(entityKeyMetadata, queryBuilder);
        queryBuilder.append(")");
        queryBuilder.append(" --> (e:EMBEDDED)");
        queryBuilder.append(" WITH e ");
        queryBuilder.append(" MATCH path=(e) -[*0..]-> (:EMBEDDED) ");
        queryBuilder.append(" FOREACH ( r IN relationships(path) | DELETE r )");
        queryBuilder.append(" FOREACH ( e IN nodes(path) | DELETE e )");
        return queryBuilder.toString();
    }

    private static String initRemoveEntityQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        Neo4jEntityQueries.appendProperties(entityKeyMetadata, queryBuilder);
        queryBuilder.append(")");
        queryBuilder.append(" OPTIONAL MATCH (n) - [r] - ()");
        queryBuilder.append(" DELETE n, r");
        return queryBuilder.toString();
    }

    public Node createEmbedded(ExecutionEngine executionEngine, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        ExecutionResult result = executionEngine.execute(this.createEmbeddedNodeQuery, params);
        return (Node)this.singleResult(result);
    }

    public Node findEntity(ExecutionEngine executionEngine, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        ExecutionResult result = executionEngine.execute(this.findEntityQuery, params);
        return (Node)this.singleResult(result);
    }

    public Node insertEntity(ExecutionEngine executionEngine, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        ExecutionResult result = executionEngine.execute(this.createEntityQuery, params);
        return (Node)this.singleResult(result);
    }

    public ResourceIterator<Node> findEntities(ExecutionEngine executionEngine) {
        ExecutionResult result = executionEngine.execute(this.findEntitiesQuery);
        return result.columnAs("n");
    }

    public void removeEntity(ExecutionEngine executionEngine, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        executionEngine.execute(this.removeEmbdeddedElementQuery, params);
        executionEngine.execute(this.removeEntityQuery, params);
    }

    public void updateEmbeddedColumn(ExecutionEngine executionEngine, Object[] keyValues, String embeddedColumn, Object value) {
        String cached;
        String query = (String)this.updateEmbeddedPropertyQueryCache.get((Object)embeddedColumn);
        if (query == null && (cached = (String)this.updateEmbeddedPropertyQueryCache.putIfAbsent((Object)embeddedColumn, (Object)(query = this.initUpdateEmbeddedColumnQuery(keyValues, embeddedColumn)))) != null) {
            query = cached;
        }
        Map<String, Object> params = this.params(ArrayHelper.concat((Object[])keyValues, (Object[])new Object[]{value, value}));
        executionEngine.execute(query, params);
    }

    private String initUpdateEmbeddedColumnQuery(Object[] keyValues, String embeddedColumn) {
        StringBuilder queryBuilder = new StringBuilder(this.updateEmbeddedNodeQuery);
        String[] columns = Neo4jEntityQueries.appendEmbeddedNodes(embeddedColumn, queryBuilder);
        queryBuilder.append(" ON CREATE SET e.");
        CypherDSL.escapeIdentifier(queryBuilder, columns[columns.length - 1]);
        queryBuilder.append(" = {");
        queryBuilder.append(keyValues.length);
        queryBuilder.append("}");
        queryBuilder.append(" ON MATCH SET e.");
        CypherDSL.escapeIdentifier(queryBuilder, columns[columns.length - 1]);
        queryBuilder.append(" = {");
        queryBuilder.append(keyValues.length + 1);
        queryBuilder.append("}");
        return queryBuilder.toString();
    }

    private static String[] appendEmbeddedNodes(String embeddedColumn, StringBuilder queryBuilder) {
        String[] columns = EMBEDDED_FIELDNAME_SEPARATOR.split(embeddedColumn);
        for (int i = 0; i < columns.length - 1; ++i) {
            queryBuilder.append(" - [:");
            Neo4jEntityQueries.appendRelationshipType(queryBuilder, columns[i]);
            queryBuilder.append("] ->");
            if (i >= columns.length - 2) continue;
            queryBuilder.append(" (e");
            queryBuilder.append(i);
            queryBuilder.append(":");
            queryBuilder.append((Object)NodeLabel.EMBEDDED);
            queryBuilder.append(") MERGE (e");
            queryBuilder.append(i);
            queryBuilder.append(")");
        }
        queryBuilder.append(" (e:");
        queryBuilder.append((Object)NodeLabel.EMBEDDED);
        queryBuilder.append(")");
        return columns;
    }
}

