/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class Neo4jTupleAssociationSnapshot
implements TupleSnapshot {
    private final Map<String, Object> properties;

    public Neo4jTupleAssociationSnapshot(Relationship relationship, AssociationKey associationKey, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        this.properties = Neo4jTupleAssociationSnapshot.collectProperties(relationship, associationKey, associatedEntityKeyMetadata);
    }

    private static Map<String, Object> collectProperties(Relationship relationship, AssociationKey associationKey, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String[] rowKeyColumnNames = associationKey.getMetadata().getRowKeyColumnNames();
        Node ownerNode = Neo4jTupleAssociationSnapshot.ownerNode(associationKey, relationship);
        Node targetNode = relationship.getOtherNode(ownerNode);
        for (int i = 0; i < rowKeyColumnNames.length; ++i) {
            if (!relationship.hasProperty(rowKeyColumnNames[i])) continue;
            properties.put(rowKeyColumnNames[i], relationship.getProperty(rowKeyColumnNames[i]));
        }
        for (String associationColumn : associatedEntityKeyMetadata.getAssociationKeyColumns()) {
            String targetColumnName = associatedEntityKeyMetadata.getCorrespondingEntityKeyColumn(associationColumn);
            if (!targetNode.hasProperty(targetColumnName)) continue;
            properties.put(associationColumn, targetNode.getProperty(targetColumnName));
        }
        for (int i = 0; i < associationKey.getColumnNames().length; ++i) {
            if (!ownerNode.hasProperty(associationKey.getEntityKey().getColumnNames()[i])) continue;
            properties.put(associationKey.getColumnNames()[i], ownerNode.getProperty(associationKey.getEntityKey().getColumnNames()[i]));
        }
        return properties;
    }

    private static Node ownerNode(AssociationKey associationKey, Relationship relationship) {
        if (relationship.getStartNode().hasLabel(DynamicLabel.label((String)associationKey.getEntityKey().getTable()))) {
            return relationship.getStartNode();
        }
        return relationship.getEndNode();
    }

    public Object get(String column) {
        return this.properties.get(column);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Set<String> getColumnNames() {
        return this.properties.keySet();
    }
}

