/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.AliasResolver;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.EmbeddedAliasTree;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jPropertyHelper;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParameter;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParsingResult;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.OrderByClause;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jPredicateFactory;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;

public class Neo4jQueryRendererDelegate
extends SingleEntityQueryRendererDelegate<StringBuilder, Neo4jQueryParsingResult> {
    private final Neo4jPropertyHelper propertyHelper;
    private final SessionFactoryImplementor sessionFactory;
    private List<OrderByClause> orderByExpressions;
    private final List<String> embeddedPropertyProjection;
    private final AliasResolver embeddedAliasResolver;

    public Neo4jQueryRendererDelegate(SessionFactoryImplementor sessionFactory, AliasResolver embeddedAliasResolver, EntityNamesResolver entityNames, Neo4jPropertyHelper propertyHelper, Map<String, Object> namedParameters) {
        super(entityNames, Neo4jQueryRendererDelegate.singleEntityQueryBuilder(propertyHelper, embeddedAliasResolver), namedParameters);
        this.sessionFactory = sessionFactory;
        this.embeddedAliasResolver = embeddedAliasResolver;
        this.propertyHelper = propertyHelper;
        this.embeddedPropertyProjection = new ArrayList<String>();
    }

    private static SingleEntityQueryBuilder<StringBuilder> singleEntityQueryBuilder(Neo4jPropertyHelper propertyHelper, AliasResolver embeddedAliasResolver) {
        return SingleEntityQueryBuilder.getInstance((PredicateFactory)new Neo4jPredicateFactory(propertyHelper, embeddedAliasResolver), (PropertyHelper)propertyHelper);
    }

    private EntityKeyMetadata getKeyMetaData(Class<?> entityType) {
        OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(entityType.getName());
        return persister.getEntityKeyMetadata();
    }

    public Neo4jQueryParsingResult getResult() {
        String targetAlias = this.embeddedAliasResolver.findAliasForType(this.targetTypeName);
        String label = this.getKeyMetaData(this.targetType).getTable();
        StringBuilder queryBuilder = new StringBuilder();
        this.match(queryBuilder, targetAlias, label);
        this.optionalMatch(queryBuilder, targetAlias);
        this.where(queryBuilder);
        this.returns(queryBuilder, targetAlias);
        this.orderBy(queryBuilder);
        return new Neo4jQueryParsingResult(this.targetType, this.projections, queryBuilder.toString());
    }

    private void match(StringBuilder queryBuilder, String targetAlias, String label) {
        queryBuilder.append("MATCH ");
        CypherDSL.node(queryBuilder, targetAlias, label);
    }

    private void optionalMatch(StringBuilder queryBuilder, String targetAlias) {
        EmbeddedAliasTree node = this.embeddedAliasResolver.getAliasTree(targetAlias);
        if (node != null) {
            for (EmbeddedAliasTree child : node.getChildren()) {
                StringBuilder optionalMatch = new StringBuilder(" OPTIONAL MATCH ");
                CypherDSL.node(optionalMatch, targetAlias, new String[0]);
                CypherDSL.relationship(optionalMatch, child.getName());
                CypherDSL.node(optionalMatch, child.getAlias(), NodeLabel.EMBEDDED.name());
                this.appendEmbedded(queryBuilder, optionalMatch.toString(), child);
            }
        }
    }

    private void appendEmbedded(StringBuilder queryBuilder, String optionalMatch, EmbeddedAliasTree node) {
        if (node.getChildren().isEmpty()) {
            queryBuilder.append(optionalMatch);
        } else {
            for (EmbeddedAliasTree child : node.getChildren()) {
                StringBuilder builder = new StringBuilder(optionalMatch);
                CypherDSL.relationship(builder, child.getName());
                CypherDSL.node(builder, child.getAlias(), NodeLabel.EMBEDDED.name());
                this.appendEmbedded(queryBuilder, builder.toString(), child);
            }
        }
    }

    private void where(StringBuilder queryBuilder) {
        StringBuilder whereCondition = (StringBuilder)this.builder.build();
        if (whereCondition != null) {
            queryBuilder.append(" WHERE ");
            queryBuilder.append((CharSequence)whereCondition);
        }
    }

    private void orderBy(StringBuilder queryBuilder) {
        if (this.orderByExpressions != null && !this.orderByExpressions.isEmpty()) {
            queryBuilder.append(" ORDER BY ");
            int counter = 1;
            for (OrderByClause orderBy : this.orderByExpressions) {
                orderBy.asString(queryBuilder);
                if (counter++ >= this.orderByExpressions.size()) continue;
                queryBuilder.append(", ");
            }
        }
    }

    private void returns(StringBuilder builder, String targetAlias) {
        builder.append(" RETURN ");
        if (this.projections.isEmpty()) {
            CypherDSL.identifier(builder, targetAlias);
        } else {
            int counter = 1;
            for (String projection : this.projections) {
                if (this.embeddedPropertyProjection.contains(projection)) {
                    builder.append(projection);
                } else {
                    CypherDSL.identifier(builder, targetAlias, projection);
                    CypherDSL.as(builder, projection);
                }
                if (counter++ >= this.projections.size()) continue;
                builder.append(", ");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyPath(PropertyPath propertyPath) {
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_SELECT) {
            if (this.isSimpleProperty(propertyPath)) {
                this.projections.add(this.propertyHelper.getColumnName(this.targetTypeName, (List<String>)propertyPath.getNodeNamesWithoutAlias()));
                return;
            } else {
                if (!this.isNestedProperty(propertyPath)) return;
                if (!this.propertyHelper.isEmbeddedProperty(this.targetTypeName, propertyPath)) throw new UnsupportedOperationException("Selecting associated properties not yet implemented.");
                String entityAlias = ((PathedPropertyReferenceSource)propertyPath.getNodes().get(0)).getName();
                String embeddedAlias = this.embeddedAliasResolver.createAliasForEmbedded(entityAlias, propertyPath.getNodeNamesWithoutAlias());
                String columnName = this.propertyHelper.getEmbeddeColumnName(this.targetTypeName, propertyPath.getNodeNamesWithoutAlias());
                String projection = CypherDSL.identifier(embeddedAlias, columnName);
                this.projections.add(projection);
                this.embeddedPropertyProjection.add(projection);
            }
            return;
        } else {
            this.propertyPath = propertyPath;
        }
    }

    private boolean isNestedProperty(PropertyPath propertyPath) {
        return propertyPath.getNodes().size() > 2 && ((PathedPropertyReferenceSource)propertyPath.getNodes().get(0)).isAlias();
    }

    private boolean isSimpleProperty(PropertyPath propertyPath) {
        return propertyPath.getNodes().size() == 1 && !propertyPath.getLastNode().isAlias() || propertyPath.getNodes().size() == 2 && ((PathedPropertyReferenceSource)propertyPath.getNodes().get(0)).isAlias();
    }

    protected void addSortField(PropertyPath propertyPath, String collateName, boolean isAscending) {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = new ArrayList<OrderByClause>();
        }
        String columnName = this.propertyHelper.getColumnName(this.targetType, (List<String>)propertyPath.getNodeNamesWithoutAlias());
        String alias = this.embeddedAliasResolver.findAliasForType(this.targetTypeName);
        OrderByClause order = new OrderByClause(alias, columnName, isAscending);
        this.orderByExpressions.add(order);
    }

    public void predicateLess(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS);
    }

    public void predicateLessOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS_OR_EQUAL);
    }

    public void predicateEquals(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
    }

    public void predicateNotEquals(String comparativePredicate) {
        this.builder.pushNotPredicate();
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
        this.builder.popBooleanPredicate();
    }

    public void predicateGreaterOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER_OR_EQUAL);
    }

    public void predicateGreater(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER);
    }

    private void addComparisonPredicate(String comparativePredicate, ComparisonPredicate.Type comparisonType) {
        Object comparisonValue = this.fromNamedQuery(comparativePredicate);
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addComparisonPredicate(property, comparisonType, comparisonValue);
    }

    public void predicateIn(List<String> list) {
        List<Object> values = this.fromNamedQuery(list);
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addInPredicate(property, values);
    }

    public void predicateBetween(String lower, String upper) {
        Object lowerComparisonValue = this.fromNamedQuery(lower);
        Object upperComparisonValue = this.fromNamedQuery(upper);
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addRangePredicate(property, lowerComparisonValue, upperComparisonValue);
    }

    public void predicateLike(String patternValue, Character escapeCharacter) {
        Object pattern = this.fromNamedQuery(patternValue);
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addLikePredicate(property, (String)pattern, escapeCharacter);
    }

    public void predicateIsNull() {
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addIsNullPredicate(property);
    }

    private Object fromNamedQuery(String comparativePredicate) {
        if (comparativePredicate.startsWith(":")) {
            return new Neo4jQueryParameter(comparativePredicate.substring(1));
        }
        return comparativePredicate;
    }

    private List<Object> fromNamedQuery(List<String> list) {
        ArrayList<Object> elements = new ArrayList<Object>(list.size());
        for (String string : list) {
            elements.add(this.fromNamedQuery(string));
        }
        return elements;
    }
}

