/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.EmbeddedAliasTree;

public class AliasResolver {
    private final Map<String, String> aliasByEntityName = new HashMap<String, String>();
    private final Map<String, EmbeddedAliasTree> embeddedAliases = new HashMap<String, EmbeddedAliasTree>();
    private final Set<String> optionalMatches = new HashSet<String>();
    private final Set<String> requiredMatches = new HashSet<String>();
    private int embeddedCounter = 0;

    public void registerEntityAlias(String entityName, String alias) {
        this.aliasByEntityName.put(entityName, alias);
    }

    public String findAliasForType(String entityType) {
        return this.aliasByEntityName.get(entityType);
    }

    public String createAliasForEmbedded(String entityAlias, List<String> propertyPathWithoutAlias, boolean optionalMatch) {
        EmbeddedAliasTree embeddedAlias = this.embeddedAliases.get(entityAlias);
        if (embeddedAlias == null) {
            embeddedAlias = new EmbeddedAliasTree(entityAlias, entityAlias);
            this.embeddedAliases.put(entityAlias, embeddedAlias);
        }
        for (int i = 0; i < propertyPathWithoutAlias.size() - 1; ++i) {
            String name = propertyPathWithoutAlias.get(i);
            EmbeddedAliasTree child = embeddedAlias.findChild(name);
            if (child == null) {
                ++this.embeddedCounter;
                String childAlias = "_" + entityAlias + this.embeddedCounter;
                child = new EmbeddedAliasTree(childAlias, name);
                embeddedAlias.addChild(child);
            }
            embeddedAlias = child;
        }
        if (optionalMatch && !this.requiredMatches.contains(embeddedAlias.getAlias())) {
            this.optionalMatches.add(embeddedAlias.getAlias());
        } else {
            this.requiredMatches.add(embeddedAlias.getAlias());
            this.optionalMatches.remove(embeddedAlias.getAlias());
        }
        return embeddedAlias.getAlias();
    }

    public String findAliasForEmbedded(String entityAlias, List<String> propertyPathWithoutAlias) {
        EmbeddedAliasTree aliasTree = this.embeddedAliases.get(entityAlias);
        if (aliasTree == null) {
            return null;
        }
        EmbeddedAliasTree embedded = aliasTree;
        for (int i = 0; i < propertyPathWithoutAlias.size() - 1; ++i) {
            if ((embedded = embedded.findChild(propertyPathWithoutAlias.get(i))) != null) continue;
            return null;
        }
        return embedded.getAlias();
    }

    public EmbeddedAliasTree getAliasTree(String entityAlias) {
        return this.embeddedAliases.get(entityAlias);
    }

    public boolean isOptionalMatch(String alias) {
        return this.optionalMatches.contains(alias);
    }
}

