/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParameter;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.query.parsing.impl.ParserPropertyHelper;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.type.Type;

public class Neo4jPropertyHelper
extends ParserPropertyHelper
implements PropertyHelper {
    public Neo4jPropertyHelper(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames) {
        super(sessionFactory, entityNames);
    }

    public Object convertToBackendType(String entityType, List<String> propertyPath, Object value) {
        if (value instanceof Neo4jQueryParameter) {
            return value;
        }
        return super.convertToBackendType(entityType, propertyPath, value);
    }

    public Object convertToLiteral(String entityType, List<String> propertyPath, Object value) {
        Type propertyType = this.getPropertyType(entityType, propertyPath);
        Object gridValue = this.convertToGridType(value, propertyType);
        return gridValue;
    }

    private Object convertToGridType(Object value, Type propertyType) {
        if (value instanceof Neo4jQueryParameter) {
            return value;
        }
        Tuple dummy = new Tuple();
        GridType gridType = this.typeTranslator().getType(propertyType);
        gridType.nullSafeSet(dummy, value, new String[]{"key"}, null);
        return dummy.get("key");
    }

    private TypeTranslator typeTranslator() {
        return (TypeTranslator)this.getSessionFactory().getServiceRegistry().getService(TypeTranslator.class);
    }

    public String getColumnName(String entityType, List<String> propertyPathWithoutAlias) {
        return this.getColumnName(this.getPersister(entityType), propertyPathWithoutAlias);
    }

    public String getColumnName(Class<?> entityType, List<String> propertyName) {
        OgmEntityPersister persister = (OgmEntityPersister)this.getSessionFactory().getEntityPersister(entityType.getName());
        return this.getColumnName(persister, propertyName);
    }

    private String getColumnName(OgmEntityPersister persister, List<String> propertyPathWithoutAlias) {
        if (this.isIdProperty(persister, propertyPathWithoutAlias)) {
            return this.getColumn(persister, propertyPathWithoutAlias);
        }
        String columnName = this.getColumn(persister, propertyPathWithoutAlias);
        if (this.isNestedProperty(propertyPathWithoutAlias)) {
            columnName = columnName.substring(columnName.lastIndexOf(46) + 1, columnName.length());
        }
        return columnName;
    }

    public boolean isIdProperty(String entityType, List<String> propertyPath) {
        return this.isIdProperty(this.getPersister(entityType), propertyPath);
    }

    public boolean isIdProperty(OgmEntityPersister persister, List<String> namesWithoutAlias) {
        String join = StringHelper.join(namesWithoutAlias, (String)".");
        Type propertyType = persister.getPropertyType(namesWithoutAlias.get(0));
        Object[] identifierColumnNames = persister.getIdentifierColumnNames();
        if (propertyType.isComponentType()) {
            String[] embeddedColumnNames;
            for (String embeddedColumn : embeddedColumnNames = persister.getPropertyColumnNames(join)) {
                if (ArrayHelper.contains((Object[])identifierColumnNames, (Object)embeddedColumn)) continue;
                return false;
            }
            return true;
        }
        return ArrayHelper.contains((Object[])identifierColumnNames, (Object)join);
    }
}

