/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jAliasResolver;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParameter;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.PropertyIdentifier;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.query.parsing.impl.ParserPropertyHelper;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;

public class Neo4jPropertyHelper
extends ParserPropertyHelper
implements PropertyHelper {
    private final Neo4jAliasResolver aliasResolver;

    public Neo4jPropertyHelper(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames, Neo4jAliasResolver aliasResolver) {
        super(sessionFactory, entityNames);
        this.aliasResolver = aliasResolver;
    }

    public Object convertToBackendType(String entityType, List<String> propertyPath, Object value) {
        if (value instanceof Neo4jQueryParameter) {
            return value;
        }
        return super.convertToBackendType(entityType, propertyPath, value);
    }

    public PropertyIdentifier getPropertyIdentifier(String entityType, List<String> propertyPath, int requiredDepth) {
        String entityAlias = this.aliasResolver.findAliasForType(entityType);
        String propertyEntityType = entityType;
        String propertyAlias = entityAlias;
        ArrayList<String> currentPropertyPath = new ArrayList<String>();
        List lastAssociationPath = Collections.emptyList();
        OgmEntityPersister currentPersister = this.getPersister(entityType);
        boolean isLastElementAssociation = false;
        int depth = 1;
        for (String property : propertyPath) {
            boolean optionalMatch;
            currentPropertyPath.add(property);
            Type currentPropertyType = this.getPropertyType(entityType, currentPropertyPath);
            boolean bl = optionalMatch = depth > requiredDepth;
            if (currentPropertyType.isAssociationType()) {
                AssociationType associationPropertyType = (AssociationType)currentPropertyType;
                Joinable associatedJoinable = associationPropertyType.getAssociatedJoinable(this.getSessionFactory());
                if (associatedJoinable.isCollection() && ((OgmCollectionPersister)associatedJoinable).getType().isComponentType()) {
                    propertyAlias = this.aliasResolver.createAliasForEmbedded(entityAlias, currentPropertyPath, optionalMatch);
                } else {
                    propertyEntityType = associationPropertyType.getAssociatedEntityName(this.getSessionFactory());
                    currentPersister = this.getPersister(propertyEntityType);
                    String targetNodeType = currentPersister.getEntityKeyMetadata().getTable();
                    propertyAlias = this.aliasResolver.createAliasForAssociation(entityAlias, currentPropertyPath, targetNodeType, optionalMatch);
                    lastAssociationPath = new ArrayList<String>(currentPropertyPath);
                    isLastElementAssociation = true;
                }
            } else if (currentPropertyType.isComponentType() && !this.isIdProperty(currentPersister, propertyPath.subList(lastAssociationPath.size(), propertyPath.size()))) {
                propertyAlias = this.aliasResolver.createAliasForEmbedded(entityAlias, currentPropertyPath, optionalMatch);
            } else {
                isLastElementAssociation = false;
            }
            ++depth;
        }
        String propertyName = isLastElementAssociation ? this.getSessionFactory().getEntityPersister(propertyEntityType).getIdentifierPropertyName() : this.getColumnName(propertyEntityType, propertyPath.subList(lastAssociationPath.size(), propertyPath.size()));
        return new PropertyIdentifier(propertyAlias, propertyName);
    }

    public String getColumnName(String entityType, List<String> propertyPathWithoutAlias) {
        return this.getColumnName(this.getPersister(entityType), propertyPathWithoutAlias);
    }

    public String getColumnName(Class<?> entityType, List<String> propertyName) {
        OgmEntityPersister persister = (OgmEntityPersister)this.getSessionFactory().getEntityPersister(entityType.getName());
        return this.getColumnName(persister, propertyName);
    }

    private String getColumnName(OgmEntityPersister persister, List<String> propertyPathWithoutAlias) {
        if (this.isIdProperty(persister, propertyPathWithoutAlias)) {
            return this.getColumn(persister, propertyPathWithoutAlias);
        }
        String columnName = this.getColumn(persister, propertyPathWithoutAlias);
        if (this.isNestedProperty(propertyPathWithoutAlias)) {
            columnName = columnName.substring(columnName.lastIndexOf(46) + 1, columnName.length());
        }
        return columnName;
    }

    public boolean isIdProperty(String entityType, List<String> propertyPath) {
        return this.isIdProperty(this.getPersister(entityType), propertyPath);
    }

    public boolean isIdProperty(OgmEntityPersister persister, List<String> namesWithoutAlias) {
        String join = StringHelper.join(namesWithoutAlias, (String)".");
        Type propertyType = persister.getPropertyType(namesWithoutAlias.get(0));
        Object[] identifierColumnNames = persister.getIdentifierColumnNames();
        if (propertyType.isComponentType()) {
            String[] embeddedColumnNames;
            for (String embeddedColumn : embeddedColumnNames = persister.getPropertyColumnNames(join)) {
                if (ArrayHelper.contains((Object[])identifierColumnNames, (Object)embeddedColumn)) continue;
                return false;
            }
            return true;
        }
        return ArrayHelper.contains((Object[])identifierColumnNames, (Object)join);
    }

    private EntityKeyMetadata getKeyMetaData(String entityType) {
        OgmEntityPersister persister = (OgmEntityPersister)this.getSessionFactory().getEntityPersister(entityType);
        return persister.getEntityKeyMetadata();
    }
}

