/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.transaction.impl;

import org.hibernate.ogm.datastore.neo4j.impl.Neo4jDatastoreProvider;
import org.hibernate.ogm.transaction.impl.ForwardingTransactionCoordinator;
import org.hibernate.ogm.transaction.impl.ForwardingTransactionDriver;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;

public class Neo4jLocalTransactionCoordinator
extends ForwardingTransactionCoordinator {
    private final GraphDatabaseService graphDB;
    private Transaction tx = null;

    public Neo4jLocalTransactionCoordinator(TransactionCoordinator delegate, Neo4jDatastoreProvider graphDb) {
        super(delegate);
        this.graphDB = graphDb.getDataBase();
    }

    public TransactionCoordinator.TransactionDriver getTransactionDriverControl() {
        TransactionCoordinator.TransactionDriver driver = super.getTransactionDriverControl();
        return new Neo4jTransactionDriver(driver);
    }

    private void success() {
        if (this.tx != null) {
            this.tx.success();
            this.close();
        }
    }

    private void failure() {
        if (this.tx != null) {
            this.tx.failure();
            this.close();
        }
    }

    private void close() {
        try {
            this.tx.close();
        }
        finally {
            this.tx = null;
        }
    }

    private class Neo4jTransactionDriver
    extends ForwardingTransactionDriver {
        public Neo4jTransactionDriver(TransactionCoordinator.TransactionDriver delegate) {
            super(delegate);
        }

        public void begin() {
            super.begin();
            if (Neo4jLocalTransactionCoordinator.this.tx == null) {
                Neo4jLocalTransactionCoordinator.this.tx = Neo4jLocalTransactionCoordinator.this.graphDB.beginTx();
            }
        }

        public void commit() {
            try {
                super.commit();
                Neo4jLocalTransactionCoordinator.this.success();
            }
            catch (Exception e) {
                try {
                    this.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }

        public void rollback() {
            try {
                super.rollback();
            }
            finally {
                Neo4jLocalTransactionCoordinator.this.failure();
            }
        }
    }
}

