/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl;

import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jMapsTupleIterator;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jTupleSnapshot;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;

public class EmbeddedNeo4jNodesTupleIterator
extends EmbeddedNeo4jMapsTupleIterator {
    private final EntityKeyMetadata entityKeyMetadata;
    private final TupleContext tupleContext;

    public EmbeddedNeo4jNodesTupleIterator(Result result, EntityKeyMetadata entityKeyMetadata, TupleContext tupleContext) {
        super(result);
        this.entityKeyMetadata = entityKeyMetadata;
        this.tupleContext = tupleContext;
    }

    @Override
    protected Tuple convert(Map<String, Object> next) {
        return this.createTuple((Node)next.values().iterator().next());
    }

    private Tuple createTuple(Node node) {
        return new Tuple((TupleSnapshot)EmbeddedNeo4jTupleSnapshot.fromNode(node, this.tupleContext.getTupleTypeContext().getAllAssociatedEntityKeyMetadata(), this.tupleContext.getTupleTypeContext().getAllRoles(), this.entityKeyMetadata), Tuple.SnapshotType.UPDATE);
    }
}

