/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.util.impl.EmbeddedHelper;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class EmbeddedNeo4jTupleAssociationSnapshot
implements TupleSnapshot {
    private final Map<String, Object> properties;

    public EmbeddedNeo4jTupleAssociationSnapshot(Relationship relationship, AssociationKey associationKey, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        this.properties = EmbeddedNeo4jTupleAssociationSnapshot.collectProperties(relationship, associationKey, associatedEntityKeyMetadata);
    }

    private static Map<String, Object> collectProperties(Relationship relationship, AssociationKey associationKey, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String[] rowKeyColumnNames = associationKey.getMetadata().getRowKeyColumnNames();
        Node ownerNode = EmbeddedNeo4jTupleAssociationSnapshot.findOwnerNode(relationship, associationKey);
        Node targetNode = EmbeddedNeo4jTupleAssociationSnapshot.findTargetNode(relationship, associationKey, ownerNode);
        for (int i = 0; i < rowKeyColumnNames.length; ++i) {
            if (!relationship.hasProperty(rowKeyColumnNames[i])) continue;
            properties.put(rowKeyColumnNames[i], relationship.getProperty(rowKeyColumnNames[i]));
        }
        for (String associationColumn : associatedEntityKeyMetadata.getAssociationKeyColumns()) {
            String targetColumnName = associatedEntityKeyMetadata.getCorrespondingEntityKeyColumn(associationColumn);
            if (EmbeddedHelper.isPartOfEmbedded((String)targetColumnName)) {
                String collectionRole = associationKey.getMetadata().getCollectionRole();
                if (targetColumnName.equals(collectionRole)) {
                    if (!targetNode.hasProperty(targetColumnName = targetColumnName.substring(targetColumnName.lastIndexOf(".") + 1))) continue;
                    properties.put(associationColumn, targetNode.getProperty(targetColumnName));
                    continue;
                }
                if (targetNode.hasProperty(targetColumnName)) {
                    properties.put(associationColumn, targetNode.getProperty(targetColumnName));
                    continue;
                }
                Node embeddedNode = targetNode;
                if (targetColumnName.startsWith(collectionRole)) {
                    targetColumnName = targetColumnName.substring(collectionRole.length() + 1);
                }
                String[] split = EmbeddedHelper.split((String)targetColumnName);
                boolean found = true;
                for (int i = 0; i < split.length - 1; ++i) {
                    Iterator iterator = embeddedNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{DynamicRelationshipType.withName((String)split[i])}).iterator();
                    if (!iterator.hasNext()) {
                        found = false;
                        break;
                    }
                    embeddedNode = ((Relationship)iterator.next()).getEndNode();
                }
                if (!found || !embeddedNode.hasProperty(targetColumnName = targetColumnName.substring(targetColumnName.lastIndexOf(".") + 1))) continue;
                properties.put(associationColumn, embeddedNode.getProperty(targetColumnName));
                continue;
            }
            if (!targetNode.hasProperty(targetColumnName)) continue;
            properties.put(associationColumn, targetNode.getProperty(targetColumnName));
        }
        for (int i = 0; i < associationKey.getColumnNames().length; ++i) {
            if (!ownerNode.hasProperty(associationKey.getEntityKey().getColumnNames()[i])) continue;
            properties.put(associationKey.getColumnNames()[i], ownerNode.getProperty(associationKey.getEntityKey().getColumnNames()[i]));
        }
        return properties;
    }

    private static Node findTargetNode(Relationship relationship, AssociationKey associationKey, Node ownerNode) {
        if (EmbeddedNeo4jTupleAssociationSnapshot.isEmbeddedCollection(associationKey)) {
            return relationship.getEndNode();
        }
        return relationship.getOtherNode(ownerNode);
    }

    private static Node findOwnerNode(Relationship relationship, AssociationKey associationKey) {
        if (EmbeddedNeo4jTupleAssociationSnapshot.isEmbeddedCollection(associationKey)) {
            String collectionRole = associationKey.getMetadata().getCollectionRole();
            return EmbeddedNeo4jTupleAssociationSnapshot.embeddedAssociationOwner(relationship, collectionRole);
        }
        return EmbeddedNeo4jTupleAssociationSnapshot.ownerNodeFromAssociation(associationKey, relationship);
    }

    private static boolean isEmbeddedCollection(AssociationKey associationKey) {
        return associationKey.getMetadata().getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION;
    }

    private static Node embeddedAssociationOwner(Relationship relationship, String collectionRole) {
        if (EmbeddedHelper.isPartOfEmbedded((String)collectionRole)) {
            String[] split = EmbeddedHelper.split((String)collectionRole);
            Node ownerNode = relationship.getStartNode();
            for (int i = 1; i < split.length; ++i) {
                String type = split[split.length - i - 1];
                Relationship next = (Relationship)ownerNode.getRelationships(Direction.INCOMING, new RelationshipType[]{DynamicRelationshipType.withName((String)type)}).iterator().next();
                ownerNode = next.getStartNode();
            }
            return ownerNode;
        }
        return relationship.getStartNode();
    }

    private static Node ownerNodeFromAssociation(AssociationKey associationKey, Relationship relationship) {
        if (relationship.getStartNode().hasLabel(DynamicLabel.label((String)associationKey.getEntityKey().getTable()))) {
            return relationship.getStartNode();
        }
        return relationship.getEndNode();
    }

    public Object get(String column) {
        return this.properties.get(column);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Set<String> getColumnNames() {
        return this.properties.keySet();
    }
}

