/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl;

import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jAssociatedNodesHelper;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jEntityQueries;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jTupleSnapshot;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.NodeWithEmbeddedNodes;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.types.Node;

public class BoltNeo4jNodesTupleIterator
implements ClosableIterator<Tuple> {
    private final EntityKeyMetadata entityKeyMetadata;
    private final BoltNeo4jEntityQueries entityQueries;
    private final TupleTypeContext tupleTypeContext;
    private final ClosableIterator<NodeWithEmbeddedNodes> entities;
    private final Transaction tx;

    public BoltNeo4jNodesTupleIterator(Transaction tx, BoltNeo4jEntityQueries entityQueries, EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext, ClosableIterator<NodeWithEmbeddedNodes> entities) {
        this.tx = tx;
        this.entityQueries = entityQueries;
        this.entityKeyMetadata = entityKeyMetadata;
        this.tupleTypeContext = tupleTypeContext;
        this.entities = entities;
    }

    private Tuple createTuple(NodeWithEmbeddedNodes node) {
        Map<String, Node> toOneEntities = BoltNeo4jAssociatedNodesHelper.findAssociatedNodes(this.tx, node, this.entityKeyMetadata, this.tupleTypeContext, this.entityQueries);
        return new Tuple((TupleSnapshot)new BoltNeo4jTupleSnapshot(node, this.entityKeyMetadata, toOneEntities, this.tupleTypeContext), Tuple.SnapshotType.UPDATE);
    }

    public boolean hasNext() {
        return this.entities.hasNext();
    }

    public Tuple next() {
        NodeWithEmbeddedNodes node = (NodeWithEmbeddedNodes)this.entities.next();
        return this.createTuple(node);
    }

    public void remove() {
        this.entities.remove();
    }

    public void close() {
        this.entities.close();
    }
}

